<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - BKD PD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --pks-orange: #F0833A;
            --pks-orange-dark: #E67E22;
            --pks-orange-light: #F39C12;
            --pks-orange-lighter: #FDEBD0;
            --pks-gray: #424242;
            --pks-gray-light: #757575;
        }
        
        body {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(255, 87, 34, 0.2);
            backdrop-filter: blur(10px);
        }
        .login-header {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            color: white;
            border-radius: 20px 20px 0 0;
            padding: 2rem;
            text-align: center;
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 12px 15px;
        }
        .form-control:focus {
            border-color: var(--pks-orange);
            box-shadow: 0 0 0 0.2rem rgba(255, 87, 34, 0.25);
        }
        .btn-login {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            border: none;
            border-radius: 10px;
            padding: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 87, 34, 0.4);
        }
        .input-group-text {
            background: transparent;
            border: 2px solid #e9ecef;
            border-right: none;
            border-radius: 10px 0 0 10px;
        }
        .input-group .form-control {
            border-left: none;
            border-radius: 0 10px 10px 0;
        }
        .input-group .form-control:focus {
            border-left: none;
        }
        
        /* Additional PKS Theme Styles */
        .login-card {
            border: 2px solid rgba(255, 87, 34, 0.1);
        }
        
        .input-group-text {
            color: var(--pks-orange);
        }
        
        .form-check-input:checked {
            background-color: var(--pks-orange);
            border-color: var(--pks-orange);
        }
        
        .text-decoration-none {
            color: var(--pks-orange) !important;
            font-weight: 500;
        }
        
        .text-decoration-none:hover {
            color: var(--pks-orange-dark) !important;
        }
        
        /* Floating animation for icon */
        .login-header i {
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card login-card border-0">
                    <div class="login-header">
                        <div class="mb-3">
                            <i class="fas fa-users fa-3x"></i>
                        </div>
                        <h3 class="mb-1">BKD PD</h3>
                        <p class="mb-1">Sistem Informasi Anggota</p>
                        <small class="text-white-50">Partai Keadilan Sejahtera</small>
                    </div>
                    <div class="card-body p-4">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-envelope"></i>
                                    </span>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           id="email" 
                                           name="email" 
                                           value="{{ old('email') }}" 
                                           placeholder="Masukkan email Anda"
                                           required>
                                </div>
                                @error('email')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-lock"></i>
                                    </span>
                                    <input type="password" 
                                           class="form-control @error('password') is-invalid @enderror" 
                                           id="password" 
                                           name="password" 
                                           placeholder="Masukkan password Anda"
                                           required>
                                </div>
                                @error('password')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="remember" name="remember">
                                <label class="form-check-label" for="remember">
                                    Ingat saya
                                </label>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-login">
                                    <i class="fas fa-sign-in-alt me-2"></i>Login
                                </button>
                            </div>
                        </form>

                        
                        <!-- Demo Credentials -->
                        <div class="mt-4 p-3" style="background-color: #f8f9fa; border-radius: 10px; border-left: 4px solid var(--pks-orange);">
                            <h6 class="text-muted mb-2"><i class="fas fa-info-circle me-1"></i> Demo Credentials:</h6>
                            <small class="text-muted d-block">
                                <strong>Super Admin:</strong> superadmin@bkd.com / password123
                            </small>
                            <small class="text-muted d-block">
                                <strong>Admin:</strong> admin@bkd.com / password123
                            </small>
                            <small class="text-muted d-block">
                                <strong>User:</strong> user@bkd.com / password123
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
