@extends('layouts.app')

@section('title', 'Detail Anggota - Sistem Informasi PKS')

@section('content')
<!-- Success/Error Messages -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="row mb-4">
    <div class="col-md-8">
        <h1 class="h3 text-gray-800 mb-0">Detail Anggota</h1>
        <p class="text-muted">Informasi lengkap anggota PKS</p>
    </div>
    <div class="col-md-4 text-end">
        <div class="btn-group" role="group">
            <a href="{{ route('anggota.keanggotaan.show', $anggota->id) }}" class="btn btn-info">
                <i class="fas fa-users me-1"></i> Data Keanggotaan
            </a>
            <a href="{{ $anggota->edit_url }}" class="btn btn-warning">
                <i class="fas fa-edit me-1"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" 
                    onclick="confirmDelete('{{ $anggota->url_slug }}', '{{ $anggota->nama_lengkap }}')">
                <i class="fas fa-trash me-1"></i> Hapus
            </button>
        </div>
        <div class="mt-2">
            <a href="{{ route('anggota.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Profile Card -->
    <div class="col-md-4 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 text-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-user-circle me-2"></i>Profil Anggota
                </h6>
            </div>
            <div class="card-body text-center">
                @if($anggota->foto && file_exists(public_path('storage/' . $anggota->foto)))
                    <img src="{{ url('storage/' . $anggota->foto) }}?v={{ $anggota->updated_at ? $anggota->updated_at->timestamp : time() }}" 
                         alt="Foto {{ $anggota->nama_lengkap }}"
                         class="rounded-circle mb-3" 
                         style="width: 150px; height: 150px; object-fit: cover; border: 4px solid #F0833A;">
                @else
                    <div class="rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                         style="width: 150px; height: 150px; background: linear-gradient(135deg, #F0833A, #E67E22);">
                        <i class="fas fa-user fa-4x text-white"></i>
                    </div>
                @endif
                
                <!-- Tombol Ubah Foto -->
                <div class="mb-3">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#ubahFotoModal">
                        <i class="fas fa-camera me-1"></i> Ubah Foto
                    </button>
                </div>
                
                <h5 class="text-primary mb-1">{{ $anggota->nama_lengkap }}</h5>
                <p class="text-muted mb-2">{{ $anggota->nomor_identitas_anggota }}</p>
                
                <div class="row text-center mb-3">
                    <div class="col-6">
                        <span class="badge bg-{{ $anggota->status_keanggotaan == 'Aktif' ? 'success' : ($anggota->status_keanggotaan == 'Tidak Aktif' ? 'warning' : 'danger') }} p-2">
                            {{ $anggota->status_keanggotaan }}
                        </span>
                    </div>
                    <div class="col-6">
                        <span class="badge bg-secondary p-2">{{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota }}</span>
                    </div>
                </div>
                
                <div class="row text-center">
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            @if($anggota->tanggal_lahir)
                                {{ \Carbon\Carbon::parse($anggota->tanggal_lahir)->age }}
                            @else
                                -
                            @endif
                        </div>
                        <small class="text-muted">Tahun</small>
                    </div>
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            {{ $anggota->absensiKegiatan ? $anggota->absensiKegiatan->where('status_kehadiran', 'Hadir')->count() : 0 }}
                        </div>
                        <small class="text-muted">Kegiatan</small>
                    </div>
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            {{ $anggota->mutasi ? $anggota->mutasi->count() : 0 }}
                        </div>
                        <small class="text-muted">Mutasi</small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Contact -->
        @if($anggota->no_telepon || $anggota->email)
        <div class="card shadow mt-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-address-book me-2"></i>Kontak Cepat
                </h6>
            </div>
            <div class="card-body">
                @if($anggota->no_telepon)
                    <a href="tel:{{ $anggota->no_telepon }}" class="btn btn-success btn-sm w-100 mb-2">
                        <i class="fas fa-phone me-2"></i>{{ $anggota->no_telepon }}
                    </a>
                @endif
                @if($anggota->email)
                    <a href="mailto:{{ $anggota->email }}" class="btn btn-info btn-sm w-100">
                        <i class="fas fa-envelope me-2"></i>{{ $anggota->email }}
                    </a>
                @endif
            </div>
        </div>
        @endif
    </div>
    
    <!-- Detail Information -->
    <div class="col-md-8">
        <!-- Data Identitas -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-id-card me-2"></i>Data Identitas
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td class="fw-bold text-muted">NIA:</td>
                                <td>{{ $anggota->nomor_identitas_anggota }}</td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Nama Lengkap:</td>
                                <td>{{ $anggota->nama_lengkap }}</td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Tempat, Tanggal Lahir:</td>
                                <td>
                                    {{ $anggota->tempat_lahir }}, 
                                    @if($anggota->tanggal_lahir)
                                        {{ $anggota->tanggal_lahir->format('d F Y') }}
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Jenis Kelamin:</td>
                                <td>
                                    <span class="badge bg-{{ $anggota->jenis_kelamin == 'L' ? 'info' : 'danger' }}">
                                        {{ $anggota->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td class="fw-bold text-muted">Umur:</td>
                                <td>
                                    @if($anggota->tanggal_lahir)
                                        {{ \Carbon\Carbon::parse($anggota->tanggal_lahir)->age }} tahun
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Jenjang:</td>
                                <td><span class="badge bg-secondary">{{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota }}</span></td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">UPA:</td>
                                <td>
                                    @if($anggota->upa)
                                        <span class="badge bg-primary">{{ $anggota->upa->nama_upa }}</span>
                                        @if($anggota->upa->dpc)
                                            <br><small class="text-muted">DPC: {{ $anggota->upa->dpc->nama_dpc }}</small>
                                        @endif
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Keahlian:</td>
                                <td>
                                    @if($anggota->keahlian && $anggota->keahlian->count() > 0)
                                        @foreach($anggota->keahlian as $keahlian)
                                            <span class="badge bg-info me-1 mb-1">{{ $keahlian->nama_keahlian }}</span>
                                        @endforeach
                                    @endif
                                    @if($anggota->keahlian_lainnya)
                                        <div class="mt-2">
                                            <small class="text-muted fw-bold">Keahlian Lainnya:</small><br>
                                            <span class="text-dark">{{ $anggota->keahlian_lainnya }}</span>
                                        </div>
                                    @endif
                                    @if((!$anggota->keahlian || $anggota->keahlian->count() == 0) && !$anggota->keahlian_lainnya)
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Aktivitas di Luar Pekerjaan:</td>
                                <td>
                                    @php
                                        $hasAktivitas = false;
                                    @endphp
                                    
                                    @if($anggota->aktivitasLuar && $anggota->aktivitasLuar->count() > 0)
                                        @php $hasAktivitas = true; @endphp
                                        <ul class="list-unstyled mb-0">
                                            @foreach($anggota->aktivitasLuar as $aktivitas)
                                                <li class="mb-1">
                                                    <i class="fas fa-circle text-primary me-2" style="font-size: 0.5rem;"></i>
                                                    {{ $aktivitas->nama_aktivitas }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                    
                                    @if($anggota->aktivitas && $anggota->aktivitas->count() > 0)
                                        @php $hasAktivitas = true; @endphp
                                        @if($anggota->aktivitasLuar && $anggota->aktivitasLuar->count() > 0)
                                            <ul class="list-unstyled mb-0 mt-2">
                                        @else
                                            <ul class="list-unstyled mb-0">
                                        @endif
                                            @foreach($anggota->aktivitas as $aktivitas)
                                                <li class="mb-1">
                                                    <i class="fas fa-circle text-warning me-2" style="font-size: 0.5rem;"></i>
                                                    {{ $aktivitas->uraian_aktivitas }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                    
                                    @if(!$hasAktivitas)
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Tanggal Bergabung:</td>
                                <td>
                                    @if($anggota->tanggal_bergabung)
                                        {{ $anggota->tanggal_bergabung->format('d F Y') }}
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Lama Keanggotaan:</td>
                                <td>
                                    @if($anggota->tanggal_bergabung)
                                        {{ $anggota->tanggal_bergabung->diffForHumans() }}
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Alamat -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-map-marker-alt me-2"></i>Alamat Lengkap
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <i class="fas fa-home text-primary me-2"></i>
                            <strong>
                                {{ $anggota->alamat_jalan }}
                                @if($anggota->rt && $anggota->rw), RT {{ $anggota->rt }}/RW {{ $anggota->rw }}@endif
                                @if($anggota->kelurahan), {{ $anggota->kelurahan }}@endif
                                @if($anggota->kecamatan), {{ $anggota->kecamatan }}@endif
                                @if($anggota->kota), {{ $anggota->kota }}@endif
                                @if($anggota->provinsi), {{ $anggota->provinsi }}@endif
                            </strong>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless table-sm">
                                    <tr>
                                        <td class="fw-bold text-muted">RT/RW:</td>
                                        <td>{{ $anggota->rt ?? '-' }}/{{ $anggota->rw ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kelurahan:</td>
                                        <td>{{ $anggota->kelurahan ?? '-' }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless table-sm">
                                    <tr>
                                        <td class="fw-bold text-muted">Kecamatan:</td>
                                        <td>{{ $anggota->kecamatan ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kota/Provinsi:</td>
                                        <td>{{ $anggota->kota ?? '-' }}, {{ $anggota->provinsi ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kode Pos:</td>
                                        <td>{{ $anggota->kode_pos ?? '-' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Ekonomi -->
        @if($anggota->penghasilan_per_bulan || $anggota->muzaki_mustahiq || $anggota->nomor_identitas_pasangan)
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-money-bill-wave me-2"></i>Informasi Ekonomi
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    @if($anggota->penghasilan_per_bulan)
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-wallet fa-2x text-success mb-2"></i>
                            <div class="fw-bold">Rp {{ number_format($anggota->penghasilan_per_bulan, 0, ',', '.') }}</div>
                            <small class="text-muted">Penghasilan per Bulan</small>
                        </div>
                    </div>
                    @endif
                    @if($anggota->muzaki_mustahiq)
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-hand-holding-heart fa-2x text-primary mb-2"></i>
                            <div class="fw-bold">{{ $anggota->muzaki_mustahiq }}</div>
                            <small class="text-muted">Status Zakat</small>
                        </div>
                    </div>
                    @endif
                    @if($anggota->nomor_identitas_pasangan)
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-heart fa-2x text-danger mb-2"></i>
                            <div class="fw-bold">{{ $anggota->nomor_identitas_pasangan }}</div>
                            <small class="text-muted">NIA Pasangan</small>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @endif

        <!-- Catatan/Profil -->
        @if($anggota->catatan_profil)
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-sticky-note me-2"></i>Catatan/Profil
                </h6>
            </div>
            <div class="card-body">
                <p class="mb-0">{{ $anggota->catatan_profil }}</p>
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Riwayat Aktivitas -->
<div class="row">
    <!-- Riwayat Jenjang -->
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-users me-2"></i>Riwayat Jenjang
                </h6>
                <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#jenjangModal">
                    <i class="fas fa-plus me-1"></i>Tambah Jenjang
                </button>
            </div>
            <div class="card-body">
                @if($anggota->jenjangHistory && $anggota->jenjangHistory->count() > 0)
                    <div class="timeline">
                        @foreach($anggota->jenjangHistory->sortByDesc('tanggal_perubahan')->take(3) as $history)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info">
                                <i class="fas fa-user-edit"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">
                                    @if($history->refJenjang)
                                        {{ $history->refJenjang->jenjang }}
                                    @else
                                        Jenjang
                                    @endif
                                </div>
                                <div class="small text-muted">
                                    @if($history->tanggal_perubahan)
                                        {{ $history->tanggal_perubahan->format('d M Y') }}
                                    @else
                                        -
                                    @endif
                                </div>
                                <div class="small">
                                    @if($history->upa)
                                        <span class="badge bg-info">{{ $history->upa->nama_upa }}</span>
                                    @endif
                                    @if($history->dpc)
                                        <span class="badge bg-success">{{ $history->dpc->nama_dpc }}</span>
                                    @endif
                                </div>
                                @if($history->keterangan)
                                    <div class="small text-muted">{{ Str::limit($history->keterangan, 30) }}</div>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @if($anggota->jenjangHistory->count() > 3)
                        <div class="text-center mt-3">
                            <a href="{{ route('anggota.keanggotaan.show', $anggota->id) }}" class="btn btn-outline-primary btn-sm">
                                Lihat Semua ({{ $anggota->jenjangHistory->count() }})
                            </a>
                        </div>
                    @endif
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-users fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat jenjang</p>
                    </div>
                @endif
            </div>
        </div>
    </div>


    <!-- Kegiatan Terakhir -->
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calendar-check me-2"></i>Kegiatan Terakhir
                </h6>
                <span class="badge bg-light text-dark">
                    Total: {{ $anggota->absensiKegiatan ? $anggota->absensiKegiatan->count() : 0 }} kegiatan
                </span>
            </div>
            <div class="card-body">
                @if($anggota->absensiKegiatan && $anggota->absensiKegiatan->count() > 0)
                    @foreach($anggota->absensiKegiatan->sortByDesc('created_at')->take(5) as $absensi)
                    <div class="d-flex align-items-center py-2 border-bottom">
                        <div class="me-3">
                            <span class="badge bg-{{ $absensi->status_kehadiran == 'Hadir' ? 'success' : ($absensi->status_kehadiran == 'Izin' ? 'warning' : 'danger') }}">
                                {{ $absensi->status_kehadiran ?? 'Unknown' }}
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-bold">
                                @if($absensi->kegiatan)
                                    {{ $absensi->kegiatan->nama_kegiatan }}
                                @else
                                    Kegiatan tidak ditemukan
                                @endif
                            </div>
                            <div class="small text-muted">
                                {{ $absensi->kegiatan->tanggal_mulai ? $absensi->kegiatan->tanggal_mulai->format('d M Y') : '-' }}
                                @if($absensi->waktu_absen)
                                    - Absen: {{ $absensi->waktu_absen->format('H:i') }}
                                @endif
                            </div>
                        </div>
                    </div>
                    @endforeach
                    @if($anggota->absensiKegiatan->count() > 5)
                        <div class="text-center mt-3">
                            <a href="{{ route('kegiatan.index') }}" class="btn btn-outline-primary btn-sm">
                                Lihat Semua Kegiatan
                            </a>
                        </div>
                    @endif
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum mengikuti kegiatan</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Riwayat Perpindahan Section -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exchange-alt me-2"></i>Riwayat Perpindahan
                </h6>
                <a href="{{ route('surat-penempatan.create', ['anggota_id' => $anggota->id]) }}" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>Buat Surat Penempatan
                </a>
            </div>
            <div class="card-body">
                @if($anggota->riwayatPerpindahan->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Tipe</th>
                                    <th>Dari</th>
                                    <th>Ke</th>
                                    <th>Pembimbing</th>
                                    <th>Status</th>
                                    <th>Nomor Surat</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($anggota->riwayatPerpindahan->sortByDesc('tanggal_efektif') as $riwayat)
                                <tr>
                                    <td>
                                        <span class="badge bg-info">
                                            {{ $riwayat->tanggal_efektif ? $riwayat->tanggal_efektif->format('d M Y') : '-' }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $riwayat->tipe_transaksi == 'penempatan' ? 'success' : ($riwayat->tipe_transaksi == 'mutasi' ? 'warning' : 'info') }}">
                                            {{ ucfirst($riwayat->tipe_transaksi) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($riwayat->upaAsal)
                                            <div class="small">
                                                <strong>{{ $riwayat->upaAsal->nama_upa }}</strong><br>
                                                <span class="text-muted">{{ $riwayat->dpcAsal->nama_dpc ?? '-' }}</span>
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($riwayat->upaTujuan)
                                            <div class="small">
                                                <strong>{{ $riwayat->upaTujuan->nama_upa }}</strong><br>
                                                <span class="text-muted">{{ $riwayat->dpcTujuan->nama_dpc ?? '-' }}</span>
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="small">
                                            @if($riwayat->pembimbingLama)
                                                <div class="text-muted">Dari: {{ $riwayat->pembimbingLama->nama_lengkap }}</div>
                                            @endif
                                            @if($riwayat->pembimbingBaru)
                                                <div class="text-success">Ke: {{ $riwayat->pembimbingBaru->nama_lengkap }}</div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $riwayat->status == 'completed' ? 'success' : ($riwayat->status == 'pending' ? 'warning' : 'secondary') }}">
                                            {{ ucfirst($riwayat->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $riwayat->nomor_surat }}</small>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-exchange-alt fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat perpindahan</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Riwayat Mutasi -->
<div class="row">
    <div class="col-12 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-history me-2"></i>Riwayat Mutasi
                </h6>
                <a href="{{ route('mutasi.create') }}" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>Tambah Mutasi
                </a>
            </div>
            <div class="card-body">
                @if($anggota->mutasi && $anggota->mutasi->count() > 0)
                    <div class="timeline">
                        @foreach($anggota->mutasi->sortByDesc('tanggal_mutasi')->take(5) as $mutasi)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-{{ $mutasi->jenis_mutasi == 'Masuk' ? 'success' : ($mutasi->jenis_mutasi == 'Keluar' ? 'danger' : 'info') }}">
                                <i class="fas fa-{{ $mutasi->jenis_mutasi == 'Masuk' ? 'user-plus' : ($mutasi->jenis_mutasi == 'Keluar' ? 'user-minus' : 'exchange-alt') }}"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">{{ $mutasi->jenis_mutasi ?? 'Unknown' }}</div>
                                <div class="small text-muted">
                                    @if($mutasi->tanggal_mutasi)
                                        {{ $mutasi->tanggal_mutasi->format('d M Y') }}
                                    @else
                                        -
                                    @endif
                                </div>
                                <div class="small">{{ Str::limit($mutasi->alasan_mutasi ?? 'Tidak ada keterangan', 50) }}</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @if($anggota->mutasi->count() > 5)
                        <div class="text-center mt-3">
                            <a href="{{ route('mutasi.index') }}" class="btn btn-outline-primary btn-sm">
                                Lihat Semua ({{ $anggota->mutasi->count() }})
                            </a>
                        </div>
                    @endif
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-history fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat mutasi</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle me-2"></i>Konfirmasi Hapus
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus anggota <strong id="memberName"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Peringatan:</strong> Tindakan ini akan menghapus semua data terkait anggota.
                </div>
                <p class="text-danger fw-bold">Tindakan ini tidak dapat dibatalkan!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-1"></i> Ya, Hapus Anggota
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -35px;
    top: 0;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 12px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: -20px;
    top: 15px;
    bottom: 0;
    width: 2px;
    background: #ddd;
}

.timeline-item:last-child::after {
    display: none;
}

.card-body table td {
    padding: 0.3rem 0.5rem;
    vertical-align: middle;
}
</style>
@endpush

<!-- Modal Ubah Foto -->
<div class="modal fade" id="ubahFotoModal" tabindex="-1" aria-labelledby="ubahFotoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="ubahFotoModalLabel">
                    <i class="fas fa-camera me-2"></i>Ubah Foto Profil
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('anggota.update-foto', $anggota->url_slug) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PATCH')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="foto" class="form-label">Pilih Foto Baru</label>
                        <input type="file" class="form-control" id="foto" name="foto" accept="image/*" required>
                        <div class="form-text">
                            Format yang didukung: JPG, PNG, GIF. Maksimal 4MB.
                        </div>
                    </div>
                    
                    <!-- Preview Foto -->
                    <div class="text-center">
                        <img id="fotoPreview" src="#" alt="Preview" class="rounded-circle" style="width: 150px; height: 150px; object-fit: cover; border: 4px solid #F0833A; display: none;">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload me-1"></i> Upload Foto
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Tambah/Edit Jenjang -->
<div class="modal fade" id="jenjangModal" tabindex="-1" aria-labelledby="jenjangModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jenjangModalLabel">
                    <i class="fas fa-users me-2"></i>Update Data Keanggotaan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('anggota.keanggotaan.update', $anggota->id) }}" method="POST" id="jenjangForm">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ref_jenjang_id" class="form-label">
                                    Jenjang Anggota <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('ref_jenjang_id') is-invalid @enderror" 
                                        id="ref_jenjang_id" name="ref_jenjang_id">
                                    <option value="">Pilih Jenjang</option>
                                    @foreach(\App\Models\RefJenjang::whereIn('jenjang', ['Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama'])->where('is_active', true)->orderByRaw("FIELD(jenjang, 'Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama')")->get() as $jenjang)
                                        <option value="{{ $jenjang->ref_jenjang_id }}" 
                                                {{ old('ref_jenjang_id', $anggota->ref_jenjang_id) == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                            {{ $jenjang->jenjang }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('ref_jenjang_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="dpc_id" class="form-label">
                                    DPC <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('dpc_id') is-invalid @enderror" 
                                        id="dpc_id" name="dpc_id">
                                    <option value="">Pilih DPC</option>
                                    @foreach(\App\Models\Dpc::orderBy('nama_dpc')->get() as $dpc)
                                        <option value="{{ $dpc->dpc_id }}" 
                                                {{ old('dpc_id', $anggota->dpc_id) == $dpc->dpc_id ? 'selected' : '' }}>
                                            {{ $dpc->nama_dpc }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('dpc_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="dpd_id" class="form-label">
                                    DPD <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('dpd_id') is-invalid @enderror" 
                                        id="dpd_id" name="dpd_id">
                                    <option value="">Pilih DPD</option>
                                    @foreach(\App\Models\Dpd::orderBy('nama_dpd')->get() as $dpd)
                                        <option value="{{ $dpd->dpd_id }}" 
                                                {{ old('dpd_id', $anggota->dpd_id) == $dpd->dpd_id ? 'selected' : '' }}>
                                            {{ $dpd->nama_dpd }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('dpd_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="upa_id" class="form-label">UPA</label>
                                <select class="form-select @error('upa_id') is-invalid @enderror" 
                                        id="upa_id" name="upa_id">
                                    <option value="">Pilih UPA</option>
                                    @foreach(\App\Models\Upa::orderBy('nama_upa')->get() as $upa)
                                        <option value="{{ $upa->upa_id }}" 
                                                {{ old('upa_id', $anggota->upa_id) == $upa->upa_id ? 'selected' : '' }}>
                                            {{ $upa->nama_upa }} ({{ $upa->kode_upa }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('upa_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status_keanggotaan" class="form-label">
                                    Status Keanggotaan <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('status_keanggotaan') is-invalid @enderror" 
                                        id="status_keanggotaan" name="status_keanggotaan">
                                    <option value="">Pilih Status</option>
                                    <option value="Aktif" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="Tidak Aktif" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                    <option value="Diberhentikan" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Diberhentikan' ? 'selected' : '' }}>Diberhentikan</option>
                                    <option value="Pindah" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Pindah' ? 'selected' : '' }}>Pindah</option>
                                </select>
                                @error('status_keanggotaan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_perubahan" class="form-label">
                                    Tanggal Perubahan <span class="text-danger">*</span>
                                </label>
                                <input type="date" 
                                       class="form-control @error('tanggal_perubahan') is-invalid @enderror" 
                                       id="tanggal_perubahan" 
                                       name="tanggal_perubahan" 
                                       value="{{ old('tanggal_perubahan', now()->format('Y-m-d')) }}">
                                @error('tanggal_perubahan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="keterangan" class="form-label">Keterangan Perubahan</label>
                                <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                          id="keterangan" 
                                          name="keterangan" 
                                          rows="2" 
                                          placeholder="Masukkan keterangan perubahan...">{{ old('keterangan') }}</textarea>
                                @error('keterangan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Perhatian:</strong> Data lama akan disimpan dalam history sebelum data baru disimpan.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
function confirmDelete(id, name) {
    document.getElementById('memberName').textContent = name;
    document.getElementById('deleteForm').action = `/anggota/${id}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

// Preview foto saat dipilih
document.getElementById('foto').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('fotoPreview');
            preview.src = e.target.result;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
});



// Form validation for jenjang modal
document.getElementById('jenjangForm').addEventListener('submit', function(e) {
    const requiredFields = ['ref_jenjang_id', 'dpc_id', 'dpd_id', 'status_keanggotaan', 'tanggal_perubahan'];
    let isValid = true;
    
    requiredFields.forEach(function(fieldName) {
        const field = document.getElementById(fieldName);
        if (!field.value) {
            field.classList.add('is-invalid');
            isValid = false;
        } else {
            field.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        alert('Mohon lengkapi semua field yang wajib diisi.');
    }
});
</script>
@endpush