@extends('layouts.app')

@section('title', 'Detail Aktivitas Luar')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-eye me-2"></i>Detail Aktivitas Luar
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="30%" class="text-muted">Nama Aktivitas:</th>
                                <td>
                                    <strong>{{ $aktivitasLuar->nama_aktivitas }}</strong>
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted">Status:</th>
                                <td>
                                    @if($aktivitasLuar->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-danger">Tidak Aktif</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted">Deskripsi:</th>
                                <td>
                                    @if($aktivitasLuar->deskripsi)
                                        {{ $aktivitasLuar->deskripsi }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted">Dibuat:</th>
                                <td>{{ $aktivitasLuar->created_at->format('d M Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th class="text-muted">Diupdate:</th>
                                <td>{{ $aktivitasLuar->updated_at->format('d M Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('aktivitas-luar.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Kembali
                    </a>
                    <div>
                        <a href="{{ route('aktivitas-luar.edit', $aktivitasLuar->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit
                        </a>
                        <form action="{{ route('aktivitas-luar.destroy', $aktivitasLuar->id) }}" 
                              method="POST" 
                              class="d-inline"
                              onsubmit="return confirm('Apakah Anda yakin ingin menghapus aktivitas ini?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash me-2"></i>Hapus
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
