@extends('layouts.app')

@section('title', 'Master Aktivitas Luar')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>Master Aktivitas Luar
                </h5>
                <a href="{{ route('aktivitas-luar.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Tambah Aktivitas
                </a>
            </div>
            <div class="card-body">
                @if($aktivitasLuars->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="aktivitasTable">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="30%">Nama Aktivitas</th>
                                    <th width="40%">Deskripsi</th>
                                    <th width="10%">Status</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($aktivitasLuars as $index => $aktivitas)
                                <tr>
                                    <td>{{ $aktivitasLuars->firstItem() + $index }}</td>
                                    <td>
                                        <strong>{{ $aktivitas->nama_aktivitas }}</strong>
                                    </td>
                                    <td>
                                        @if($aktivitas->deskripsi)
                                            {{ Str::limit($aktivitas->deskripsi, 50) }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($aktivitas->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Tidak Aktif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('aktivitas-luar.show', $aktivitas->id) }}" 
                                               class="btn btn-sm btn-outline-info" 
                                               title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('aktivitas-luar.edit', $aktivitas->id) }}" 
                                               class="btn btn-sm btn-outline-warning" 
                                               title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('aktivitas-luar.destroy', $aktivitas->id) }}" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('Apakah Anda yakin ingin menghapus aktivitas ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-danger" 
                                                        title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-3">
                        {{ $aktivitasLuars->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-list fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada aktivitas luar</h5>
                        <p class="text-muted">Klik tombol "Tambah Aktivitas" untuk menambahkan aktivitas baru.</p>
                        <a href="{{ route('aktivitas-luar.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Tambah Aktivitas Pertama
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#aktivitasTable').DataTable({
        responsive: true,
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Semua"]],
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.4/i18n/id.json'
        },
        columnDefs: [
            { orderable: false, targets: [4] }
        ]
    });
});
</script>
@endpush
