<?php

use App\Helpers\UrlHelper;

if (!function_exists('generate_slug')) {
    function generate_slug($name) {
        return UrlHelper::generateSlug($name);
    }
}

if (!function_exists('encrypt_id')) {
    function encrypt_id($id) {
        return UrlHelper::encryptId($id);
    }
}

if (!function_exists('decrypt_id')) {
    function decrypt_id($encryptedId) {
        return UrlHelper::decryptId($encryptedId);
    }
}

if (!function_exists('anggota_url')) {
    function anggota_url($id, $nama) {
        return UrlHelper::generateAnggotaUrl($id, $nama);
    }
}

if (!function_exists('anggota_route')) {
    function anggota_route($routeName, $id, $nama, $params = []) {
        return UrlHelper::anggotaRoute($routeName, $id, $nama, $params);
    }
}
