<?php

namespace App\View\Composers;

use Illuminate\View\View;
use Illuminate\Support\Facades\Cache;

class PerformanceViewComposer
{
    /**
     * Bind data to the view.
     */
    public function compose(View $view)
    {
        // Add performance data to all views
        $view->with([
            'performance' => [
                'cache_enabled' => config('optimization.cache.enabled', true),
                'lazy_loading' => config('optimization.lazy_loading.enabled', true),
                'minify_html' => config('optimization.view.minify_html', true),
            ],
            'app_version' => config('app.version', '1.0.0'),
            'load_time' => $this->getLoadTime(),
        ]);
    }

    /**
     * Get application load time
     */
    private function getLoadTime()
    {
        if (defined('LARAVEL_START')) {
            return round((microtime(true) - LARAVEL_START) * 1000, 2);
        }
        
        return null;
    }
}


