<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class YaumiyahRecord extends Model
{
    use HasFactory;

    protected $fillable = [
        'yaumiyah_activity_id',
        'anggota_id',
        'week_number',
        'year',
        'value',
        'notes',
        'created_by',
        'created_by_name'
    ];

    protected $casts = [
        'week_number' => 'integer',
        'year' => 'integer',
        'value' => 'integer'
    ];

    public function activity()
    {
        return $this->belongsTo(YaumiyahActivity::class, 'yaumiyah_activity_id');
    }

    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id', 'id');
    }
}
