<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UpaAgendaMaster extends Model
{
    use HasFactory;

    protected $table = 'upa_agenda_masters';
    protected $primaryKey = 'agenda_id';

    protected $fillable = [
        'nama_agenda',
        'deskripsi',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Relasi ke aktivitas grup UPA
    public function groupActivities()
    {
        return $this->hasMany(UpaGroupActivity::class, 'agenda_upa', 'nama_agenda');
    }
}
