<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Upa extends Model
{
    use HasFactory;

    protected $table = 'tbl_upa';
    protected $primaryKey = 'upa_id';

    protected $fillable = [
        'kode_upa',
        'nama_upa',
        'deskripsi',
        'alamat',
        'provinsi_id',
        'kota_id',
        'kecamatan_id',
        'kelurahan_id',
        'kode_pos',
        'no_telepon',
        'email',
        'tanggal_berdiri',
        'status',
        'catatan',
        'dpc_id'
    ];

    protected $casts = [
        'tanggal_berdiri' => 'date',
    ];

    // Relasi ke DPC
    public function dpc()
    {
        return $this->belongsTo(Dpc::class, 'dpc_id', 'dpc_id');
    }

    // Relasi ke Provinsi
    public function refProvinsi()
    {
        return $this->belongsTo(RefProvinsi::class, 'provinsi_id');
    }

    // Relasi ke Kota
    public function refKota()
    {
        return $this->belongsTo(RefKota::class, 'kota_id');
    }

    // Relasi ke Kecamatan
    public function refKecamatan()
    {
        return $this->belongsTo(RefKecamatan::class, 'kecamatan_id');
    }

    // Relasi ke Kelurahan
    public function refKelurahan()
    {
        return $this->belongsTo(RefKelurahan::class, 'kelurahan_id');
    }

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('status', 'Aktif');
    }

    // Relasi ke pembimbing (anggota) melalui pivot
    public function pembimbing()
    {
        return $this->belongsToMany(Anggota::class, 'tbl_upa_pembimbing', 'upa_id', 'anggota_id')
                    ->withPivot(['jabatan', 'tanggal_mulai', 'tanggal_selesai', 'status', 'catatan'])
                    ->withTimestamps();
    }

    // Relasi ke pembimbing aktif
    public function pembimbingAktif()
    {
        return $this->belongsToMany(Anggota::class, 'tbl_upa_pembimbing', 'upa_id', 'anggota_id')
                    ->wherePivot('status', 'Aktif')
                    ->withPivot(['jabatan', 'tanggal_mulai', 'tanggal_selesai', 'status', 'catatan'])
                    ->withTimestamps();
    }

    // Accessor untuk mendapatkan ketua UPA
    public function getKetuaAttribute()
    {
        return $this->pembimbingAktif()->wherePivot('jabatan', 'Ketua')->first();
    }

    // Accessor untuk mendapatkan wakil ketua UPA
    public function getWakilKetuaAttribute()
    {
        return $this->pembimbingAktif()->wherePivot('jabatan', 'Wakil Ketua')->first();
    }

    // Relasi ke anggota UPA
    public function anggota()
    {
        return $this->hasMany(Anggota::class, 'upa_id', 'upa_id');
    }

    // Relasi ke anggota aktif
    public function anggotaAktif()
    {
        return $this->hasMany(Anggota::class, 'upa_id', 'upa_id')
                    ->where('status_keanggotaan', 'Aktif');
    }

    // Relasi ke aktivitas grup UPA
    public function groupActivities()
    {
        return $this->hasMany(UpaGroupActivity::class, 'kode_upa', 'kode_upa');
    }
}
