<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StrukturOrganisasi extends Model
{
    use HasFactory;

    protected $table = 'tbl_struktur_organisasi';

    protected $fillable = [
        'kode_struktur',
        'nama_struktur',
        'tipe_struktur',
        'parent_id',
        'alamat',
        'penanggung_jawab',
        'deskripsi',
        'status'
    ];

    // Self-referencing relationship
    public function parent()
    {
        return $this->belongsTo(StrukturOrganisasi::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(StrukturOrganisasi::class, 'parent_id');
    }

    // Relationships
    public function anggotaMutasi()
    {
        return $this->hasMany(Mutasi::class, 'struktur_ke');
    }

    public function kegiatanPenyelenggara()
    {
        return $this->hasMany(Kegiatan::class, 'struktur_penyelenggara_id');
    }
}


