<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefProvinsi extends Model
{
    use HasFactory;

    protected $table = 'ref_provinsi';
    
    protected $fillable = [
        'kode_provinsi',
        'nama_provinsi',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the kota for the provinsi
     */
    public function kota()
    {
        return $this->hasMany(RefKota::class, 'provinsi_id');
    }

    /**
     * Scope for active provinsi
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
