<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefKeahlian extends Model
{
    use HasFactory;

    protected $table = 'tbl_ref_keahlian';
    protected $primaryKey = 'ref_keahlian_id';
    
    protected $fillable = [
        'nama_keahlian',
        'deskripsi',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Relasi ke anggota melalui pivot
    public function anggota()
    {
        return $this->belongsToMany(Anggota::class, 'tbl_anggota_keahlian', 'ref_keahlian_id', 'anggota_id');
    }
}
