<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefJenjang extends Model
{
    use HasFactory;

    protected $table = 'tbl_ref_jenjang';
    protected $primaryKey = 'ref_jenjang_id';
    public $timestamps = false;

    protected $fillable = [
        'jenjang',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Relasi ke Anggota
    public function anggota()
    {
        return $this->hasMany(Anggota::class, 'ref_jenjang_id', 'ref_jenjang_id');
    }

    // Scope untuk jenjang aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}