<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PenilaianPesertaTakwim extends Model
{
    use HasFactory;

    protected $table = 'tbl_penilaian_peserta_takwim';
    
    protected $fillable = [
        'peserta_takwim_id',
        'penilai_id',
        'tanggal_penilaian',
        'indikator_1',
        'indikator_2',
        'indikator_3',
        'indikator_4',
        'indikator_5',
        'indikator_6',
        'indikator_7',
        'total_skor',
        'status_kelulusan',
        'catatan_penilaian',
        'rekomendasi'
    ];

    protected $casts = [
        'tanggal_penilaian' => 'date',
        'indikator_1' => 'boolean',
        'indikator_2' => 'boolean',
        'indikator_3' => 'boolean',
        'indikator_4' => 'boolean',
        'indikator_5' => 'boolean',
        'indikator_6' => 'boolean',
        'indikator_7' => 'boolean',
        'total_skor' => 'integer'
    ];

    // Relasi ke PesertaTakwim
    public function pesertaTakwim()
    {
        return $this->belongsTo(PesertaTakwim::class, 'peserta_takwim_id');
    }

    // Relasi ke User (Penilai)
    public function penilai()
    {
        return $this->belongsTo(User::class, 'penilai_id');
    }

    // Accessor untuk mendapatkan daftar indikator
    public function getIndikatorListAttribute()
    {
        return [
            'indikator_1' => [
                'label' => 'Memiliki pemahaman keagamaan yang mendalam, utuh, dan moderat sesuai dengan akidah ahlus sunnah wal jama\'ah',
                'value' => $this->indikator_1
            ],
            'indikator_2' => [
                'label' => 'Berusaha mewujudkan keluarga dakwah',
                'value' => $this->indikator_2
            ],
            'indikator_3' => [
                'label' => 'Berkontribusi dan terlibat aktif dalam struktur partai atau amanah yang telah ditugaskan pimpinan partai',
                'value' => $this->indikator_3
            ],
            'indikator_4' => [
                'label' => 'Melakukan pembinaan secara rutin baik langsung maupun tidak langsung',
                'value' => $this->indikator_4
            ],
            'indikator_5' => [
                'label' => 'Setia dan komitmen pada seluruh kebijakan dan peraturan partai',
                'value' => $this->indikator_5
            ],
            'indikator_6' => [
                'label' => 'Terlibat aktif dalam mengcounter opini yang mendeskriditkan partai dan pimpinan',
                'value' => $this->indikator_6
            ],
            'indikator_7' => [
                'label' => 'Menerapkan pemahaman Konsensus Dasar Kebangsaan',
                'value' => $this->indikator_7
            ]
        ];
    }

    // Method untuk menghitung total skor
    public function calculateTotalSkor()
    {
        $skor = 0;
        for ($i = 1; $i <= 7; $i++) {
            if ($this->{"indikator_$i"}) {
                $skor++;
            }
        }
        return $skor;
    }

    // Method untuk menentukan status kelulusan
    public function determineStatusKelulusan()
    {
        $totalSkor = $this->calculateTotalSkor();
        return $totalSkor >= 5 ? 'Lulus' : 'Tidak Lulus'; // Minimal 5 dari 7 indikator
    }

    // Boot method untuk auto-calculate
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($model) {
            $model->total_skor = $model->calculateTotalSkor();
            $model->status_kelulusan = $model->determineStatusKelulusan();
        });
    }
}