<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dpd extends Model
{
    use HasFactory;

    protected $table = 'tbl_dpd';
    protected $primaryKey = 'dpd_id';

    protected $fillable = [
        'nama_dpd',
        'kode_dpd',
        'deskripsi',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Relasi ke DPC
    public function dpc()
    {
        return $this->hasMany(Dpc::class, 'dpd_id', 'dpd_id');
    }

    // Relasi ke Anggota
    public function anggota()
    {
        return $this->hasMany(Anggota::class, 'dpd_id', 'dpd_id');
    }

    // Scope untuk DPD aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
