<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dpc extends Model
{
    use HasFactory;

    protected $table = 'tbl_dpc';
    protected $primaryKey = 'dpc_id';

    protected $fillable = [
        'nama_dpc',
        'kode_dpc',
        'deskripsi',
        'is_active',
        'dpd_id'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Relasi ke DPD
    public function dpd()
    {
        return $this->belongsTo(Dpd::class, 'dpd_id', 'dpd_id');
    }

    // Relasi ke UPA
    public function upa()
    {
        return $this->hasMany(Upa::class, 'dpc_id', 'dpc_id');
    }

    // Relasi ke Anggota
    public function anggota()
    {
        return $this->hasMany(Anggota::class, 'dpc_id', 'dpc_id');
    }

    // Scope untuk DPC aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
