<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class OptimizeQueries
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Enable query logging in development
        if (config('app.debug') && config('optimization.database.query_log')) {
            DB::enableQueryLog();
        }

        $response = $next($request);

        // Log slow queries in development
        if (config('app.debug') && config('optimization.database.slow_query_log')) {
            $queries = DB::getQueryLog();
            $slowQueries = array_filter($queries, function($query) {
                return $query['time'] > config('optimization.database.slow_query_threshold', 2000);
            });

            if (!empty($slowQueries)) {
                Log::warning('Slow queries detected:', [
                    'url' => $request->url(),
                    'queries' => $slowQueries
                ]);
            }
        }

        // Add performance headers
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('X-Frame-Options', 'DENY');
        $response->headers->set('X-XSS-Protection', '1; mode=block');

        return $response;
    }
}