<?php

namespace App\Exports;

use App\Models\Anggota;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithChunkReading;

class StatistikAnggotaCsvExport implements FromQuery, WithHeadings, WithMapping, WithChunkReading
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query->with(['refJenjang', 'dpc', 'dpd']);
    }

    public function headings(): array
    {
        return [
            'No',
            'NIA',
            'Nama Lengkap',
            'Jenis Kelamin',
            'Umur',
            'Jenjang',
            'Status Keanggotaan',
            'Email',
            'No Telepon',
            'Tempat Lahir',
            'Tanggal Lahir',
            'Alamat',
            'Kota',
            'Provinsi',
            'Kode Pos',
            'DPD',
            'DPC',
            'Tanggal Bergabung'
        ];
    }

    public function map($anggota): array
    {
        static $no = 1;
        
        return [
            $no++,
            $anggota->nomor_identitas_anggota,
            $anggota->nama_lengkap,
            $anggota->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan',
            $anggota->umur ?? $this->calculateAge($anggota->tanggal_lahir),
            $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? '-',
            $anggota->status_keanggotaan ?? $anggota->status ?? '-',
            $anggota->email,
            $anggota->no_telepon,
            $anggota->tempat_lahir,
            $anggota->tanggal_lahir ? \Carbon\Carbon::parse($anggota->tanggal_lahir)->format('d/m/Y') : '-',
            $anggota->alamat,
            $anggota->kota,
            $anggota->provinsi,
            $anggota->kode_pos,
            $anggota->dpd->nama_dpd ?? '-',
            $anggota->dpc->nama_dpc ?? '-',
            $anggota->created_at ? $anggota->created_at->format('d/m/Y') : '-'
        ];
    }

    public function chunkSize(): int
    {
        return 500; // Process 500 records at a time
    }

    private function calculateAge($tanggalLahir)
    {
        if (!$tanggalLahir) {
            return '-';
        }
        
        try {
            return \Carbon\Carbon::parse($tanggalLahir)->age;
        } catch (\Exception $e) {
            return '-';
        }
    }
}

