<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use App\Helpers\CacheHelper;

class ClearOptimizedCache extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cache:clear-optimized {--all : Clear all caches including application cache}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear optimized application caches';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Clearing optimized caches...');

        // Clear master data cache
        CacheHelper::clearMasterDataCache();
        $this->info('✓ Master data cache cleared');

        // Clear dashboard cache
        Cache::forget('dashboard_stats');
        Cache::forget('dashboard_chart_data');
        $this->info('✓ Dashboard cache cleared');

        // Clear anggota cache
        Cache::forget('anggota_aktif_list');
        Cache::forget('struktur_organisasi_list');
        $this->info('✓ Anggota cache cleared');

        // Clear chart data cache
        Cache::forget('anggota_statistik_*');
        $this->info('✓ Statistics cache cleared');

        if ($this->option('all')) {
            // Clear all application cache
            Cache::flush();
            $this->info('✓ All application cache cleared');
        }

        $this->info('Optimized cache clearing completed!');
    }
}

