﻿@extends('layouts.app')

@section('title', 'Tambah Aktivitas UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Tambah Aktivitas UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa-group-activity.index') }}">Pelaksanaan Grup UPA</a></li>
                        <li class="breadcrumb-item active">Tambah Aktivitas</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Tambah Aktivitas UPA</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('upa-group-activity.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <!-- Kode UPA -->
                            <div class="col-md-6 mb-3">
                                <label for="kode_upa" class="form-label">Kode UPA <span class="text-danger">*</span></label>
                                <select class="form-select @error('kode_upa') is-invalid @enderror" id="kode_upa" name="kode_upa" required>
                                    <option value="">Pilih UPA</option>
                                    @foreach($upaList as $upa)
                                        <option value="{{ $upa->kode_upa }}" {{ old('kode_upa') == $upa->kode_upa ? 'selected' : '' }}>
                                            {{ $upa->kode_upa }} - {{ $upa->nama_upa }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('kode_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Nama Pembimbing -->
                            <div class="col-md-6 mb-3">
                                <label for="nama_pembimbing" class="form-label">Nama Pembimbing <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_pembimbing') is-invalid @enderror" 
                                       id="nama_pembimbing" name="nama_pembimbing" value="{{ old('nama_pembimbing') }}" 
                                       readonly style="background-color: #f8f9fa;">
                                <small class="text-muted">Nama pembimbing akan terisi otomatis berdasarkan UPA yang dipilih</small>
                                @error('nama_pembimbing')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Tanggal UPA -->
                            <div class="col-md-4 mb-3">
                                <label for="tanggal_upa" class="form-label">Tanggal UPA <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('tanggal_upa') is-invalid @enderror" 
                                       id="tanggal_upa" name="tanggal_upa" value="{{ old('tanggal_upa') }}" required>
                                @error('tanggal_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Pekan -->
                            <div class="col-md-2 mb-3">
                                <label for="pekan" class="form-label">Pekan</label>
                                <input type="text" class="form-control @error('pekan') is-invalid @enderror" 
                                       id="pekan" name="pekan" value="{{ old('pekan') }}" readonly 
                                       style="background-color: #f8f9fa;" placeholder="Auto">
                                @error('pekan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Waktu UPA -->
                            <div class="col-md-6 mb-3">
                                <label for="waktu_upa" class="form-label">Waktu UPA <span class="text-danger">*</span></label>
                                <input type="time" class="form-control @error('waktu_upa') is-invalid @enderror" 
                                       id="waktu_upa" name="waktu_upa" value="{{ old('waktu_upa') }}" required>
                                @error('waktu_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Status Terlaksana -->
                            <div class="col-12 mb-3">
                                <label for="status_terlaksana" class="form-label">Status Terlaksana <span class="text-danger">*</span></label>
                                <select class="form-select @error('status_terlaksana') is-invalid @enderror" 
                                        id="status_terlaksana" name="status_terlaksana" required>
                                    <option value="">Pilih Status</option>
                                    <option value="Terlaksana" {{ old('status_terlaksana') == 'Terlaksana' ? 'selected' : '' }}>Terlaksana</option>
                                    <option value="Tidak Terlaksana" {{ old('status_terlaksana') == 'Tidak Terlaksana' ? 'selected' : '' }}>Tidak Terlaksana</option>
                                </select>
                                @error('status_terlaksana')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Agenda UPA -->
                            <div class="col-12 mb-3">
                                <label for="agenda_upa" class="form-label">Agenda UPA</label>
                                <select class="form-select @error('agenda_upa') is-invalid @enderror" 
                                        id="agenda_upa" name="agenda_upa">
                                    <option value="">Pilih Agenda (Opsional)</option>
                                    @foreach($agendaList as $agenda)
                                        <option value="{{ $agenda->nama_agenda }}" 
                                                {{ old('agenda_upa') == $agenda->nama_agenda ? 'selected' : '' }}>
                                            {{ $agenda->nama_agenda }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Pilih agenda dari master atau biarkan kosong untuk agenda khusus</small>
                                @error('agenda_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Agenda Khusus -->
                            <div class="col-12 mb-3" id="agenda-khusus-container" style="display: none;">
                                <label for="agenda_khusus" class="form-label">Agenda Khusus</label>
                                <textarea class="form-control @error('agenda_khusus') is-invalid @enderror" 
                                          id="agenda_khusus" name="agenda_khusus" rows="3" 
                                          placeholder="Masukkan agenda khusus yang akan dilaksanakan">{{ old('agenda_khusus') }}</textarea>
                                <small class="text-muted">Isi jika memilih agenda khusus</small>
                                @error('agenda_khusus')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Catatan -->
                            <div class="col-12 mb-3">
                                <label for="catatan" class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          id="catatan" name="catatan" rows="3" 
                                          placeholder="Masukkan catatan tambahan">{{ old('catatan') }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Presensi Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5 class="mb-3">Presensi</h5>
                                
                                <!-- Kehadiran Pembimbing -->
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="card border-0 bg-light">
                                            <div class="card-body">
                                                <h6 class="card-title mb-3">
                                                    <i class="fas fa-user-tie me-2 text-primary"></i>Kehadiran Pembimbing
                                                </h6>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="kehadiran_pembimbing" 
                                                           name="kehadiran_pembimbing" value="1" {{ old('kehadiran_pembimbing') ? 'checked' : '' }}>
                                                    <label class="form-check-label fw-bold" for="kehadiran_pembimbing">
                                                        Pembimbing Hadir
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Presensi Anggota -->
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="mb-0">
                                            <i class="fas fa-users me-2 text-success"></i>Presensi Anggota
                                        </h6>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-success btn-sm" id="hadir-semua-btn">
                                                <i class="fas fa-check-double me-1"></i>Hadir Semua
                                            </button>
                                            <button type="button" class="btn btn-outline-secondary btn-sm" id="tidak-hadir-semua-btn">
                                                <i class="fas fa-times me-1"></i>Tidak Hadir Semua
                                            </button>
                                        </div>
                                    </div>
                                    <div id="anggota-container">
                                        <p class="text-muted">Pilih UPA terlebih dahulu untuk melihat daftar anggota</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> Simpan
                                </button>
                                <a href="{{ route('upa-group-activity.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times me-1"></i> Batal
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const kodeUpaSelect = document.getElementById('kode_upa');
    const anggotaContainer = document.getElementById('anggota-container');
    const agendaUpaSelect = document.getElementById('agenda_upa');
    const agendaKhususContainer = document.getElementById('agenda-khusus-container');
    const tanggalUpaInput = document.getElementById('tanggal_upa');
    const pekanInput = document.getElementById('pekan');

    // Function to calculate week number from a date
    function getWeekNumber(date) {
        const d = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()));
        const dayNum = d.getUTCDay() || 7;
        d.setUTCDate(d.getUTCDate() + 4 - dayNum);
        const yearStart = new Date(Date.UTC(d.getUTCFullYear(), 0, 1));
        const weekNo = Math.ceil((((d - yearStart) / 86400000) + 1) / 7);
        return weekNo;
    }

    // Auto-fill week number when date is selected
    tanggalUpaInput.addEventListener('change', function() {
        if (this.value) {
            const selectedDate = new Date(this.value);
            const weekNumber = getWeekNumber(selectedDate);
            pekanInput.value = weekNumber;
        } else {
            pekanInput.value = '';
        }
    });

    // Initialize week number if date is already set (for old values)
    if (tanggalUpaInput.value) {
        const selectedDate = new Date(tanggalUpaInput.value);
        const weekNumber = getWeekNumber(selectedDate);
        pekanInput.value = weekNumber;
    }

    // Handle agenda selection
    agendaUpaSelect.addEventListener('change', function() {
        if (this.value === '') {
            agendaKhususContainer.style.display = 'block';
        } else {
            agendaKhususContainer.style.display = 'none';
        }
    });

    // Initialize agenda khusus visibility
    if (agendaUpaSelect.value === '') {
        agendaKhususContainer.style.display = 'block';
    }

    // CSS untuk memastikan checkbox terlihat jelas
    const style = document.createElement('style');
    style.textContent = `
        .form-check-input[type="checkbox"] {
            margin-right: 8px;
            transform: scale(1.2);
        }
        .form-check-label {
            cursor: pointer;
            font-size: 14px;
        }
        .form-check-input:checked {
            background-color: #198754;
            border-color: #198754;
        }
        .form-check-input:focus {
            box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
        }
        #hadir-semua-btn, #tidak-hadir-semua-btn {
            transition: all 0.2s ease;
        }
        #hadir-semua-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(25, 135, 84, 0.3);
        }
        #tidak-hadir-semua-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
        }
        .card.bg-light {
            background-color: #f8f9fa !important;
            border: 1px solid #e9ecef;
            min-height: 200px;
        }
        .card-title {
            color: #495057;
            font-size: 14px;
        }
        .card-body.d-flex {
            padding: 1.5rem;
        }
        .btn-group .btn {
            font-size: 12px;
            padding: 0.375rem 0.75rem;
        }
        .btn-group .btn:not(:last-child) {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }
        .btn-group .btn:not(:first-child) {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }
    `;
    document.head.appendChild(style);

    kodeUpaSelect.addEventListener('change', function() {
        const kodeUpa = this.value;
        
        if (kodeUpa) {
            console.log('Loading data for UPA:', kodeUpa);
            
            // Load pembimbing UPA terlebih dahulu
            fetch(`{{ url('/api/pembimbing-upa') }}?kode_upa=${kodeUpa}`)
                .then(response => {
                    console.log('Pembimbing response status:', response.status);
                    return response.json();
                })
                .then(pembimbingData => {
                    console.log('Pembimbing data:', pembimbingData);
                    // Isi nama pembimbing
                    document.getElementById('nama_pembimbing').value = pembimbingData.nama_pembimbing || '';
                    
                    // Load anggota UPA
                    return fetch(`{{ url('/api/anggota-upa') }}?kode_upa=${kodeUpa}`);
                })
                .then(response => {
                    console.log('Anggota response status:', response.status);
                    return response.json();
                })
                .then(data => {
                    console.log('Anggota data:', data);
                    if (data.length > 0) {
                        let html = '<div class="table-responsive"><table class="table table-sm">';
                        html += '<thead class="table-light"><tr><th>Nama Anggota</th><th>Telepon</th><th>Kehadiran</th></tr></thead>';
                        html += '<tbody>';
                        
                        data.forEach(anggota => {
                            html += `
                                <tr>
                                    <td>${anggota.nama_lengkap}</td>
                                    <td>${anggota.no_telepon || '-'}</td>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" 
                                                   name="anggota_kehadiran[${anggota.id}]" 
                                                   id="hadir_${anggota.id}" value="Hadir">
                                            <label class="form-check-label" for="hadir_${anggota.id}">
                                                <strong>Hadir</strong>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            `;
                        });
                        
                        html += '</tbody></table></div>';
                        anggotaContainer.innerHTML = html;
                        
                        // Tambahkan event listener untuk tombol "Hadir Semua" dan "Tidak Hadir Semua"
                        const hadirSemuaBtn = document.getElementById('hadir-semua-btn');
                        const tidakHadirSemuaBtn = document.getElementById('tidak-hadir-semua-btn');
                        
                        if (hadirSemuaBtn) {
                            hadirSemuaBtn.addEventListener('click', function() {
                                data.forEach(anggota => {
                                    const checkbox = document.getElementById(`hadir_${anggota.id}`);
                                    if (checkbox) {
                                        checkbox.checked = true;
                                    }
                                });
                            });
                        }
                        
                        if (tidakHadirSemuaBtn) {
                            tidakHadirSemuaBtn.addEventListener('click', function() {
                                data.forEach(anggota => {
                                    const checkbox = document.getElementById(`hadir_${anggota.id}`);
                                    if (checkbox) {
                                        checkbox.checked = false;
                                    }
                                });
                            });
                        }
                    } else {
                        anggotaContainer.innerHTML = '<p class="text-muted">Tidak ada anggota aktif di UPA ini</p>';
                    }
                })
                .catch(error => {
                    console.error('Error loading data:', error);
                    console.error('Error details:', {
                        message: error.message,
                        stack: error.stack,
                        name: error.name
                    });
                    anggotaContainer.innerHTML = '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle me-2"></i>Error loading data: ' + error.message + '</div>';
                });
        } else {
            // Reset nama pembimbing dan anggota
            document.getElementById('nama_pembimbing').value = '';
            anggotaContainer.innerHTML = '<p class="text-muted">Pilih UPA terlebih dahulu untuk melihat daftar anggota</p>';
        }
    });
});
</script>
@endsection

