<?php $__env->startSection('title', 'Dashboard - Sistem Informasi Anggota PKS'); ?>

<?php $__env->startSection('content'); ?>
<style>
.chart-container {
    position: relative;
    height: 400px;
    width: 100%;
    overflow-x: auto;
    overflow-y: hidden;
}

.chart-container canvas {
    min-width: 800px;
    width: 100%;
}

/* Custom scrollbar untuk chart */
.chart-container::-webkit-scrollbar {
    height: 8px;
}

.chart-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.chart-container::-webkit-scrollbar-thumb {
    background: #ff5722;
    border-radius: 4px;
}

.chart-container::-webkit-scrollbar-thumb:hover {
    background: #e64a19;
}
</style>

<div class="row mb-4">
    <div class="col-12">
        <h1 class="h3 text-gray-800 mb-0">Dashboard</h1>
        <p class="text-muted">Ringkasan data anggota Partai Keadilan Sejahtera</p>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 col-sm-6 mb-4">
        <div class="stats-card primary">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="stats-label mb-1">Total Anggota</div>
                    <div class="stats-number"><?php echo e(number_format($stats['total_anggota'])); ?></div>
                </div>
                <div class="col-auto">
                    <i class="fas fa-users stats-icon"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 col-sm-6 mb-4">
        <div class="stats-card warning">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="stats-label mb-1">Anggota Tidak Aktif</div>
                    <div class="stats-number text-warning"><?php echo e(number_format($stats['anggota_tidak_aktif'])); ?></div>
                </div>
                <div class="col-auto">
                    <i class="fas fa-user-times stats-icon text-warning"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 col-sm-6 mb-4">
        <div class="stats-card info">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="stats-label mb-1">Kegiatan Bulan Ini</div>
                    <div class="stats-number text-info"><?php echo e(number_format($stats['kegiatan_bulan_ini'])); ?></div>
                </div>
                <div class="col-auto">
                    <i class="fas fa-calendar stats-icon text-info"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 col-sm-6 mb-4">
        <div class="stats-card success">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="stats-label mb-1">Program Takwim</div>
                    <div class="stats-number text-success"><?php echo e(number_format($stats['takwim_total'])); ?></div>
                </div>
                <div class="col-auto">
                    <i class="fas fa-calendar-alt stats-icon text-success"></i>
                </div>
            </div>
        </div>
    </div>
</div>


   
    <div class="row">
        
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik Jenjang Anggota</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php
                            $colors = ['primary', 'success', 'warning', 'info', 'danger'];
                            $icons = ['star', 'award', 'medal', 'trophy', 'crown'];
                        ?>
                        
                        <?php $__currentLoopData = $jenjangStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $jenjang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                            <div class="card border-left-<?php echo e($colors[$index % 5]); ?> h-100">
                                <div class="card-body py-3">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-dark text-uppercase mb-1" style="font-weight: bold !important;">
                                                <?php echo e($jenjang->jenjang); ?>

                                            </div>
                                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                                <?php echo e($jenjang->total); ?> orang
                                            </div>
                                            <div class="text-xs text-muted">
                                                <?php echo e(number_format(($jenjang->total / $totalAnggota) * 100, 1)); ?>% dari total
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                            <div class="card border-left-<?php echo e($colors[$index % 5]); ?> h-100">
                                <div class="card-body py-3">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-dark text-uppercase mb-1" style="font-weight: bold !important;">
                                            Total
                                            </div>
                                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                               <?php echo e($totalAnggota); ?> orang
                                            </div>
                                            <div class="text-xs text-muted">
                                               Total DPD Jakarta Timur
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                      
                    </div>
                </div>
            </div>
        </div>

       
    </div>

<div class="row">
    <!-- Statistik Anggota DPC -->
    <div class="col-12 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-map-marker-alt me-2"></i>
                    Anggota per DPC
                </h6>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="chartDPC"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Kegiatan Terbaru -->
    <div class="col-xl-8 col-lg-7 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calendar-alt me-2"></i>
                    Kegiatan Terbaru
                </h6>
                <a href="<?php echo e(route('kegiatan.index')); ?>" class="btn btn-light btn-sm">
                    <i class="fas fa-eye me-1"></i>Lihat Semua
                </a>
            </div>
            <div class="card-body">
                <?php if($kegiatan_terbaru->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th><i class="fas fa-calendar me-1"></i>Nama Kegiatan</th>
                                    <th><i class="fas fa-tag me-1"></i>Jenis</th>
                                    <th><i class="fas fa-clock me-1"></i>Tanggal</th>
                                    <th><i class="fas fa-info-circle me-1"></i>Status</th>
                                    <th><i class="fas fa-users me-1"></i>Peserta</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $kegiatan_terbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kegiatan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('kegiatan.show', $kegiatan)); ?>" class="text-decoration-none fw-bold text-primary">
                                            <?php echo e($kegiatan->nama_kegiatan); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <span class="text-dark">
                                            <?php echo e($kegiatan->jenisKegiatan->nama_jenis_kegiatan ?? 'N/A'); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($kegiatan->tanggal_mulai ? $kegiatan->tanggal_mulai->format('d/m/Y') : '-'); ?></td>
                                    <td>
                                        <span class="text-dark">
                                            <?php echo e($kegiatan->status_kegiatan); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <i class="fas fa-user me-1"></i>
                                        <?php echo e($kegiatan->absensi_count); ?> orang
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-calendar-times fa-4x text-muted mb-3"></i>
                        <p class="text-muted mb-3">Belum ada kegiatan yang tercatat</p>
                        <a href="<?php echo e(route('kegiatan.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Tambah Kegiatan
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Mutasi Terbaru -->
    <div class="col-xl-4 col-lg-5 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exchange-alt me-2"></i>
                    Mutasi Terbaru
                </h6>
                <a href="<?php echo e(route('mutasi.index')); ?>" class="btn btn-light btn-sm">
                    <i class="fas fa-eye me-1"></i>Lihat Semua
                </a>
            </div>
            <div class="card-body">
                <?php if($mutasi_terbaru->count() > 0): ?>
                    <?php $__currentLoopData = $mutasi_terbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mutasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center py-3 border-bottom">
                        <div class="me-3">
                            <div class="rounded-circle d-flex align-items-center justify-content-center" style="width: 45px; height: 45px; background: linear-gradient(135deg, #F0833A 0%, #E67E22 100%);">
                                <i class="fas fa-<?php echo e($mutasi->jenis_mutasi == 'Masuk' ? 'user-plus' : ($mutasi->jenis_mutasi == 'Keluar' ? 'user-minus' : 'exchange-alt')); ?> text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="small text-muted"><?php echo e($mutasi->tanggal_mutasi->format('d/m/Y')); ?></div>
                            <div class="fw-bold"><?php echo e($mutasi->anggota->nama_lengkap); ?></div>
                            <div class="small">
                                <span class="badge" style="background-color: #F39C12;"><?php echo e($mutasi->jenis_mutasi); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                        <p class="text-muted small">Belum ada mutasi</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-bolt me-2"></i>
                    Aksi Cepat
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-3">
                        <div class="quick-action-card">
                            <div class="quick-action-icon">
                                <i class="fas fa-user-plus"></i>
                            </div>
                            <h6 class="fw-bold mb-2">Tambah Anggota</h6>
                            <p class="text-muted small mb-3">Daftarkan anggota baru ke sistem</p>
                            <a href="<?php echo e(route('anggota.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus me-1"></i>Tambah
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-3">
                        <div class="quick-action-card">
                            <div class="quick-action-icon">
                                <i class="fas fa-calendar-plus"></i>
                            </div>
                            <h6 class="fw-bold mb-2">Buat Kegiatan</h6>
                            <p class="text-muted small mb-3">Jadwalkan kegiatan organisasi</p>
                            <a href="<?php echo e(route('kegiatan.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus me-1"></i>Buat
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-3">
                        <div class="quick-action-card">
                            <div class="quick-action-icon">
                                <i class="fas fa-exchange-alt"></i>
                            </div>
                            <h6 class="fw-bold mb-2">Proses Mutasi</h6>
                            <p class="text-muted small mb-3">Kelola perpindahan anggota</p>
                            <a href="<?php echo e(route('mutasi.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-exchange-alt me-1"></i>Proses
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-3">
                        <div class="quick-action-card">
                            <div class="quick-action-icon">
                                <i class="fas fa-chart-bar"></i>
                            </div>
                            <h6 class="fw-bold mb-2">Lihat Statistik</h6>
                            <p class="text-muted small mb-3">Analisis data dan statistik</p>
                            <a href="<?php echo e(route('statistik.index')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-eye me-1"></i>Lihat
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// PKS Orange Dusty Color Palette
const pksColors = {
    primary: '#F0833A',
    primaryDark: '#E67E22',
    primaryLight: '#F39C12',
    success: '#4CAF50',
    warning: '#FF9800',
    info: '#2196F3',
    danger: '#F44336'
};

// Chart Anggota per DPC dengan Jenjang
const ctxDPC = document.getElementById('chartDPC').getContext('2d');
new Chart(ctxDPC, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($anggota_per_dpc->pluck('kecamatan')); ?>,
        datasets: [
            {
                label: '1 - Pendukung',
                data: <?php echo json_encode($anggota_per_dpc->pluck('pendukung')); ?>,
                backgroundColor: 'rgba(255, 87, 34, 0.8)',
                borderColor: 'rgba(255, 87, 34, 1)',
                borderWidth: 1
            },
            {
                label: '2 - Penggerak',
                data: <?php echo json_encode($anggota_per_dpc->pluck('penggerak')); ?>,
                backgroundColor: 'rgba(33, 150, 243, 0.8)',
                borderColor: 'rgba(33, 150, 243, 1)',
                borderWidth: 1
            },
            {
                label: '3 - Madya',
                data: <?php echo json_encode($anggota_per_dpc->pluck('madya')); ?>,
                backgroundColor: 'rgba(76, 175, 80, 0.8)',
                borderColor: 'rgba(76, 175, 80, 1)',
                borderWidth: 1
            },
            {
                label: '4 - Dewasa',
                data: <?php echo json_encode($anggota_per_dpc->pluck('dewasa')); ?>,
                backgroundColor: 'rgba(255, 193, 7, 0.8)',
                borderColor: 'rgba(255, 193, 7, 1)',
                borderWidth: 1
            },
            {
                label: '5 - Utama',
                data: <?php echo json_encode($anggota_per_dpc->pluck('utama')); ?>,
                backgroundColor: 'rgba(156, 39, 176, 0.8)',
                borderColor: 'rgba(156, 39, 176, 1)',
                borderWidth: 1
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        aspectRatio: 2.5,
        plugins: {
            legend: {
                display: true,
                position: 'top',
                labels: {
                    usePointStyle: true,
                    padding: 20,
                    font: {
                        size: 12
                    }
                }
            },
            tooltip: {
                backgroundColor: 'rgba(255, 87, 34, 0.9)',
                titleColor: '#fff',
                bodyColor: '#fff',
                borderColor: pksColors.primary,
                borderWidth: 1,
                cornerRadius: 8,
                mode: 'index',
                intersect: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                stacked: false,
                grid: {
                    color: 'rgba(255, 87, 34, 0.1)'
                },
                ticks: {
                    color: '#757575'
                }
            },
            x: {
                stacked: false,
                grid: {
                    display: false
                },
                ticks: {
                    color: '#757575',
                    maxRotation: 45,
                    minRotation: 0,
                    padding: 10
                }
            }
        }
    }
});


// Add smooth animations
Chart.defaults.animation.duration = 1500;
Chart.defaults.animation.easing = 'easeInOutQuart';

// Counter animation for statistics
function animateCounter(element, target) {
    let start = 0;
    const increment = target / 100;
    const timer = setInterval(() => {
        start += increment;
        element.textContent = Math.floor(start).toLocaleString('id-ID');
        if (start >= target) {
            element.textContent = target.toLocaleString('id-ID');
            clearInterval(timer);
        }
    }, 20);
}

// Animate statistics numbers on page load
document.addEventListener('DOMContentLoaded', function() {
    const statsNumbers = document.querySelectorAll('.stats-number');
    statsNumbers.forEach(element => {
        const target = parseInt(element.textContent.replace(/,/g, ''));
        animateCounter(element, target);
    });
});

// Add hover effects to cards
document.querySelectorAll('.stats-card, .quick-action-card').forEach(card => {
    card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-5px)';
    });
    
    card.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0)';
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\bkdpd\resources\views/dashboard.blade.php ENDPATH**/ ?>