<?php $__env->startSection('title', 'Detail Anggota - Sistem Informasi PKS'); ?>

<?php $__env->startSection('content'); ?>
<!-- Success/Error Messages -->
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="row mb-4">
    <div class="col-md-8">
        <h1 class="h3 text-gray-800 mb-0">Detail Anggota</h1>
        <p class="text-muted">Informasi lengkap anggota PKS</p>
    </div>
    <div class="col-md-4 text-end">
        <div class="btn-group" role="group">
            <a href="<?php echo e(route('anggota.keanggotaan.show', $anggota->id)); ?>" class="btn btn-info">
                <i class="fas fa-users me-1"></i> Data Keanggotaan
            </a>
            <a href="<?php echo e($anggota->edit_url); ?>" class="btn btn-warning">
                <i class="fas fa-edit me-1"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" 
                    onclick="confirmDelete('<?php echo e($anggota->url_slug); ?>', '<?php echo e($anggota->nama_lengkap); ?>')">
                <i class="fas fa-trash me-1"></i> Hapus
            </button>
        </div>
        <div class="mt-2">
            <a href="<?php echo e(route('anggota.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Profile Card -->
    <div class="col-md-4 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 text-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-user-circle me-2"></i>Profil Anggota
                </h6>
            </div>
            <div class="card-body text-center">
                <?php if($anggota->foto && file_exists(public_path('storage/' . $anggota->foto))): ?>
                    <img src="<?php echo e(url('storage/' . $anggota->foto)); ?>?v=<?php echo e($anggota->updated_at ? $anggota->updated_at->timestamp : time()); ?>" 
                         alt="Foto <?php echo e($anggota->nama_lengkap); ?>"
                         class="rounded-circle mb-3" 
                         style="width: 150px; height: 150px; object-fit: cover; border: 4px solid #F0833A;">
                <?php else: ?>
                    <div class="rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                         style="width: 150px; height: 150px; background: linear-gradient(135deg, #F0833A, #E67E22);">
                        <i class="fas fa-user fa-4x text-white"></i>
                    </div>
                <?php endif; ?>
                
                <!-- Tombol Ubah Foto -->
                <div class="mb-3">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#ubahFotoModal">
                        <i class="fas fa-camera me-1"></i> Ubah Foto
                    </button>
                </div>
                
                <h5 class="text-primary mb-1"><?php echo e($anggota->nama_lengkap); ?></h5>
                <p class="text-muted mb-2"><?php echo e($anggota->nomor_identitas_anggota); ?></p>
                
                <div class="row text-center mb-3">
                    <div class="col-6">
                        <span class="badge bg-<?php echo e($anggota->status_keanggotaan == 'Aktif' ? 'success' : ($anggota->status_keanggotaan == 'Tidak Aktif' ? 'warning' : 'danger')); ?> p-2">
                            <?php echo e($anggota->status_keanggotaan); ?>

                        </span>
                    </div>
                    <div class="col-6">
                        <span class="badge bg-secondary p-2"><?php echo e($anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota); ?></span>
                    </div>
                </div>
                
                <div class="row text-center">
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            <?php if($anggota->tanggal_lahir): ?>
                                <?php echo e(\Carbon\Carbon::parse($anggota->tanggal_lahir)->age); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </div>
                        <small class="text-muted">Tahun</small>
                    </div>
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            <?php echo e($anggota->absensiKegiatan ? $anggota->absensiKegiatan->where('status_kehadiran', 'Hadir')->count() : 0); ?>

                        </div>
                        <small class="text-muted">Kegiatan</small>
                    </div>
                    <div class="col-4">
                        <div class="text-primary fw-bold">
                            <?php echo e($anggota->mutasi ? $anggota->mutasi->count() : 0); ?>

                        </div>
                        <small class="text-muted">Mutasi</small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Contact -->
        <?php if($anggota->no_telepon || $anggota->email): ?>
        <div class="card shadow mt-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-address-book me-2"></i>Kontak Cepat
                </h6>
            </div>
            <div class="card-body">
                <?php if($anggota->no_telepon): ?>
                    <a href="tel:<?php echo e($anggota->no_telepon); ?>" class="btn btn-success btn-sm w-100 mb-2">
                        <i class="fas fa-phone me-2"></i><?php echo e($anggota->no_telepon); ?>

                    </a>
                <?php endif; ?>
                <?php if($anggota->email): ?>
                    <a href="mailto:<?php echo e($anggota->email); ?>" class="btn btn-info btn-sm w-100">
                        <i class="fas fa-envelope me-2"></i><?php echo e($anggota->email); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Detail Information -->
    <div class="col-md-8">
        <!-- Data Identitas -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-id-card me-2"></i>Data Identitas
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td class="fw-bold text-muted">NIA:</td>
                                <td><?php echo e($anggota->nomor_identitas_anggota); ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Nama Lengkap:</td>
                                <td><?php echo e($anggota->nama_lengkap); ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Tempat, Tanggal Lahir:</td>
                                <td>
                                    <?php echo e($anggota->tempat_lahir); ?>, 
                                    <?php if($anggota->tanggal_lahir): ?>
                                        <?php echo e($anggota->tanggal_lahir->format('d F Y')); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Jenis Kelamin:</td>
                                <td>
                                    <span class="badge bg-<?php echo e($anggota->jenis_kelamin == 'L' ? 'info' : 'danger'); ?>">
                                        <?php echo e($anggota->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?>

                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td class="fw-bold text-muted">Umur:</td>
                                <td>
                                    <?php if($anggota->tanggal_lahir): ?>
                                        <?php echo e(\Carbon\Carbon::parse($anggota->tanggal_lahir)->age); ?> tahun
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Jenjang:</td>
                                <td><span class="badge bg-secondary"><?php echo e($anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota); ?></span></td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">UPA:</td>
                                <td>
                                    <?php if($anggota->upa): ?>
                                        <span class="badge bg-primary"><?php echo e($anggota->upa->nama_upa); ?></span>
                                        <?php if($anggota->upa->dpc): ?>
                                            <br><small class="text-muted">DPC: <?php echo e($anggota->upa->dpc->nama_dpc); ?></small>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Keahlian:</td>
                                <td>
                                    <?php if($anggota->keahlian && $anggota->keahlian->count() > 0): ?>
                                        <?php $__currentLoopData = $anggota->keahlian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keahlian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-info me-1 mb-1"><?php echo e($keahlian->nama_keahlian); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    <?php if($anggota->keahlian_lainnya): ?>
                                        <div class="mt-2">
                                            <small class="text-muted fw-bold">Keahlian Lainnya:</small><br>
                                            <span class="text-dark"><?php echo e($anggota->keahlian_lainnya); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if((!$anggota->keahlian || $anggota->keahlian->count() == 0) && !$anggota->keahlian_lainnya): ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Aktivitas di Luar Pekerjaan:</td>
                                <td>
                                    <?php
                                        $hasAktivitas = false;
                                    ?>
                                    
                                    <?php if($anggota->aktivitasLuar && $anggota->aktivitasLuar->count() > 0): ?>
                                        <?php $hasAktivitas = true; ?>
                                        <ul class="list-unstyled mb-0">
                                            <?php $__currentLoopData = $anggota->aktivitasLuar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aktivitas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="mb-1">
                                                    <i class="fas fa-circle text-primary me-2" style="font-size: 0.5rem;"></i>
                                                    <?php echo e($aktivitas->nama_aktivitas); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                    
                                    <?php if($anggota->aktivitas && $anggota->aktivitas->count() > 0): ?>
                                        <?php $hasAktivitas = true; ?>
                                        <?php if($anggota->aktivitasLuar && $anggota->aktivitasLuar->count() > 0): ?>
                                            <ul class="list-unstyled mb-0 mt-2">
                                        <?php else: ?>
                                            <ul class="list-unstyled mb-0">
                                        <?php endif; ?>
                                            <?php $__currentLoopData = $anggota->aktivitas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aktivitas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="mb-1">
                                                    <i class="fas fa-circle text-warning me-2" style="font-size: 0.5rem;"></i>
                                                    <?php echo e($aktivitas->uraian_aktivitas); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                    
                                    <?php if(!$hasAktivitas): ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Tanggal Bergabung:</td>
                                <td>
                                    <?php if($anggota->tanggal_bergabung): ?>
                                        <?php echo e($anggota->tanggal_bergabung->format('d F Y')); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-muted">Lama Keanggotaan:</td>
                                <td>
                                    <?php if($anggota->tanggal_bergabung): ?>
                                        <?php echo e($anggota->tanggal_bergabung->diffForHumans()); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Alamat -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-map-marker-alt me-2"></i>Alamat Lengkap
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <i class="fas fa-home text-primary me-2"></i>
                            <strong>
                                <?php echo e($anggota->alamat_jalan); ?>

                                <?php if($anggota->rt && $anggota->rw): ?>, RT <?php echo e($anggota->rt); ?>/RW <?php echo e($anggota->rw); ?><?php endif; ?>
                                <?php if($anggota->kelurahan): ?>, <?php echo e($anggota->kelurahan); ?><?php endif; ?>
                                <?php if($anggota->kecamatan): ?>, <?php echo e($anggota->kecamatan); ?><?php endif; ?>
                                <?php if($anggota->kota): ?>, <?php echo e($anggota->kota); ?><?php endif; ?>
                                <?php if($anggota->provinsi): ?>, <?php echo e($anggota->provinsi); ?><?php endif; ?>
                            </strong>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless table-sm">
                                    <tr>
                                        <td class="fw-bold text-muted">RT/RW:</td>
                                        <td><?php echo e($anggota->rt ?? '-'); ?>/<?php echo e($anggota->rw ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kelurahan:</td>
                                        <td><?php echo e($anggota->kelurahan ?? '-'); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless table-sm">
                                    <tr>
                                        <td class="fw-bold text-muted">Kecamatan:</td>
                                        <td><?php echo e($anggota->kecamatan ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kota/Provinsi:</td>
                                        <td><?php echo e($anggota->kota ?? '-'); ?>, <?php echo e($anggota->provinsi ?? '-'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-muted">Kode Pos:</td>
                                        <td><?php echo e($anggota->kode_pos ?? '-'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Ekonomi -->
        <?php if($anggota->penghasilan_per_bulan || $anggota->muzaki_mustahiq || $anggota->nomor_identitas_pasangan): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-money-bill-wave me-2"></i>Informasi Ekonomi
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if($anggota->penghasilan_per_bulan): ?>
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-wallet fa-2x text-success mb-2"></i>
                            <div class="fw-bold">Rp <?php echo e(number_format($anggota->penghasilan_per_bulan, 0, ',', '.')); ?></div>
                            <small class="text-muted">Penghasilan per Bulan</small>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($anggota->muzaki_mustahiq): ?>
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-hand-holding-heart fa-2x text-primary mb-2"></i>
                            <div class="fw-bold"><?php echo e($anggota->muzaki_mustahiq); ?></div>
                            <small class="text-muted">Status Zakat</small>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($anggota->nomor_identitas_pasangan): ?>
                    <div class="col-md-4 mb-3">
                        <div class="text-center">
                            <i class="fas fa-heart fa-2x text-danger mb-2"></i>
                            <div class="fw-bold"><?php echo e($anggota->nomor_identitas_pasangan); ?></div>
                            <small class="text-muted">NIA Pasangan</small>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Catatan/Profil -->
        <?php if($anggota->catatan_profil): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-sticky-note me-2"></i>Catatan/Profil
                </h6>
            </div>
            <div class="card-body">
                <p class="mb-0"><?php echo e($anggota->catatan_profil); ?></p>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Riwayat Aktivitas -->
<div class="row">
    <!-- Riwayat Jenjang -->
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-users me-2"></i>Riwayat Jenjang
                </h6>
                <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#jenjangModal">
                    <i class="fas fa-plus me-1"></i>Tambah Jenjang
                </button>
            </div>
            <div class="card-body">
                <?php if($anggota->jenjangHistory && $anggota->jenjangHistory->count() > 0): ?>
                    <div class="timeline">
                        <?php $__currentLoopData = $anggota->jenjangHistory->sortByDesc('tanggal_perubahan')->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info">
                                <i class="fas fa-user-edit"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">
                                    <?php if($history->refJenjang): ?>
                                        <?php echo e($history->refJenjang->jenjang); ?>

                                    <?php else: ?>
                                        Jenjang
                                    <?php endif; ?>
                                </div>
                                <div class="small text-muted">
                                    <?php if($history->tanggal_perubahan): ?>
                                        <?php echo e($history->tanggal_perubahan->format('d M Y')); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </div>
                                <div class="small">
                                    <?php if($history->upa): ?>
                                        <span class="badge bg-info"><?php echo e($history->upa->nama_upa); ?></span>
                                    <?php endif; ?>
                                    <?php if($history->dpc): ?>
                                        <span class="badge bg-success"><?php echo e($history->dpc->nama_dpc); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php if($history->keterangan): ?>
                                    <div class="small text-muted"><?php echo e(Str::limit($history->keterangan, 30)); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if($anggota->jenjangHistory->count() > 3): ?>
                        <div class="text-center mt-3">
                            <a href="<?php echo e(route('anggota.keanggotaan.show', $anggota->id)); ?>" class="btn btn-outline-primary btn-sm">
                                Lihat Semua (<?php echo e($anggota->jenjangHistory->count()); ?>)
                            </a>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center py-3">
                        <i class="fas fa-users fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat jenjang</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Kegiatan Terakhir -->
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calendar-check me-2"></i>Kegiatan Terakhir
                </h6>
                <span class="badge bg-light text-dark">
                    Total: <?php echo e($anggota->absensiKegiatan ? $anggota->absensiKegiatan->count() : 0); ?> kegiatan
                </span>
            </div>
            <div class="card-body">
                <?php if($anggota->absensiKegiatan && $anggota->absensiKegiatan->count() > 0): ?>
                    <?php $__currentLoopData = $anggota->absensiKegiatan->sortByDesc('created_at')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $absensi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center py-2 border-bottom">
                        <div class="me-3">
                            <span class="badge bg-<?php echo e($absensi->status_kehadiran == 'Hadir' ? 'success' : ($absensi->status_kehadiran == 'Izin' ? 'warning' : 'danger')); ?>">
                                <?php echo e($absensi->status_kehadiran ?? 'Unknown'); ?>

                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-bold">
                                <?php if($absensi->kegiatan): ?>
                                    <?php echo e($absensi->kegiatan->nama_kegiatan); ?>

                                <?php else: ?>
                                    Kegiatan tidak ditemukan
                                <?php endif; ?>
                            </div>
                            <div class="small text-muted">
                                <?php echo e($absensi->kegiatan->tanggal_mulai ? $absensi->kegiatan->tanggal_mulai->format('d M Y') : '-'); ?>

                                <?php if($absensi->waktu_absen): ?>
                                    - Absen: <?php echo e($absensi->waktu_absen->format('H:i')); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($anggota->absensiKegiatan->count() > 5): ?>
                        <div class="text-center mt-3">
                            <a href="<?php echo e(route('kegiatan.index')); ?>" class="btn btn-outline-primary btn-sm">
                                Lihat Semua Kegiatan
                            </a>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center py-3">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum mengikuti kegiatan</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Riwayat Perpindahan Section -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exchange-alt me-2"></i>Riwayat Perpindahan
                </h6>
                <a href="<?php echo e(route('surat-penempatan.create', ['anggota_id' => $anggota->id])); ?>" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>Buat Surat Penempatan
                </a>
            </div>
            <div class="card-body">
                <?php if($anggota->riwayatPerpindahan->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Tipe</th>
                                    <th>Dari</th>
                                    <th>Ke</th>
                                    <th>Pembimbing</th>
                                    <th>Status</th>
                                    <th>Nomor Surat</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $anggota->riwayatPerpindahan->sortByDesc('tanggal_efektif'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $riwayat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo e($riwayat->tanggal_efektif ? $riwayat->tanggal_efektif->format('d M Y') : '-'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($riwayat->tipe_transaksi == 'penempatan' ? 'success' : ($riwayat->tipe_transaksi == 'mutasi' ? 'warning' : 'info')); ?>">
                                            <?php echo e(ucfirst($riwayat->tipe_transaksi)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($riwayat->upaAsal): ?>
                                            <div class="small">
                                                <strong><?php echo e($riwayat->upaAsal->nama_upa); ?></strong><br>
                                                <span class="text-muted"><?php echo e($riwayat->dpcAsal->nama_dpc ?? '-'); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($riwayat->upaTujuan): ?>
                                            <div class="small">
                                                <strong><?php echo e($riwayat->upaTujuan->nama_upa); ?></strong><br>
                                                <span class="text-muted"><?php echo e($riwayat->dpcTujuan->nama_dpc ?? '-'); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <?php if($riwayat->pembimbingLama): ?>
                                                <div class="text-muted">Dari: <?php echo e($riwayat->pembimbingLama->nama_lengkap); ?></div>
                                            <?php endif; ?>
                                            <?php if($riwayat->pembimbingBaru): ?>
                                                <div class="text-success">Ke: <?php echo e($riwayat->pembimbingBaru->nama_lengkap); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($riwayat->status == 'completed' ? 'success' : ($riwayat->status == 'pending' ? 'warning' : 'secondary')); ?>">
                                            <?php echo e(ucfirst($riwayat->status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($riwayat->nomor_surat); ?></small>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-3">
                        <i class="fas fa-exchange-alt fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat perpindahan</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Riwayat Mutasi -->
<div class="row">
    <div class="col-12 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-history me-2"></i>Riwayat Mutasi
                </h6>
                <a href="<?php echo e(route('mutasi.create')); ?>" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>Tambah Mutasi
                </a>
            </div>
            <div class="card-body">
                <?php if($anggota->mutasi && $anggota->mutasi->count() > 0): ?>
                    <div class="timeline">
                        <?php $__currentLoopData = $anggota->mutasi->sortByDesc('tanggal_mutasi')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mutasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-<?php echo e($mutasi->jenis_mutasi == 'Masuk' ? 'success' : ($mutasi->jenis_mutasi == 'Keluar' ? 'danger' : 'info')); ?>">
                                <i class="fas fa-<?php echo e($mutasi->jenis_mutasi == 'Masuk' ? 'user-plus' : ($mutasi->jenis_mutasi == 'Keluar' ? 'user-minus' : 'exchange-alt')); ?>"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold"><?php echo e($mutasi->jenis_mutasi ?? 'Unknown'); ?></div>
                                <div class="small text-muted">
                                    <?php if($mutasi->tanggal_mutasi): ?>
                                        <?php echo e($mutasi->tanggal_mutasi->format('d M Y')); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </div>
                                <div class="small"><?php echo e(Str::limit($mutasi->alasan_mutasi ?? 'Tidak ada keterangan', 50)); ?></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if($anggota->mutasi->count() > 5): ?>
                        <div class="text-center mt-3">
                            <a href="<?php echo e(route('mutasi.index')); ?>" class="btn btn-outline-primary btn-sm">
                                Lihat Semua (<?php echo e($anggota->mutasi->count()); ?>)
                            </a>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center py-3">
                        <i class="fas fa-history fa-3x text-muted mb-2"></i>
                        <p class="text-muted">Belum ada riwayat mutasi</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle me-2"></i>Konfirmasi Hapus
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus anggota <strong id="memberName"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Peringatan:</strong> Tindakan ini akan menghapus semua data terkait anggota.
                </div>
                <p class="text-danger fw-bold">Tindakan ini tidak dapat dibatalkan!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-1"></i> Ya, Hapus Anggota
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -35px;
    top: 0;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 12px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: -20px;
    top: 15px;
    bottom: 0;
    width: 2px;
    background: #ddd;
}

.timeline-item:last-child::after {
    display: none;
}

.card-body table td {
    padding: 0.3rem 0.5rem;
    vertical-align: middle;
}
</style>
<?php $__env->stopPush(); ?>

<!-- Modal Ubah Foto -->
<div class="modal fade" id="ubahFotoModal" tabindex="-1" aria-labelledby="ubahFotoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="ubahFotoModalLabel">
                    <i class="fas fa-camera me-2"></i>Ubah Foto Profil
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('anggota.update-foto', $anggota->url_slug)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="foto" class="form-label">Pilih Foto Baru</label>
                        <input type="file" class="form-control" id="foto" name="foto" accept="image/*" required>
                        <div class="form-text">
                            Format yang didukung: JPG, PNG, GIF. Maksimal 4MB.
                        </div>
                    </div>
                    
                    <!-- Preview Foto -->
                    <div class="text-center">
                        <img id="fotoPreview" src="#" alt="Preview" class="rounded-circle" style="width: 150px; height: 150px; object-fit: cover; border: 4px solid #F0833A; display: none;">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload me-1"></i> Upload Foto
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Tambah/Edit Jenjang -->
<div class="modal fade" id="jenjangModal" tabindex="-1" aria-labelledby="jenjangModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jenjangModalLabel">
                    <i class="fas fa-users me-2"></i>Update Data Keanggotaan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('anggota.keanggotaan.update', $anggota->id)); ?>" method="POST" id="jenjangForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ref_jenjang_id" class="form-label">
                                    Jenjang Anggota <span class="text-danger">*</span>
                                </label>
                                <select class="form-select <?php $__errorArgs = ['ref_jenjang_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="ref_jenjang_id" name="ref_jenjang_id">
                                    <option value="">Pilih Jenjang</option>
                                    <?php $__currentLoopData = \App\Models\RefJenjang::whereIn('jenjang', ['Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama'])->where('is_active', true)->orderByRaw("FIELD(jenjang, 'Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama')")->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jenjang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($jenjang->ref_jenjang_id); ?>" 
                                                <?php echo e(old('ref_jenjang_id', $anggota->ref_jenjang_id) == $jenjang->ref_jenjang_id ? 'selected' : ''); ?>>
                                            <?php echo e($jenjang->jenjang); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['ref_jenjang_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="dpc_id" class="form-label">
                                    DPC <span class="text-danger">*</span>
                                </label>
                                <select class="form-select <?php $__errorArgs = ['dpc_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="dpc_id" name="dpc_id">
                                    <option value="">Pilih DPC</option>
                                    <?php $__currentLoopData = \App\Models\Dpc::orderBy('nama_dpc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($dpc->dpc_id); ?>" 
                                                <?php echo e(old('dpc_id', $anggota->dpc_id) == $dpc->dpc_id ? 'selected' : ''); ?>>
                                            <?php echo e($dpc->nama_dpc); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['dpc_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="dpd_id" class="form-label">
                                    DPD <span class="text-danger">*</span>
                                </label>
                                <select class="form-select <?php $__errorArgs = ['dpd_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="dpd_id" name="dpd_id">
                                    <option value="">Pilih DPD</option>
                                    <?php $__currentLoopData = \App\Models\Dpd::orderBy('nama_dpd')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($dpd->dpd_id); ?>" 
                                                <?php echo e(old('dpd_id', $anggota->dpd_id) == $dpd->dpd_id ? 'selected' : ''); ?>>
                                            <?php echo e($dpd->nama_dpd); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['dpd_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="upa_id" class="form-label">UPA</label>
                                <select class="form-select <?php $__errorArgs = ['upa_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="upa_id" name="upa_id">
                                    <option value="">Pilih UPA</option>
                                    <?php $__currentLoopData = \App\Models\Upa::orderBy('nama_upa')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $upa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($upa->upa_id); ?>" 
                                                <?php echo e(old('upa_id', $anggota->upa_id) == $upa->upa_id ? 'selected' : ''); ?>>
                                            <?php echo e($upa->nama_upa); ?> (<?php echo e($upa->kode_upa); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['upa_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status_keanggotaan" class="form-label">
                                    Status Keanggotaan <span class="text-danger">*</span>
                                </label>
                                <select class="form-select <?php $__errorArgs = ['status_keanggotaan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="status_keanggotaan" name="status_keanggotaan">
                                    <option value="">Pilih Status</option>
                                    <option value="Aktif" <?php echo e(old('status_keanggotaan', $anggota->status_keanggotaan) == 'Aktif' ? 'selected' : ''); ?>>Aktif</option>
                                    <option value="Tidak Aktif" <?php echo e(old('status_keanggotaan', $anggota->status_keanggotaan) == 'Tidak Aktif' ? 'selected' : ''); ?>>Tidak Aktif</option>
                                    <option value="Diberhentikan" <?php echo e(old('status_keanggotaan', $anggota->status_keanggotaan) == 'Diberhentikan' ? 'selected' : ''); ?>>Diberhentikan</option>
                                    <option value="Pindah" <?php echo e(old('status_keanggotaan', $anggota->status_keanggotaan) == 'Pindah' ? 'selected' : ''); ?>>Pindah</option>
                                </select>
                                <?php $__errorArgs = ['status_keanggotaan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_perubahan" class="form-label">
                                    Tanggal Perubahan <span class="text-danger">*</span>
                                </label>
                                <input type="date" 
                                       class="form-control <?php $__errorArgs = ['tanggal_perubahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tanggal_perubahan" 
                                       name="tanggal_perubahan" 
                                       value="<?php echo e(old('tanggal_perubahan', now()->format('Y-m-d'))); ?>">
                                <?php $__errorArgs = ['tanggal_perubahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="keterangan" class="form-label">Keterangan Perubahan</label>
                                <textarea class="form-control <?php $__errorArgs = ['keterangan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="keterangan" 
                                          name="keterangan" 
                                          rows="2" 
                                          placeholder="Masukkan keterangan perubahan..."><?php echo e(old('keterangan')); ?></textarea>
                                <?php $__errorArgs = ['keterangan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Perhatian:</strong> Data lama akan disimpan dalam history sebelum data baru disimpan.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmDelete(id, name) {
    document.getElementById('memberName').textContent = name;
    document.getElementById('deleteForm').action = `/anggota/${id}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

// Preview foto saat dipilih
document.getElementById('foto').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('fotoPreview');
            preview.src = e.target.result;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
});



// Form validation for jenjang modal
document.getElementById('jenjangForm').addEventListener('submit', function(e) {
    const requiredFields = ['ref_jenjang_id', 'dpc_id', 'dpd_id', 'status_keanggotaan', 'tanggal_perubahan'];
    let isValid = true;
    
    requiredFields.forEach(function(fieldName) {
        const field = document.getElementById(fieldName);
        if (!field.value) {
            field.classList.add('is-invalid');
            isValid = false;
        } else {
            field.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        alert('Mohon lengkapi semua field yang wajib diisi.');
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\bkdpd\resources\views/anggota/show.blade.php ENDPATH**/ ?>