@extends('layouts.app')

@section('title', 'Laporan Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar mr-2"></i>
                        Laporan Yaumiyah
                    </h3>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('yaumiyah.reports') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="anggota_id">Pilih Anggota</label>
                                    <select name="anggota_id" id="anggota_id" class="form-control">
                                        <option value="">-- Semua Anggota --</option>
                                        @foreach($anggota as $a)
                                        <option value="{{ $a->id }}" {{ $anggotaId == $a->id ? 'selected' : '' }}>
                                            {{ $a->nama_lengkap }} ({{ $a->nia }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="year">Tahun</label>
                                    <select name="year" id="year" class="form-control">
                                        @for($i = 2020; $i <= 2030; $i++)
                                        <option value="{{ $i }}" {{ $year == $i ? 'selected' : '' }}>
                                            {{ $i }}
                                        </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="fas fa-search mr-1"></i>
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($anggotaId && $reports->isNotEmpty())
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">
                                @php
                                    $selectedAnggota = $anggota->where('id', $anggotaId)->first();
                                    // Hitung total pekan dalam tahun tersebut menggunakan ISO 8601
                                    $firstDayOfYear = \Carbon\Carbon::create($year, 1, 1);
                                    $lastDayOfYear = \Carbon\Carbon::create($year, 12, 31);
                                    
                                    // Gunakan isoWeeksInYear untuk mendapatkan jumlah minggu ISO dalam tahun
                                    // Tahun bisa punya 52 atau 53 minggu ISO
                                    $totalWeeks = $firstDayOfYear->isoWeeksInYear();
                                @endphp
                                Laporan Yaumiyah - {{ $selectedAnggota->nama_lengkap ?? 'Anggota' }}
                                @if($selectedAnggota)
                                    ({{ $selectedAnggota->nia }})
                                @endif
                                - Tahun {{ $year }}
                            </h5>
                            <div class="card-tools">
                                <button type="button" class="btn btn-success btn-sm" onclick="window.print()">
                                    <i class="fas fa-print mr-1"></i> Print Laporan
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                Menampilkan laporan untuk {{ $totalWeeks }} pekan di tahun {{ $year }}. Scroll ke kanan untuk melihat pekan selanjutnya.
                            </div>
                            <div class="table-responsive" style="max-width: 100%; overflow-x: auto;">
                                <table class="table table-bordered table-striped" style="min-width: 100%;">
                                    <style>
                                        .table-responsive {
                                            position: relative;
                                        }
                                        .table-responsive table thead th:nth-child(1),
                                        .table-responsive table thead th:nth-child(2),
                                        .table-responsive table tbody td:nth-child(1),
                                        .table-responsive table tbody td:nth-child(2) {
                                            position: sticky;
                                            background-color: #fff;
                                            z-index: 10;
                                        }
                                        .table-responsive table thead th:nth-child(1),
                                        .table-responsive table tbody td:nth-child(1) {
                                            left: 0;
                                        }
                                        .table-responsive table thead th:nth-child(2),
                                        .table-responsive table tbody td:nth-child(2) {
                                            left: 50px;
                                        }
                                        .table-responsive table thead th {
                                            position: sticky;
                                            top: 0;
                                            background-color: #f8f9fa;
                                            z-index: 11;
                                        }
                                        .table-responsive table thead th:nth-child(1),
                                        .table-responsive table thead th:nth-child(2) {
                                            z-index: 12;
                                        }
                                    </style>
                                    <thead>
                                        <tr>
                                            <th rowspan="2" style="vertical-align: middle; min-width: 50px;">No</th>
                                            <th rowspan="2" style="vertical-align: middle; min-width: 250px;">Aktivitas</th>
                                            <th rowspan="2" style="vertical-align: middle; min-width: 100px;">Target/Minggu</th>
                                            <th colspan="{{ $totalWeeks }}" class="text-center">Pekan</th>
                                            <th rowspan="2" style="vertical-align: middle; min-width: 150px;">Dibuat Oleh</th>
                                        </tr>
                                        <tr>
                                            @for($i = 1; $i <= $totalWeeks; $i++)
                                            <th class="text-center" style="min-width: 60px;">{{ $i }}</th>
                                            @endfor
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($activities as $index => $activity)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                <strong>{{ $activity->name }}</strong>
                                                <br><small class="text-muted">{{ $activity->unit }}</small>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-info text-white">{{ $activity->target_per_week }}</span>
                                            </td>
                                            @for($week = 1; $week <= $totalWeeks; $week++)
                                            <td class="text-center">
                                                @php
                                                $anggotaData = $reports->get($anggotaId);
                                                $record = null;
                                                if ($anggotaData && $anggotaData->has($week)) {
                                                    $record = $anggotaData->get($week)->firstWhere('yaumiyah_activity_id', $activity->id);
                                                }
                                                @endphp
                                                @if($record)
                                                <span class="badge bg-success text-white">{{ $record->value }}</span>
                                                @else
                                                <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            @endfor
                                            <td class="text-center">
                                                @php
                                                $anggotaData = $reports->get($anggotaId);
                                                $firstRecord = null;
                                                if ($anggotaData) {
                                                    $firstRecord = $anggotaData->flatten()->firstWhere('yaumiyah_activity_id', $activity->id);
                                                }
                                                @endphp
                                                @if($firstRecord)
                                                <span class="badge {{ $firstRecord->created_by == 'admin' ? 'bg-primary' : 'bg-success' }} text-white">
                                                    {{ $firstRecord->created_by == 'admin' ? 'Admin' : 'Member' }}
                                                </span>
                                                <br><small class="text-muted">{{ $firstRecord->created_by_name }}</small>
                                                @else
                                                <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @elseif($anggotaId)
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle mr-2"></i>
                        Belum ada data yaumiyah untuk anggota ini pada tahun {{ $year }}.
                    </div>
                    @else
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle mr-2"></i>
                        Silakan pilih anggota untuk melihat laporan yaumiyah.
                    </div>
                    @endif

                    <div class="row mt-3">
                        <div class="col-12">
                            <a href="{{ route('yaumiyah.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Kembali ke Yaumiyah
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        /* Hide unnecessary elements when printing */
        .btn, .alert, .card-tools, nav, .sidebar, footer {
            display: none !important;
        }
        
        /* Make table fit better on print */
        .table-responsive {
            overflow: visible !important;
        }
        
        table {
            font-size: 10px !important;
        }
        
        .card {
            border: none !important;
        }
        
        /* Landscape orientation for wide table */
        @page {
            size: A4 landscape;
            margin: 10mm;
        }
    }
</style>
@endpush
