@extends('layouts.app')

@section('title', 'Daftar Data Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-list mr-2"></i>
                        Daftar Data Yaumiyah
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('yaumiyah.records') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus mr-1"></i>
                            Input Data Baru
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('yaumiyah.records.list') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="anggota_id">Pilih Anggota</label>
                                    <select name="anggota_id" id="anggota_id" class="form-control">
                                        <option value="">-- Semua Anggota --</option>
                                        @foreach($anggota as $a)
                                        <option value="{{ $a->id }}" {{ $anggotaId == $a->id ? 'selected' : '' }}>
                                            {{ $a->nama_lengkap }} ({{ $a->nia }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="week">Pekan</label>
                                    <select name="week" id="week" class="form-control">
                                        <option value="">-- Semua Pekan --</option>
                                        @for($i = 1; $i <= 53; $i++)
                                        <option value="{{ $i }}" {{ $week == $i ? 'selected' : '' }}>
                                            Pekan {{ $i }}
                                        </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="year">Tahun</label>
                                    <select name="year" id="year" class="form-control">
                                        @for($i = 2020; $i <= 2030; $i++)
                                        <option value="{{ $i }}" {{ $year == $i ? 'selected' : '' }}>
                                            {{ $i }}
                                        </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="fas fa-search mr-1"></i>
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($records->isNotEmpty())
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="20%">Anggota</th>
                                    <th width="10%">NIA</th>
                                    <th width="10%">Pekan</th>
                                    <th width="10%">Tahun</th>
                                    <th width="10%">Total Aktivitas</th>
                                    <th width="15%">Dibuat Oleh</th>
                                    <th width="10%">Tanggal Input</th>
                                    <th width="10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($records as $index => $record)
                                <tr>
                                    <td>{{ $records->firstItem() + $index }}</td>
                                    <td>
                                        <strong>{{ $record->anggota->nama_lengkap }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-info text-white">{{ $record->anggota->nia }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-primary text-white">Pekan {{ $record->week_number }}</span>
                                    </td>
                                    <td class="text-center">{{ $record->year }}</td>
                                    <td class="text-center">
                                        <span class="badge bg-success text-white">{{ $record->total_activities }} aktivitas</span>
                                    </td>
                                    <td>
                                        <span class="badge {{ $record->created_by == 'admin' ? 'bg-primary' : 'bg-success' }} text-white">
                                            {{ $record->created_by == 'admin' ? 'Admin' : 'Member' }}
                                        </span>
                                        <br><small class="text-muted">{{ $record->created_by_name }}</small>
                                    </td>
                                    <td>
                                        <small>{{ \Carbon\Carbon::parse($record->created_at)->format('d/m/Y H:i') }}</small>
                                    </td>
                                    <td>
                                        <a href="{{ route('yaumiyah.records.detail', ['anggota_id' => $record->anggota_id, 'week' => $record->week_number, 'year' => $record->year]) }}" 
                                           class="btn btn-sm btn-info" 
                                           title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('yaumiyah.records', ['anggota_id' => $record->anggota_id, 'week' => $record->week_number, 'year' => $record->year]) }}" 
                                           class="btn btn-sm btn-warning" 
                                           title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $records->links() }}
                    </div>
                    @else
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle mr-2"></i>
                        @if($anggotaId || $week || $year != now()->year)
                            Tidak ada data yaumiyah yang sesuai dengan filter.
                        @else
                            Belum ada data yaumiyah yang diinput.
                        @endif
                    </div>
                    @endif

                    <div class="row mt-3">
                        <div class="col-12">
                            <a href="{{ route('yaumiyah.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Kembali ke Yaumiyah
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-submit on filter change
    $('#anggota_id, #week, #year').change(function() {
        $(this).closest('form').submit();
    });
});
</script>
@endpush

