@extends('layouts.app')

@section('title', 'Detail Data Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title">
                        <i class="fas fa-clipboard-list mr-2"></i>
                        Detail Data Yaumiyah - Pekan {{ $week }} Tahun {{ $year }}
                    </h3>
                </div>
                <div class="card-body">
                    <!-- Info Anggota -->
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h5 class="mb-0">
                                <i class="fas fa-user mr-2"></i>
                                Informasi Anggota
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td width="150"><strong>Nama Lengkap</strong></td>
                                            <td>: {{ $anggota->nama_lengkap }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>NIA</strong></td>
                                            <td>: <span class="badge bg-info text-white">{{ $anggota->nia }}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Jenjang</strong></td>
                                            <td>: {{ $anggota->jenjang->nama_jenjang ?? '-' }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td width="150"><strong>Pekan</strong></td>
                                            <td>: <span class="badge bg-primary text-white">Pekan {{ $week }}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Tahun</strong></td>
                                            <td>: {{ $year }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Aktivitas</strong></td>
                                            <td>: <span class="badge bg-success text-white">{{ $records->count() }} aktivitas</span></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Data Yaumiyah -->
                    <div class="card">
                        <div class="card-header bg-light">
                            <h5 class="mb-0">
                                <i class="fas fa-tasks mr-2"></i>
                                Data Aktivitas Yaumiyah
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th width="5%">No</th>
                                            <th width="35%">Aktivitas</th>
                                            <th width="15%">Target/Minggu</th>
                                            <th width="15%">Pencapaian</th>
                                            <th width="10%">Persentase</th>
                                            <th width="20%">Catatan</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($activities as $index => $activity)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                <strong>{{ $activity->name }}</strong>
                                                @if($activity->description)
                                                <br><small class="text-muted">{{ $activity->description }}</small>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-info text-white">
                                                    {{ $activity->target_per_week }} {{ $activity->unit }}
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                @php
                                                    $record = $records->get($activity->id);
                                                    $value = $record ? $record->value : 0;
                                                @endphp
                                                @if($value > 0)
                                                    <span class="badge bg-success text-white badge-lg">
                                                        {{ $value }} {{ $activity->unit }}
                                                    </span>
                                                @else
                                                    <span class="badge bg-secondary text-white">0</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @php
                                                    $percentage = $activity->target_per_week > 0 
                                                        ? round(($value / $activity->target_per_week) * 100) 
                                                        : 0;
                                                    $progressClass = $percentage >= 100 ? 'success' : ($percentage >= 50 ? 'warning' : 'danger');
                                                @endphp
                                                <div class="progress" style="height: 25px;">
                                                    <div class="progress-bar bg-{{ $progressClass }}" 
                                                         role="progressbar" 
                                                         style="width: {{ min($percentage, 100) }}%">
                                                        {{ $percentage }}%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @if($record && $record->notes)
                                                    <small>{{ $record->notes }}</small>
                                                @else
                                                    <small class="text-muted">-</small>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot class="thead-light">
                                        <tr>
                                            <th colspan="2" class="text-right">Total Pencapaian:</th>
                                            <th class="text-center">
                                                @php
                                                    $totalTarget = $activities->sum('target_per_week');
                                                @endphp
                                                <span class="badge bg-info text-white">{{ $totalTarget }}</span>
                                            </th>
                                            <th class="text-center">
                                                @php
                                                    $totalAchievement = $records->sum('value');
                                                @endphp
                                                <span class="badge bg-success text-white">{{ $totalAchievement }}</span>
                                            </th>
                                            <th class="text-center">
                                                @php
                                                    $totalPercentage = $totalTarget > 0 
                                                        ? round(($totalAchievement / $totalTarget) * 100) 
                                                        : 0;
                                                @endphp
                                                <strong>{{ $totalPercentage }}%</strong>
                                            </th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Info Input -->
                    @if($records->first())
                    <div class="card mt-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-0">
                                        <i class="fas fa-user-edit mr-2"></i>
                                        <strong>Diinput oleh:</strong>
                                        <span class="badge {{ $records->first()->created_by == 'admin' ? 'bg-primary' : 'bg-success' }} text-white">
                                            {{ $records->first()->created_by == 'admin' ? 'Admin' : 'Member' }}
                                        </span>
                                        {{ $records->first()->created_by_name }}
                                    </p>
                                </div>
                                <div class="col-md-6 text-right">
                                    <p class="mb-0">
                                        <i class="fas fa-clock mr-2"></i>
                                        <strong>Tanggal Input:</strong>
                                        {{ \Carbon\Carbon::parse($records->first()->created_at)->format('d F Y, H:i') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="row mt-4">
                        <div class="col-12">
                            <a href="{{ route('yaumiyah.records.list') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Kembali ke Daftar
                            </a>
                            <a href="{{ route('yaumiyah.records', ['anggota_id' => $anggota->id, 'week' => $week, 'year' => $year]) }}" 
                               class="btn btn-warning">
                                <i class="fas fa-edit mr-2"></i>
                                Edit Data
                            </a>
                            <a href="{{ route('yaumiyah.reports', ['anggota_id' => $anggota->id, 'year' => $year]) }}" 
                               class="btn btn-info">
                                <i class="fas fa-chart-bar mr-2"></i>
                                Lihat Laporan Tahunan
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

