@extends('layouts.app')

@section('title', 'Yaumiyah')

@section('content')
<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-calendar-check text-primary me-2"></i>Yaumiyah
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola data aktivitas harian yaumiyah
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('yaumiyah.export', request()->except(['page'])) }}" class="btn btn-success px-3" style="border-radius: 6px;">
            <i class="fas fa-file-excel me-1"></i>Export Excel
        </a>
    </div>
</div>

<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('yaumiyah.index') }}" id="filterForm">
            <div class="row g-2 mb-3">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-user me-1 text-primary"></i>Anggota
                    </label>
                    <select name="anggota_id" class="form-select select2" style="border-radius: 6px;" data-placeholder="Pilih Anggota">
                        <option value="">Semua Anggota</option>
                        @foreach($anggota as $a)
                        <option value="{{ $a->id }}" {{ $anggotaId == $a->id ? 'selected' : '' }}>
                            {{ $a->nama_lengkap }} ({{ $a->nomor_identitas_anggota }})
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar-week me-1 text-primary"></i>Pekan
                    </label>
                    <input type="number" name="week" class="form-control" 
                           placeholder="Pekan" value="{{ $week }}" 
                           min="1" max="53"
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar-alt me-1 text-primary"></i>Tahun
                    </label>
                    <input type="number" name="year" class="form-control" 
                           placeholder="Tahun" value="{{ $year }}" 
                           min="2020" max="2030"
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-tasks me-1 text-primary"></i>Aktivitas
                    </label>
                    <select name="activity_id" class="form-select select2" style="border-radius: 6px;" data-placeholder="Pilih Aktivitas">
                        <option value="">Semua Aktivitas</option>
                        @foreach($activities as $act)
                        <option value="{{ $act->id }}" {{ $activityId == $act->id ? 'selected' : '' }}>
                            {{ $act->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-2 col-md-6 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100" style="border-radius: 6px;">
                        <i class="fas fa-search me-1"></i>Cari Data
                    </button>
                </div>
            </div>
            <div class="d-flex justify-content-end">
                @if(request()->anyFilled(['anggota_id', 'week', 'year', 'activity_id']))
                <a href="{{ route('yaumiyah.index') }}" class="btn btn-outline-secondary px-3" style="border-radius: 6px;">
                    <i class="fas fa-redo me-1"></i>Reset
                </a>
                @endif
            </div>
        </form>
    </div>
</div>

<div class="container-fluid">
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Aktivitas Yaumiyah</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Aktivitas</th>
                                    <th>Target/Minggu</th>
                                    <th>Unit</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($activities as $index => $activity)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $activity->name }}</td>
                                    <td>{{ $activity->target_per_week }}</td>
                                    <td>{{ $activity->unit }}</td>
                                    <td>
                                        <span class="text-dark">Aktif</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Records Table -->
    @if($records->count() > 0)
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Data Yaumiyah</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NIA</th>
                                    <th>Nama Anggota</th>
                                    <th>Pekan</th>
                                    <th>Tahun</th>
                                    <th>Aktivitas</th>
                                    <th>Nilai</th>
                                    <th>Unit</th>
                                    <th>Input Oleh</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($records as $index => $record)
                                <tr>
                                    <td>{{ $records->firstItem() + $index }}</td>
                                    <td>{{ $record->anggota->nomor_identitas_anggota ?? '-' }}</td>
                                    <td>{{ $record->anggota->nama_lengkap ?? '-' }}</td>
                                    <td>{{ $record->week_number }}</td>
                                    <td>{{ $record->year }}</td>
                                    <td>{{ $record->activity->name ?? '-' }}</td>
                                    <td>{{ $record->value }}</td>
                                    <td>{{ $record->activity->unit ?? '-' }}</td>
                                    <td>{{ $record->created_by_name ?? '-' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $records->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Input Data Yaumiyah</h5>
                </div>
                <div class="card-body">
                    <p>Masukkan data aktivitas yaumiyah per pekan untuk setiap anggota.</p>
                    <a href="{{ route('yaumiyah.records') }}" class="btn btn-primary">
                        <i class="fas fa-plus mr-2"></i>
                        Input Data Yaumiyah
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Daftar Data Yaumiyah</h5>
                </div>
                <div class="card-body">
                    <p>Lihat semua data yaumiyah yang sudah diinput.</p>
                    <a href="{{ route('yaumiyah.records.list') }}" class="btn btn-success">
                        <i class="fas fa-list mr-2"></i>
                        Lihat Daftar Data
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Laporan Yaumiyah</h5>
                </div>
                <div class="card-body">
                    <p>Lihat laporan dan statistik aktivitas yaumiyah.</p>
                    <a href="{{ route('yaumiyah.reports') }}" class="btn btn-info">
                        <i class="fas fa-chart-bar mr-2"></i>
                        Lihat Laporan
                    </a>
                </div>
            </div>
        </div>
    </div>

    @can('manage-yaumiyah')
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Kelola Master Aktivitas</h5>
                </div>
                <div class="card-body">
                    <p>Kelola daftar aktivitas yaumiyah yang tersedia.</p>
                    <a href="{{ route('yaumiyah.activities.index') }}" class="btn btn-warning">
                        <i class="fas fa-cog mr-2"></i>
                        Kelola Aktivitas
                    </a>
                </div>
            </div>
        </div>
    </div>
    @endcan
</div>
@endsection

