@extends('layouts.app')

@section('title', 'Edit Aktivitas Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-edit mr-2"></i>
                        Edit Aktivitas Yaumiyah
                    </h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('yaumiyah.activities.update', $activity) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="name">Nama Aktivitas <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           id="name" 
                                           name="name" 
                                           value="{{ old('name', $activity->name) }}" 
                                           required>
                                    @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="sort_order">Urutan <span class="text-danger">*</span></label>
                                    <input type="number" 
                                           class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" 
                                           name="sort_order" 
                                           value="{{ old('sort_order', $activity->sort_order) }}" 
                                           min="1" 
                                           required>
                                    @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">Deskripsi</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="3">{{ old('description', $activity->description) }}</textarea>
                            @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="target_per_week">Target per Minggu <span class="text-danger">*</span></label>
                                    <input type="number" 
                                           class="form-control @error('target_per_week') is-invalid @enderror" 
                                           id="target_per_week" 
                                           name="target_per_week" 
                                           value="{{ old('target_per_week', $activity->target_per_week) }}" 
                                           min="0" 
                                           required>
                                    @error('target_per_week')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="unit">Unit <span class="text-danger">*</span></label>
                                    <select class="form-control @error('unit') is-invalid @enderror" 
                                            id="unit" 
                                            name="unit" 
                                            required>
                                        <option value="">-- Pilih Unit --</option>
                                        <option value="kali" {{ old('unit', $activity->unit) == 'kali' ? 'selected' : '' }}>Kali</option>
                                        <option value="juz" {{ old('unit', $activity->unit) == 'juz' ? 'selected' : '' }}>Juz</option>
                                        <option value="ayat" {{ old('unit', $activity->unit) == 'ayat' ? 'selected' : '' }}>Ayat</option>
                                        <option value="surat" {{ old('unit', $activity->unit) == 'surat' ? 'selected' : '' }}>Surat</option>
                                        <option value="jam" {{ old('unit', $activity->unit) == 'jam' ? 'selected' : '' }}>Jam</option>
                                        <option value="menit" {{ old('unit', $activity->unit) == 'menit' ? 'selected' : '' }}>Menit</option>
                                        <option value="rupiah" {{ old('unit', $activity->unit) == 'rupiah' ? 'selected' : '' }}>Rupiah</option>
                                    </select>
                                    @error('unit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <select class="form-control @error('is_active') is-invalid @enderror" 
                                            id="is_active" 
                                            name="is_active">
                                        <option value="1" {{ old('is_active', $activity->is_active ? '1' : '0') == '1' ? 'selected' : '' }}>Aktif</option>
                                        <option value="0" {{ old('is_active', $activity->is_active ? '1' : '0') == '0' ? 'selected' : '' }}>Tidak Aktif</option>
                                    </select>
                                    @error('is_active')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-save mr-2"></i>
                                    Update Aktivitas
                                </button>
                                <a href="{{ route('yaumiyah.activities.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left mr-2"></i>
                                    Kembali
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
