@extends('layouts.app')

@section('title', 'Edit User')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">
                        <i class="fas fa-user-edit me-2"></i>Edit User: {{ $user->name }}
                    </h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('user-management.update', $user) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           id="name" 
                                           name="name" 
                                           value="{{ old('name', $user->name) }}" 
                                           placeholder="Masukkan nama lengkap"
                                           required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           id="email" 
                                           name="email" 
                                           value="{{ old('email', $user->email) }}" 
                                           placeholder="Masukkan email"
                                           required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label">Password Baru</label>
                                    <div class="position-relative">
                                        <input type="password" 
                                               class="form-control @error('password') is-invalid @enderror" 
                                               id="password" 
                                               name="password" 
                                               placeholder="Kosongkan jika tidak ingin mengubah password">
                                        <button type="button" 
                                                class="btn btn-link position-absolute end-0 top-50 translate-middle-y pe-2" 
                                                id="togglePassword"
                                                style="border: none; background: none; cursor: pointer; z-index: 10;">
                                            <i class="fas fa-eye" id="togglePasswordIcon"></i>
                                        </button>
                                    </div>
                                    @error('password')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">Kosongkan jika tidak ingin mengubah password</div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label">Konfirmasi Password Baru</label>
                                    <div class="position-relative">
                                        <input type="password" 
                                               class="form-control" 
                                               id="password_confirmation" 
                                               name="password_confirmation" 
                                               placeholder="Konfirmasi password baru">
                                        <button type="button" 
                                                class="btn btn-link position-absolute end-0 top-50 translate-middle-y pe-2" 
                                                id="togglePasswordConfirmation"
                                                style="border: none; background: none; cursor: pointer; z-index: 10;">
                                            <i class="fas fa-eye" id="togglePasswordConfirmationIcon"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="role" class="form-label">Role <span class="text-danger">*</span></label>
                                    <select class="form-select @error('role') is-invalid @enderror" 
                                            id="role" 
                                            name="role" 
                                            required
                                            onchange="toggleScopeFields()">
                                        <option value="">Pilih Role</option>
                                        @foreach($roles as $value => $label)
                                            <option value="{{ $value }}" {{ old('role', $user->role) == $value ? 'selected' : '' }}>
                                                {{ $label }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('role')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <div class="form-check">
                                        <input class="form-check-input" 
                                               type="checkbox" 
                                               id="is_active" 
                                               name="is_active" 
                                               value="1" 
                                               {{ old('is_active', $user->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Aktif
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Scope Fields (DPC/DPD/Anggota) -->
                        <div id="scope-fields" style="display: none;">
                            <!-- Admin DPC: DPC Selection -->
                            <div class="row" id="dpc-field" style="display: none;">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="dpc_id" class="form-label">DPC <span class="text-danger">*</span></label>
                                        <select class="form-select @error('dpc_id') is-invalid @enderror" 
                                                id="dpc_id" 
                                                name="dpc_id">
                                            <option value="">Pilih DPC</option>
                                            @foreach($dpcs as $dpc)
                                                <option value="{{ $dpc->dpc_id }}" {{ old('dpc_id', $user->dpc_id) == $dpc->dpc_id ? 'selected' : '' }}>
                                                    {{ $dpc->nama_dpc }} ({{ $dpc->kode_dpc }})
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('dpc_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Admin DPD: DPD Selection -->
                            <div class="row" id="dpd-field" style="display: none;">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="dpd_id" class="form-label">DPD <span class="text-danger">*</span></label>
                                        <select class="form-select @error('dpd_id') is-invalid @enderror" 
                                                id="dpd_id" 
                                                name="dpd_id">
                                            <option value="">Pilih DPD</option>
                                            @foreach($dpds as $dpd)
                                                <option value="{{ $dpd->dpd_id }}" {{ old('dpd_id', $user->dpd_id) == $dpd->dpd_id ? 'selected' : '' }}>
                                                    {{ $dpd->nama_dpd }} ({{ $dpd->kode_dpd }})
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('dpd_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Anggota: Anggota Selection -->
                            <div class="row" id="anggota-field" style="display: none;">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="anggota_id" class="form-label">Anggota <span class="text-danger">*</span></label>
                                        <select class="form-select @error('anggota_id') is-invalid @enderror" 
                                                id="anggota_id" 
                                                name="anggota_id">
                                            <option value="">Pilih Anggota</option>
                                            @if(isset($anggotas) && $anggotas->count() > 0)
                                                @foreach($anggotas as $anggota)
                                                    <option value="{{ $anggota->anggota_id }}" {{ old('anggota_id', $user->anggota_id) == $anggota->anggota_id ? 'selected' : '' }}>
                                                        {{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota ?? 'N/A' }})
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        @error('anggota_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Anggota akan otomatis terisi saat role dipilih</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Informasi:</strong>
                                    <ul class="mb-0 mt-2">
                                        <li><strong>Password:</strong> Minimal 8 karakter (jika diisi), harus mengandung huruf besar, huruf kecil, angka, dan simbol khusus (@$!%*?&)</li>
                                        <li>Email harus unik dan valid</li>
                                        <li>User yang tidak aktif tidak dapat login</li>
                                        @if(auth()->user()->isSuperAdmin())
                                            <li>Hanya Super Admin yang dapat mengubah role ke Super Admin</li>
                                        @endif
                                        @if($user->isSuperAdmin() && !auth()->user()->isSuperAdmin())
                                            <li class="text-warning">Anda tidak dapat mengubah Super Admin</li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('user-management.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Kembali
                            </a>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update User
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleScopeFields() {
    const role = document.getElementById('role').value;
    const scopeFields = document.getElementById('scope-fields');
    const dpcField = document.getElementById('dpc-field');
    const dpdField = document.getElementById('dpd-field');
    const anggotaField = document.getElementById('anggota-field');

    // Hide all fields first
    scopeFields.style.display = 'none';
    dpcField.style.display = 'none';
    dpdField.style.display = 'none';
    anggotaField.style.display = 'none';

    // Show relevant fields based on role
    if (role === 'admin_dpc') {
        scopeFields.style.display = 'block';
        dpcField.style.display = 'block';
        document.getElementById('dpc_id').required = true;
        document.getElementById('dpd_id').required = false;
        document.getElementById('anggota_id').required = false;
    } else if (role === 'admin_dpd') {
        scopeFields.style.display = 'block';
        dpdField.style.display = 'block';
        document.getElementById('dpc_id').required = false;
        document.getElementById('dpd_id').required = true;
        document.getElementById('anggota_id').required = false;
    } else if (role === 'anggota') {
        scopeFields.style.display = 'block';
        anggotaField.style.display = 'block';
        document.getElementById('dpc_id').required = false;
        document.getElementById('dpd_id').required = false;
        document.getElementById('anggota_id').required = true;
    } else {
        document.getElementById('dpc_id').required = false;
        document.getElementById('dpd_id').required = false;
        document.getElementById('anggota_id').required = false;
    }
}

// Call on page load to set initial state
document.addEventListener('DOMContentLoaded', function() {
    toggleScopeFields();
    
    // Toggle password visibility
    const togglePassword = document.getElementById('togglePassword');
    const togglePasswordConfirmation = document.getElementById('togglePasswordConfirmation');
    const passwordInput = document.getElementById('password');
    const passwordConfirmationInput = document.getElementById('password_confirmation');
    const togglePasswordIcon = document.getElementById('togglePasswordIcon');
    const togglePasswordConfirmationIcon = document.getElementById('togglePasswordConfirmationIcon');
    
    if (togglePassword && passwordInput) {
        togglePassword.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            if (type === 'password') {
                togglePasswordIcon.classList.remove('fa-eye-slash');
                togglePasswordIcon.classList.add('fa-eye');
            } else {
                togglePasswordIcon.classList.remove('fa-eye');
                togglePasswordIcon.classList.add('fa-eye-slash');
            }
        });
    }
    
    if (togglePasswordConfirmation && passwordConfirmationInput) {
        togglePasswordConfirmation.addEventListener('click', function() {
            const type = passwordConfirmationInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordConfirmationInput.setAttribute('type', type);
            
            if (type === 'password') {
                togglePasswordConfirmationIcon.classList.remove('fa-eye-slash');
                togglePasswordConfirmationIcon.classList.add('fa-eye');
            } else {
                togglePasswordConfirmationIcon.classList.remove('fa-eye');
                togglePasswordConfirmationIcon.classList.add('fa-eye-slash');
            }
        });
    }
});
</script>
@endsection
