@extends('layouts.app')

@section('title', 'Detail UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Detail UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa.index') }}">Master UPA</a></li>
                        <li class="breadcrumb-item active">Detail UPA</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Informasi UPA -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">{{ $upa->nama_upa }}</h5>
                        <div>
                            <a href="{{ route('upa.edit', $upa) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit me-1"></i> Edit
                            </a>
                            <a href="{{ route('upa.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold text-muted">Kode UPA:</td>
                                    <td><span class="badge bg-primary">{{ $upa->kode_upa }}</span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Nama UPA:</td>
                                    <td>{{ $upa->nama_upa }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Status:</td>
                                    <td>
                                        <span class="badge bg-{{ $upa->status == 'Aktif' ? 'success' : ($upa->status == 'Tidak Aktif' ? 'warning' : 'danger') }}">
                                            {{ $upa->status }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Tanggal Berdiri:</td>
                                    <td>
                                        @if($upa->tanggal_berdiri)
                                            {{ $upa->tanggal_berdiri->format('d F Y') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Pembimbing:</td>
                                    <td>
                                        @if($upa->pembimbing && $upa->pembimbing->count() > 0)
                                            @foreach($upa->pembimbing as $pembimbing)
                                                <div class="d-flex align-items-center mb-1">
                                                    <div class="avatar-sm bg-primary rounded-circle d-flex align-items-center justify-content-center me-2">
                                                        <span class="text-white fw-bold">{{ substr($pembimbing->nama_lengkap, 0, 1) }}</span>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold">{{ $pembimbing->nama_lengkap }}</div>
                                                        <small class="text-muted">{{ $pembimbing->nomor_identitas_anggota }}</small>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                        <tr>
                            <td class="fw-bold text-muted">DPC:</td>
                            <td>{{ $upa->dpc->nama_dpc ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="fw-bold text-muted">Kelurahan:</td>
                            <td>{{ $upa->refKelurahan->nama_kelurahan ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="fw-bold text-muted">Kecamatan:</td>
                            <td>{{ $upa->refKecamatan->nama_kecamatan ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="fw-bold text-muted">Kota:</td>
                            <td>{{ $upa->refKota->nama_kota ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="fw-bold text-muted">Provinsi:</td>
                            <td>{{ $upa->refProvinsi->nama_provinsi ?? '-' }}</td>
                        </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Kode Pos:</td>
                                    <td>{{ $upa->kode_pos ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">No. Telepon:</td>
                                    <td>{{ $upa->no_telepon ?? '-' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($upa->deskripsi)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Deskripsi</h6>
                                <p class="text-muted">{{ $upa->deskripsi }}</p>
                            </div>
                        </div>
                    @endif

                    @if($upa->alamat)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Alamat</h6>
                                <p class="text-muted">{{ $upa->alamat }}</p>
                            </div>
                        </div>
                    @endif

                    @if($upa->email)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Email</h6>
                                <p class="text-muted">
                                    <a href="mailto:{{ $upa->email }}" class="text-decoration-none">{{ $upa->email }}</a>
                                </p>
                            </div>
                        </div>
                    @endif

                    @if($upa->catatan)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Catatan</h6>
                                <p class="text-muted">{{ $upa->catatan }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Statistik UPA -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Statistik UPA</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="text-primary fw-bold fs-4">
                                {{ $upa->anggotaAktif->count() }}
                            </div>
                            <small class="text-muted">Total Anggota</small>
                        </div>
                        <div class="col-6">
                            <div class="text-success fw-bold fs-4">
                                {{ $upa->anggotaAktif->count() }}
                            </div>
                            <small class="text-muted">Anggota Aktif</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


            <!-- Form Update Pembimbing -->
            <div class="card mt-4">
                <div class="card-header bg-warning text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user-edit me-2"></i>Ubah Pembimbing UPA
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('upa.update-pembimbing', $upa->upa_id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Pilih Pembimbing Baru <span class="text-danger">*</span></label>
                                <select class="form-select @error('pembimbing_anggota_id') is-invalid @enderror"
                                        name="pembimbing_anggota_id" required>
                                    <option value="">Pilih Pembimbing</option>
                                    @foreach($anggotaList as $anggota)
                                        <option value="{{ $anggota->id }}" {{ old('pembimbing_anggota_id') == $anggota->id ? 'selected' : '' }}>
                                            {{ $anggota->nama_lengkap }} - {{ $anggota->nomor_identitas_anggota }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('pembimbing_anggota_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label class="form-label">Tanggal Mulai</label>
                                <input type="date" class="form-control @error('pembimbing_tanggal_mulai') is-invalid @enderror"
                                       name="pembimbing_tanggal_mulai" value="{{ old('pembimbing_tanggal_mulai') }}">
                                @error('pembimbing_tanggal_mulai')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label class="form-label">Tanggal Selesai</label>
                                <input type="date" class="form-control @error('pembimbing_tanggal_selesai') is-invalid @enderror"
                                       name="pembimbing_tanggal_selesai" value="{{ old('pembimbing_tanggal_selesai') }}">
                                @error('pembimbing_tanggal_selesai')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label class="form-label">Catatan</label>
                                <input type="text" class="form-control @error('pembimbing_catatan') is-invalid @enderror"
                                       name="pembimbing_catatan" value="{{ old('pembimbing_catatan') }}"
                                       placeholder="Catatan pembimbing">
                                @error('pembimbing_catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-1 mb-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-save"></i> Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Daftar Anggota UPA -->
            <div class="card mt-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>Daftar Anggota UPA
                        <span class="badge bg-light text-primary ms-2">{{ $upa->anggotaAktif->count() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($upa->anggotaAktif->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>No</th>
                                        <th>NIA</th>
                                        <th>Nama Lengkap</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($upa->anggotaAktif as $index => $anggota)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $anggota->nomor_identitas_anggota }}</span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if($anggota->foto)
                                                    <img src="{{ asset('storage/foto_anggota/' . $anggota->foto) }}" 
                                                         alt="{{ $anggota->nama_lengkap }}" 
                                                         class="rounded-circle me-2" 
                                                         style="width: 32px; height: 32px; object-fit: cover;">
                                                @else
                                                    <div class="bg-secondary rounded-circle me-2 d-flex align-items-center justify-content-center" 
                                                         style="width: 32px; height: 32px;">
                                                        <i class="fas fa-user text-white" style="font-size: 14px;"></i>
                                                    </div>
                                                @endif
                                                <div>
                                                    <div class="fw-bold">{{ $anggota->nama_lengkap }}</div>
                                                    @if($anggota->refJenjang)
                                                        <small class="text-muted">{{ $anggota->refJenjang->nama_jenjang }}</small>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">{{ $anggota->status_keanggotaan }}</span>
                                        </td>
                                        <td>
                                            <a href="{{ $anggota->show_url }}" class="btn btn-sm btn-outline-primary" title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <div class="mb-3">
                                <i class="fas fa-users text-muted" style="font-size: 3rem;"></i>
                            </div>
                            <h6 class="text-muted">Belum Ada Anggota</h6>
                            <p class="text-muted mb-0">Belum ada anggota yang terdaftar di UPA ini</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Form Tambah Anggota UPA -->
            <div class="card mt-4">
                <div class="card-header bg-success text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user-plus me-2"></i>Tambah Anggota UPA
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('upa.add-member', $upa->upa_id) }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Pilih Anggota <span class="text-danger">*</span></label>
                                <select class="form-select @error('anggota_id') is-invalid @enderror" 
                                        name="anggota_id" required>
                                    <option value="">Pilih Anggota</option>
                                    @foreach($anggotaList as $anggota)
                                        <option value="{{ $anggota->id }}" {{ old('anggota_id') == $anggota->id ? 'selected' : '' }}>
                                            {{ $anggota->nama_lengkap }} - {{ $anggota->nomor_identitas_anggota }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('anggota_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Jabatan <span class="text-danger">*</span></label>
                                <select class="form-select @error('jabatan') is-invalid @enderror" 
                                        name="jabatan" required>
                                    <option value="">Pilih Jabatan</option>
                                    <option value="Sekretaris" {{ old('jabatan') == 'Sekretaris' ? 'selected' : '' }}>Sekretaris</option>
                                    <option value="Bendahara" {{ old('jabatan') == 'Bendahara' ? 'selected' : '' }}>Bendahara</option>
                                    <option value="Anggota" {{ old('jabatan') == 'Anggota' ? 'selected' : '' }}>Anggota</option>
                                </select>
                                @error('jabatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Tanggal Mulai</label>
                                <input type="date" class="form-control @error('tanggal_mulai') is-invalid @enderror" 
                                       name="tanggal_mulai" value="{{ old('tanggal_mulai') }}">
                                @error('tanggal_mulai')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Tanggal Selesai</label>
                                <input type="date" class="form-control @error('tanggal_selesai') is-invalid @enderror" 
                                       name="tanggal_selesai" value="{{ old('tanggal_selesai') }}">
                                @error('tanggal_selesai')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-1 mb-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          name="catatan" rows="2" 
                                          placeholder="Catatan untuk anggota ini">{{ old('catatan') }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
