@extends('layouts.app')

@section('title', 'Edit UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Edit UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa.index') }}">Master UPA</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa.show', $upa) }}">{{ $upa->nama_upa }}</a></li>
                        <li class="breadcrumb-item active">Edit</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Edit UPA</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('upa.update', $upa) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <!-- Informasi Dasar UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Informasi Dasar UPA</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Kode UPA <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kode_upa') is-invalid @enderror" 
                                       name="kode_upa" value="{{ old('kode_upa', $upa->kode_upa) }}" 
                                       placeholder="Contoh: UPA001">
                                @error('kode_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nama UPA <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_upa') is-invalid @enderror" 
                                       name="nama_upa" value="{{ old('nama_upa', $upa->nama_upa) }}" 
                                       placeholder="Nama lengkap UPA">
                                @error('nama_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Deskripsi</label>
                                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                          name="deskripsi" rows="3" 
                                          placeholder="Deskripsi singkat tentang UPA">{{ old('deskripsi', $upa->deskripsi) }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- DPC -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Organisasi</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">DPC <span class="text-danger">*</span></label>
                                <select class="form-select @error('dpc_id') is-invalid @enderror" 
                                        name="dpc_id" required>
                                    <option value="">Pilih DPC</option>
                                    @foreach($dpcList as $dpc)
                                        <option value="{{ $dpc->dpc_id }}" {{ old('dpc_id', $upa->dpc_id) == $dpc->dpc_id ? 'selected' : '' }}>
                                            {{ $dpc->nama_dpc }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('dpc_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Alamat UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Alamat UPA</h6>
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Alamat Lengkap</label>
                                <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                          name="alamat" rows="2" 
                                          placeholder="Alamat lengkap UPA">{{ old('alamat', $upa->alamat) }}</textarea>
                                @error('alamat')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Provinsi <span class="text-danger">*</span></label>
                                <select class="form-select @error('provinsi_id') is-invalid @enderror" 
                                        name="provinsi_id" id="provinsi_id" required>
                                    <option value="">Pilih Provinsi</option>
                                </select>
                                @error('provinsi_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kota/Kabupaten <span class="text-danger">*</span></label>
                                <select class="form-select @error('kota_id') is-invalid @enderror" 
                                        name="kota_id" id="kota_id" required disabled>
                                    <option value="">Pilih Kota/Kabupaten</option>
                                </select>
                                @error('kota_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kecamatan <span class="text-danger">*</span></label>
                                <select class="form-select @error('kecamatan_id') is-invalid @enderror" 
                                        name="kecamatan_id" id="kecamatan_id" required disabled>
                                    <option value="">Pilih Kecamatan</option>
                                </select>
                                @error('kecamatan_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kelurahan/Desa <span class="text-danger">*</span></label>
                                <select class="form-select @error('kelurahan_id') is-invalid @enderror" 
                                        name="kelurahan_id" id="kelurahan_id" required disabled>
                                    <option value="">Pilih Kelurahan/Desa</option>
                                </select>
                                @error('kelurahan_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Kode Pos</label>
                                <input type="text" class="form-control @error('kode_pos') is-invalid @enderror" 
                                       name="kode_pos" id="kode_pos" value="{{ old('kode_pos', $upa->kode_pos) }}" 
                                       placeholder="Kode Pos" readonly>
                                @error('kode_pos')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Kontak UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Kontak UPA</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">No. Telepon</label>
                                <input type="text" class="form-control @error('no_telepon') is-invalid @enderror" 
                                       name="no_telepon" value="{{ old('no_telepon', $upa->no_telepon) }}" 
                                       placeholder="No. Telepon">
                                @error('no_telepon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                       name="email" value="{{ old('email', $upa->email) }}" 
                                       placeholder="Email UPA">
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Informasi Tambahan -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Informasi Tambahan</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tanggal Berdiri</label>
                                <input type="date" class="form-control @error('tanggal_berdiri') is-invalid @enderror" 
                                       name="tanggal_berdiri" value="{{ old('tanggal_berdiri', $upa->tanggal_berdiri?->format('Y-m-d')) }}">
                                @error('tanggal_berdiri')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" name="status">
                                    <option value="">Pilih Status</option>
                                    <option value="Aktif" {{ old('status', $upa->status) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="Tidak Aktif" {{ old('status', $upa->status) == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                    <option value="Dibubarkan" {{ old('status', $upa->status) == 'Dibubarkan' ? 'selected' : '' }}>Dibubarkan</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          name="catatan" rows="3" 
                                          placeholder="Catatan tambahan">{{ old('catatan', $upa->catatan) }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Pembimbing UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Pembimbing UPA</h6>
                                <p class="text-muted">Kelola pembimbing UPA ini</p>
                            </div>
                            
                            <div class="col-12">
                                <div id="pembimbing-container">
                                    @if($upa->pembimbing && $upa->pembimbing->count() > 0)
                                        @foreach($upa->pembimbing as $index => $pembimbing)
                                            <div class="pembimbing-item mb-3 p-3 border rounded">
                                                <div class="row">
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Anggota</label>
                                                        <select class="form-select" name="pembimbing[{{ $index }}][anggota_id]" required>
                                                            <option value="">Pilih Anggota</option>
                                                            @foreach($anggotaList as $anggota)
                                                                <option value="{{ $anggota->id }}" {{ $pembimbing->id == $anggota->id ? 'selected' : '' }}>
                                                                    {{ $anggota->nama_lengkap }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mb-2">
                                                        <label class="form-label">Jabatan</label>
                                                        <select class="form-select" name="pembimbing[{{ $index }}][jabatan]" required>
                                                            <option value="">Pilih Jabatan</option>
                                                            <option value="Ketua" {{ $pembimbing->pivot->jabatan == 'Ketua' ? 'selected' : '' }}>Ketua</option>
                                                            <option value="Wakil Ketua" {{ $pembimbing->pivot->jabatan == 'Wakil Ketua' ? 'selected' : '' }}>Wakil Ketua</option>
                                                            <option value="Sekretaris" {{ $pembimbing->pivot->jabatan == 'Sekretaris' ? 'selected' : '' }}>Sekretaris</option>
                                                            <option value="Bendahara" {{ $pembimbing->pivot->jabatan == 'Bendahara' ? 'selected' : '' }}>Bendahara</option>
                                                            <option value="Anggota" {{ $pembimbing->pivot->jabatan == 'Anggota' ? 'selected' : '' }}>Anggota</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2 mb-2">
                                                        <label class="form-label">Tanggal Mulai</label>
                                                        <input type="date" class="form-control" name="pembimbing[{{ $index }}][tanggal_mulai]" 
                                                               value="{{ $pembimbing->pivot->tanggal_mulai }}">
                                                    </div>
                                                    <div class="col-md-2 mb-2">
                                                        <label class="form-label">Tanggal Selesai</label>
                                                        <input type="date" class="form-control" name="pembimbing[{{ $index }}][tanggal_selesai]" 
                                                               value="{{ $pembimbing->pivot->tanggal_selesai }}">
                                                    </div>
                                                    <div class="col-md-1 mb-2 d-flex align-items-end">
                                                        <button type="button" class="btn btn-outline-danger" onclick="removePembimbing(this)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6 mb-2">
                                                        <label class="form-label">Status</label>
                                                        <select class="form-select" name="pembimbing[{{ $index }}][status]" required>
                                                            <option value="Aktif" {{ $pembimbing->pivot->status == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                                            <option value="Tidak Aktif" {{ $pembimbing->pivot->status == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6 mb-2">
                                                        <label class="form-label">Catatan</label>
                                                        <textarea class="form-control" name="pembimbing[{{ $index }}][catatan]" rows="2" 
                                                                  placeholder="Catatan untuk pembimbing ini">{{ $pembimbing->pivot->catatan }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="pembimbing-item mb-3 p-3 border rounded">
                                            <div class="row">
                                                <div class="col-md-4 mb-2">
                                                    <label class="form-label">Anggota</label>
                                                    <select class="form-select" name="pembimbing[0][anggota_id]" required>
                                                        <option value="">Pilih Anggota</option>
                                                        @foreach($anggotaList as $anggota)
                                                            <option value="{{ $anggota->id }}">{{ $anggota->nama_lengkap }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-3 mb-2">
                                                    <label class="form-label">Jabatan</label>
                                                    <select class="form-select" name="pembimbing[0][jabatan]" required>
                                                        <option value="">Pilih Jabatan</option>
                                                        <option value="Ketua">Ketua</option>
                                                        <option value="Wakil Ketua">Wakil Ketua</option>
                                                        <option value="Sekretaris">Sekretaris</option>
                                                        <option value="Bendahara">Bendahara</option>
                                                        <option value="Anggota">Anggota</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label">Tanggal Mulai</label>
                                                    <input type="date" class="form-control" name="pembimbing[0][tanggal_mulai]">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label">Tanggal Selesai</label>
                                                    <input type="date" class="form-control" name="pembimbing[0][tanggal_selesai]">
                                                </div>
                                                <div class="col-md-1 mb-2 d-flex align-items-end">
                                                    <button type="button" class="btn btn-outline-danger" onclick="removePembimbing(this)">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 mb-2">
                                                    <label class="form-label">Status</label>
                                                    <select class="form-select" name="pembimbing[0][status]" required>
                                                        <option value="Aktif">Aktif</option>
                                                        <option value="Tidak Aktif">Tidak Aktif</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 mb-2">
                                                    <label class="form-label">Catatan</label>
                                                    <textarea class="form-control" name="pembimbing[0][catatan]" rows="2" 
                                                              placeholder="Catatan untuk pembimbing ini"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                
                                <button type="button" class="btn btn-outline-primary" onclick="addPembimbing()">
                                    <i class="fas fa-plus me-1"></i> Tambah Pembimbing
                                </button>
                            </div>
                        </div>

                        <!-- Tombol Aksi -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Update UPA
                                    </button>
                                    <a href="{{ route('upa.show', $upa) }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Batal
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let pembimbingIndex = {{ $upa->pembimbing ? $upa->pembimbing->count() : 1 }};

function addPembimbing() {
    const container = document.getElementById('pembimbing-container');
    const newItem = document.createElement('div');
    newItem.className = 'pembimbing-item mb-3 p-3 border rounded';
    newItem.innerHTML = `
        <div class="row">
            <div class="col-md-4 mb-2">
                <label class="form-label">Anggota</label>
                <select class="form-select" name="pembimbing[${pembimbingIndex}][anggota_id]" required>
                    <option value="">Pilih Anggota</option>
                    @foreach($anggotaList as $anggota)
                        <option value="{{ $anggota->id }}">{{ $anggota->nama_lengkap }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3 mb-2">
                <label class="form-label">Jabatan</label>
                <select class="form-select" name="pembimbing[${pembimbingIndex}][jabatan]" required>
                    <option value="">Pilih Jabatan</option>
                    <option value="Ketua">Ketua</option>
                    <option value="Wakil Ketua">Wakil Ketua</option>
                    <option value="Sekretaris">Sekretaris</option>
                    <option value="Bendahara">Bendahara</option>
                    <option value="Anggota">Anggota</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label">Tanggal Mulai</label>
                <input type="date" class="form-control" name="pembimbing[${pembimbingIndex}][tanggal_mulai]">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label">Tanggal Selesai</label>
                <input type="date" class="form-control" name="pembimbing[${pembimbingIndex}][tanggal_selesai]">
            </div>
            <div class="col-md-1 mb-2 d-flex align-items-end">
                <button type="button" class="btn btn-outline-danger" onclick="removePembimbing(this)">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 mb-2">
                <label class="form-label">Status</label>
                <select class="form-select" name="pembimbing[${pembimbingIndex}][status]" required>
                    <option value="Aktif">Aktif</option>
                    <option value="Tidak Aktif">Tidak Aktif</option>
                </select>
            </div>
            <div class="col-md-6 mb-2">
                <label class="form-label">Catatan</label>
                <textarea class="form-control" name="pembimbing[${pembimbingIndex}][catatan]" rows="2" 
                          placeholder="Catatan untuk pembimbing ini"></textarea>
            </div>
        </div>
    `;
    container.appendChild(newItem);
    pembimbingIndex++;
}

function removePembimbing(button) {
    const container = document.getElementById('pembimbing-container');
    if (container.children.length > 1) {
        button.closest('.pembimbing-item').remove();
    }
}

// Cascading Dropdown untuk Alamat
document.addEventListener('DOMContentLoaded', function() {
    const provinsiSelect = document.getElementById('provinsi_id');
    const kotaSelect = document.getElementById('kota_id');
    const kecamatanSelect = document.getElementById('kecamatan_id');
    const kelurahanSelect = document.getElementById('kelurahan_id');
    
    // Load data awal
    loadProvinsi();
    
    // Event listeners
    provinsiSelect.addEventListener('change', function() {
        const provinsiId = this.value;
        if (provinsiId) {
            loadKota(provinsiId);
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
            resetKodePos();
        } else {
            resetDropdown(kotaSelect);
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
            resetKodePos();
        }
    });

    kotaSelect.addEventListener('change', function() {
        const kotaId = this.value;
        if (kotaId) {
            loadKecamatan(kotaId);
            resetDropdown(kelurahanSelect);
            resetKodePos();
        } else {
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
            resetKodePos();
        }
    });

    kecamatanSelect.addEventListener('change', function() {
        const kecamatanId = this.value;
        if (kecamatanId) {
            loadKelurahan(kecamatanId);
            resetKodePos();
        } else {
            resetDropdown(kelurahanSelect);
            resetKodePos();
        }
    });

    kelurahanSelect.addEventListener('change', function() {
        const kelurahanId = this.value;
        if (kelurahanId) {
            loadKodePos(kelurahanId);
        } else {
            resetKodePos();
        }
    });

    function loadProvinsi() {
        fetch('{{ route("api.provinsi") }}')
            .then(response => response.json())
            .then(data => {
                provinsiSelect.innerHTML = '<option value="">Pilih Provinsi</option>';
                data.forEach(provinsi => {
                    const option = document.createElement('option');
                    option.value = provinsi.id;
                    option.textContent = provinsi.nama_provinsi;
                    provinsiSelect.appendChild(option);
                });
                
                // Pre-select existing data
                @if(isset($upa->provinsi_id))
                    provinsiSelect.value = '{{ $upa->provinsi_id }}';
                    if (provinsiSelect.value) {
                        loadKota('{{ $upa->provinsi_id }}');
                    }
                @endif
            })
            .catch(error => console.error('Error loading provinsi:', error));
    }

    function loadKota(provinsiId) {
        fetch(`{{ route("api.kota") }}?provinsi_id=${provinsiId}`)
            .then(response => response.json())
            .then(data => {
                kotaSelect.innerHTML = '<option value="">Pilih Kota/Kabupaten</option>';
                data.forEach(kota => {
                    const option = document.createElement('option');
                    option.value = kota.id;
                    option.textContent = `${kota.nama_kota} (${kota.tipe})`;
                    kotaSelect.appendChild(option);
                });
                kotaSelect.disabled = false;
                
                // Pre-select existing data
                @if(isset($upa->kota_id))
                    kotaSelect.value = '{{ $upa->kota_id }}';
                    if (kotaSelect.value) {
                        loadKecamatan('{{ $upa->kota_id }}');
                    }
                @endif
            })
            .catch(error => console.error('Error loading kota:', error));
    }

    function loadKecamatan(kotaId) {
        fetch(`{{ route("api.kecamatan") }}?kota_id=${kotaId}`)
            .then(response => response.json())
            .then(data => {
                kecamatanSelect.innerHTML = '<option value="">Pilih Kecamatan</option>';
                data.forEach(kecamatan => {
                    const option = document.createElement('option');
                    option.value = kecamatan.id;
                    option.textContent = kecamatan.nama_kecamatan;
                    kecamatanSelect.appendChild(option);
                });
                kecamatanSelect.disabled = false;
                
                // Pre-select existing data
                @if(isset($upa->kecamatan_id))
                    kecamatanSelect.value = '{{ $upa->kecamatan_id }}';
                    if (kecamatanSelect.value) {
                        loadKelurahan('{{ $upa->kecamatan_id }}');
                    }
                @endif
            })
            .catch(error => console.error('Error loading kecamatan:', error));
    }

    function loadKelurahan(kecamatanId) {
        fetch(`{{ route("api.kelurahan") }}?kecamatan_id=${kecamatanId}`)
            .then(response => response.json())
            .then(data => {
                kelurahanSelect.innerHTML = '<option value="">Pilih Kelurahan/Desa</option>';
                data.forEach(kelurahan => {
                    const option = document.createElement('option');
                    option.value = kelurahan.id;
                    option.textContent = kelurahan.nama_kelurahan;
                    if (kelurahan.kode_pos) {
                        option.setAttribute('data-kode-pos', kelurahan.kode_pos);
                    }
                    kelurahanSelect.appendChild(option);
                });
                kelurahanSelect.disabled = false;
                
                // Pre-select existing data
                @if(isset($upa->kelurahan_id))
                    kelurahanSelect.value = '{{ $upa->kelurahan_id }}';
                    if (kelurahanSelect.value) {
                        loadKodePos('{{ $upa->kelurahan_id }}');
                    }
                @endif
            })
            .catch(error => console.error('Error loading kelurahan:', error));
    }

    function loadKodePos(kelurahanId) {
        const selectedOption = kelurahanSelect.options[kelurahanSelect.selectedIndex];
        const kodePosInput = document.getElementById('kode_pos');
        
        if (!kodePosInput) {
            console.error('Kode pos input element not found!');
            return;
        }
        
        const kodePos = selectedOption.getAttribute('data-kode-pos');
        if (kodePos) {
            kodePosInput.value = kodePos;
        } else {
            kodePosInput.value = '';
        }
    }

    function resetDropdown(select) {
        select.innerHTML = '<option value="">Pilih ' + select.previousElementSibling.textContent.replace(' *', '') + '</option>';
        select.disabled = true;
    }

    function resetKodePos() {
        const kodePosInput = document.getElementById('kode_pos');
        if (kodePosInput) kodePosInput.value = '';
    }
});
</script>
@endsection
