@extends('layouts.app')

@section('title', 'Tambah UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Tambah UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa.index') }}">Master UPA</a></li>
                        <li class="breadcrumb-item active">Tambah UPA</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Tambah UPA</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('upa.store') }}" method="POST">
                        @csrf
                        
                        <!-- Informasi Dasar UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Informasi Dasar UPA</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Kode UPA <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kode_upa') is-invalid @enderror" 
                                       name="kode_upa" value="{{ old('kode_upa') }}" 
                                       placeholder="Contoh: UPA001">
                                @error('kode_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nama UPA <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_upa') is-invalid @enderror" 
                                       name="nama_upa" value="{{ old('nama_upa') }}" 
                                       placeholder="Nama lengkap UPA">
                                @error('nama_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Deskripsi</label>
                                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                          name="deskripsi" rows="3" 
                                          placeholder="Deskripsi singkat tentang UPA">{{ old('deskripsi') }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <!-- Pembimbing UPA (Hanya 1) -->
                            <div class="col-12 mb-4">
                                <h6 class="text-primary mb-3">Pembimbing UPA</h6>
                                <p class="text-muted">Pilih 1 orang yang akan menjadi pembimbing UPA ini</p>
                                
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Nama Pembimbing <span class="text-danger">*</span></label>
                                        <select class="form-select @error('pembimbing_anggota_id') is-invalid @enderror" 
                                                name="pembimbing_anggota_id" required>
                                            <option value="">Pilih Anggota</option>
                                            @foreach($anggotaList as $anggota)
                                                <option value="{{ $anggota->id }}" {{ old('pembimbing_anggota_id') == $anggota->id ? 'selected' : '' }}>
                                                    {{ $anggota->nama_lengkap }} - {{ $anggota->nomor_identitas_anggota }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('pembimbing_anggota_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Tanggal Mulai</label>
                                        <input type="date" class="form-control @error('pembimbing_tanggal_mulai') is-invalid @enderror" 
                                               name="pembimbing_tanggal_mulai" value="{{ old('pembimbing_tanggal_mulai') }}">
                                        @error('pembimbing_tanggal_mulai')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Tanggal Selesai</label>
                                        <input type="date" class="form-control @error('pembimbing_tanggal_selesai') is-invalid @enderror" 
                                               name="pembimbing_tanggal_selesai" value="{{ old('pembimbing_tanggal_selesai') }}">
                                        @error('pembimbing_tanggal_selesai')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Catatan</label>
                                        <input type="text" class="form-control @error('pembimbing_catatan') is-invalid @enderror" 
                                               name="pembimbing_catatan" value="{{ old('pembimbing_catatan') }}" 
                                               placeholder="Catatan pembimbing">
                                        @error('pembimbing_catatan')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- DPC -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Organisasi</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">DPC <span class="text-danger">*</span></label>
                                <select class="form-select @error('dpc_id') is-invalid @enderror" 
                                        name="dpc_id" required>
                                    <option value="">Pilih DPC</option>
                                    @foreach($dpcList as $dpc)
                                        <option value="{{ $dpc->dpc_id }}" {{ old('dpc_id') == $dpc->dpc_id ? 'selected' : '' }}>
                                            {{ $dpc->nama_dpc }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('dpc_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>


                        <!-- Alamat UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Alamat UPA</h6>
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Alamat Lengkap</label>
                                <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                          name="alamat" rows="2" 
                                          placeholder="Alamat lengkap UPA">{{ old('alamat') }}</textarea>
                                @error('alamat')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Provinsi <span class="text-danger">*</span></label>
                                <select class="form-select @error('provinsi_id') is-invalid @enderror" 
                                        name="provinsi_id" id="provinsi_id" required>
                                    <option value="">Pilih Provinsi</option>
                                </select>
                                @error('provinsi_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kota/Kabupaten <span class="text-danger">*</span></label>
                                <select class="form-select @error('kota_id') is-invalid @enderror" 
                                        name="kota_id" id="kota_id" required disabled>
                                    <option value="">Pilih Kota/Kabupaten</option>
                                </select>
                                @error('kota_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kecamatan <span class="text-danger">*</span></label>
                                <select class="form-select @error('kecamatan_id') is-invalid @enderror" 
                                        name="kecamatan_id" id="kecamatan_id" required disabled>
                                    <option value="">Pilih Kecamatan</option>
                                </select>
                                @error('kecamatan_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Kelurahan/Desa</label>
                                <select class="form-select @error('kelurahan_id') is-invalid @enderror" 
                                        name="kelurahan_id" id="kelurahan_id" disabled>
                                    <option value="">Pilih Kelurahan/Desa</option>
                                </select>
                                @error('kelurahan_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Kode Pos</label>
                                <input type="text" class="form-control @error('kode_pos') is-invalid @enderror" 
                                       name="kode_pos" id="kode_pos" value="{{ old('kode_pos') }}" 
                                       placeholder="Kode Pos" readonly>
                                @error('kode_pos')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Kontak UPA -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Kontak UPA</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">No. Telepon</label>
                                <input type="text" class="form-control @error('no_telepon') is-invalid @enderror" 
                                       name="no_telepon" value="{{ old('no_telepon') }}" 
                                       placeholder="No. Telepon">
                                @error('no_telepon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                       name="email" value="{{ old('email') }}" 
                                       placeholder="Email UPA">
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Informasi Tambahan -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">Informasi Tambahan</h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tanggal Berdiri</label>
                                <input type="date" class="form-control @error('tanggal_berdiri') is-invalid @enderror" 
                                       name="tanggal_berdiri" value="{{ old('tanggal_berdiri') }}">
                                @error('tanggal_berdiri')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" name="status">
                                    <option value="">Pilih Status</option>
                                    <option value="Aktif" {{ old('status') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="Tidak Aktif" {{ old('status') == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                    <option value="Dibubarkan" {{ old('status') == 'Dibubarkan' ? 'selected' : '' }}>Dibubarkan</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          name="catatan" rows="3" 
                                          placeholder="Catatan tambahan">{{ old('catatan') }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>


                        <!-- Tombol Aksi -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Simpan UPA
                                    </button>
                                    <a href="{{ route('upa.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Batal
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>

// Dropdown berjenjang untuk alamat
document.addEventListener('DOMContentLoaded', function() {
    const provinsiSelect = document.getElementById('provinsi_id');
    const kotaSelect = document.getElementById('kota_id');
    const kecamatanSelect = document.getElementById('kecamatan_id');
    const kelurahanSelect = document.getElementById('kelurahan_id');

    // Load provinsi saat halaman dimuat
    loadProvinsi();

    // Event listener untuk provinsi
    provinsiSelect.addEventListener('change', function() {
        const provinsiId = this.value;
        if (provinsiId) {
            loadKota(provinsiId);
            resetDropdown(kotaSelect);
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
        } else {
            resetDropdown(kotaSelect);
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
        }
    });

    // Event listener untuk kota
    kotaSelect.addEventListener('change', function() {
        const kotaId = this.value;
        if (kotaId) {
            loadKecamatan(kotaId);
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
        } else {
            resetDropdown(kecamatanSelect);
            resetDropdown(kelurahanSelect);
        }
    });

    // Event listener untuk kecamatan
    kecamatanSelect.addEventListener('change', function() {
        const kecamatanId = this.value;
        console.log('Kecamatan changed to:', kecamatanId);
        if (kecamatanId) {
            loadKelurahan(kecamatanId);
            resetDropdown(kelurahanSelect);
            // Reset kode pos saat kecamatan berubah
            const kodePosInput = document.getElementById('kode_pos');
            if (kodePosInput) kodePosInput.value = '';
        } else {
            resetDropdown(kelurahanSelect);
            // Reset kode pos saat kecamatan direset
            const kodePosInput = document.getElementById('kode_pos');
            if (kodePosInput) kodePosInput.value = '';
        }
    });

    // Event listener untuk kelurahan
    kelurahanSelect.addEventListener('change', function() {
        const kelurahanId = this.value;
        console.log('Kelurahan changed to:', kelurahanId);
        if (kelurahanId) {
            loadKodePos(kelurahanId);
        } else {
            // Reset kode pos saat kelurahan direset
            const kodePosInput = document.getElementById('kode_pos');
            if (kodePosInput) kodePosInput.value = '';
        }
    });

    function loadProvinsi() {
        fetch('{{ route("api.provinsi") }}')
            .then(response => response.json())
            .then(data => {
                provinsiSelect.innerHTML = '<option value="">Pilih Provinsi</option>';
                data.forEach(provinsi => {
                    const option = document.createElement('option');
                    option.value = provinsi.id;
                    option.textContent = provinsi.nama_provinsi;
                    provinsiSelect.appendChild(option);
                });
                
                // Set default to DKI Jakarta
                const dkiJakarta = data.find(provinsi => provinsi.nama_provinsi === 'DKI Jakarta');
                if (dkiJakarta) {
                    provinsiSelect.value = dkiJakarta.id;
                    loadKota(dkiJakarta.id);
                }
            })
            .catch(error => console.error('Error loading provinsi:', error));
    }

    function loadKota(provinsiId) {
        fetch(`{{ route("api.kota") }}?provinsi_id=${provinsiId}`)
            .then(response => response.json())
            .then(data => {
                kotaSelect.innerHTML = '<option value="">Pilih Kota/Kabupaten</option>';
                data.forEach(kota => {
                    const option = document.createElement('option');
                    option.value = kota.id;
                    option.textContent = `${kota.nama_kota} (${kota.tipe})`;
                    kotaSelect.appendChild(option);
                });
                kotaSelect.disabled = false;
                
                // Set default to Jakarta Timur if DKI Jakarta is selected
                console.log('Setting default kota for provinsiId:', provinsiId);
                console.log('All kota data:', data);
                const jakartaTimur = data.find(kota => kota.nama_kota === 'Jakarta Timur');
                console.log('Found Jakarta Timur:', jakartaTimur);
                
                // Try alternative names if Jakarta Timur not found
                if (!jakartaTimur) {
                    const jakartaTimurAlt = data.find(kota => 
                        kota.nama_kota.includes('Jakarta Timur') || 
                        kota.nama_kota.includes('Jakarta Timur') ||
                        kota.nama_kota === 'Jakarta Timur'
                    );
                    console.log('Found Jakarta Timur (alt):', jakartaTimurAlt);
                    if (jakartaTimurAlt) {
                        setTimeout(() => {
                            kotaSelect.value = jakartaTimurAlt.id;
                            console.log('Set kota to Jakarta Timur (alt) with ID:', jakartaTimurAlt.id);
                            loadKecamatan(jakartaTimurAlt.id);
                        }, 100);
                    }
                } else {
                    // Use setTimeout to ensure DOM is updated
                    setTimeout(() => {
                        kotaSelect.value = jakartaTimur.id;
                        console.log('Set kota to Jakarta Timur with ID:', jakartaTimur.id);
                        loadKecamatan(jakartaTimur.id);
                    }, 100);
                }
            })
            .catch(error => console.error('Error loading kota:', error));
    }

    function loadKecamatan(kotaId) {
        fetch(`{{ route("api.kecamatan") }}?kota_id=${kotaId}`)
            .then(response => response.json())
            .then(data => {
                kecamatanSelect.innerHTML = '<option value="">Pilih Kecamatan</option>';
                data.forEach(kecamatan => {
                    const option = document.createElement('option');
                    option.value = kecamatan.id;
                    option.textContent = kecamatan.nama_kecamatan;
                    kecamatanSelect.appendChild(option);
                });
                kecamatanSelect.disabled = false;
            })
            .catch(error => console.error('Error loading kecamatan:', error));
    }

    function loadKelurahan(kecamatanId) {
        console.log('Loading kelurahan for kecamatan_id:', kecamatanId);
        fetch(`{{ route("api.kelurahan") }}?kecamatan_id=${kecamatanId}`)
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Kelurahan data received:', data);
                kelurahanSelect.innerHTML = '<option value="">Pilih Kelurahan/Desa</option>';
                data.forEach(kelurahan => {
                    const option = document.createElement('option');
                    option.value = kelurahan.id;
                    option.textContent = kelurahan.nama_kelurahan;
                    // Simpan kode pos sebagai data attribute
                    if (kelurahan.kode_pos) {
                        option.setAttribute('data-kode-pos', kelurahan.kode_pos);
                        console.log(`Set kode pos for ${kelurahan.nama_kelurahan}: ${kelurahan.kode_pos}`);
                    } else {
                        console.log(`No kode pos for ${kelurahan.nama_kelurahan}`);
                    }
                    kelurahanSelect.appendChild(option);
                });
                kelurahanSelect.disabled = false;
                console.log('Kelurahan dropdown populated with', data.length, 'items');
            })
            .catch(error => console.error('Error loading kelurahan:', error));
    }

    function loadKodePos(kelurahanId) {
        console.log('Loading kode pos for kelurahan_id:', kelurahanId);
        const selectedOption = kelurahanSelect.options[kelurahanSelect.selectedIndex];
        console.log('Selected option:', selectedOption);
        
        const kodePosInput = document.getElementById('kode_pos');
        if (!kodePosInput) {
            console.error('Kode pos input element not found!');
            return;
        }
        
        const kodePos = selectedOption.getAttribute('data-kode-pos');
        console.log('Kode pos from data attribute:', kodePos);
        
        if (kodePos) {
            kodePosInput.value = kodePos;
            console.log('Kode pos auto-filled:', kodePos);
        } else {
            console.log('No kode pos found for kelurahan_id:', kelurahanId);
            console.log('Available attributes:', selectedOption.getAttributeNames());
            kodePosInput.value = '';
        }
    }

    function resetDropdown(select) {
        select.innerHTML = '<option value="">Pilih ' + select.previousElementSibling.textContent.replace(' *', '') + '</option>';
        select.disabled = true;
    }
});
</script>
@endsection
