@extends('layouts.app')

@section('title', 'Pelaksanaan Grup UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Pelaksanaan Grup UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Pelaksanaan Grup UPA</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Daftar Aktivitas UPA</h5>
                        </div>
                        <div class="col-auto d-flex gap-2">
                            <a href="{{ route('upa-group-activity.export') }}@if(request()->query())?{{ http_build_query(request()->query()) }}@endif" class="btn btn-success">
                                <i class="fas fa-file-excel me-1"></i> Export Excel
                            </a>
                            <a href="{{ route('upa-group-activity.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Tambah Aktivitas UPA
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter dan Pencarian -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <form method="GET" class="d-flex">
                                <input type="text" class="form-control me-2" name="search" 
                                       value="{{ request('search') }}" placeholder="Cari aktivitas...">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-search"></i>
                                </button>
                            </form>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" onchange="filterByStatus(this.value)">
                                <option value="">Semua Status</option>
                                @foreach($statusList as $status)
                                    <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                        {{ $status }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <input type="date" class="form-control" name="tanggal_dari" 
                                   value="{{ request('tanggal_dari') }}" placeholder="Tanggal Dari">
                        </div>
                        <div class="col-md-2">
                            <input type="date" class="form-control" name="tanggal_sampai" 
                                   value="{{ request('tanggal_sampai') }}" placeholder="Tanggal Sampai">
                        </div>
                        <div class="col-md-3 text-end">
                            @if(request('search') || request('status') || request('tanggal_dari') || request('tanggal_sampai'))
                                <a href="{{ route('upa-group-activity.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i> Reset Filter
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Tabel Aktivitas UPA -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama UPA</th>
                                    <th>Nama Pembimbing</th>
                                    <th>Tanggal & Waktu</th>
                                    <th>Total Kehadiran</th>
                                    <th>Agenda</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activities as $index => $activity)
                                    <tr>
                                        <td>{{ $activities->firstItem() + $index }}</td>
                                        <td>
                                            @if($activity->upa)
                                                <span class="fw-bold text-primary">{{ $activity->upa->nama_upa }}</span>
                                                <br><small class="text-muted">{{ $activity->kode_upa }}</small>
                                            @else
                                                <span class="fw-bold text-primary">{{ $activity->kode_upa }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="fw-bold">{{ $activity->nama_pembimbing }}</div>
                                            @if($activity->kehadiran_pembimbing)
                                                <span class="text-dark">Hadir</span>
                                            @else
                                                <span class="text-dark">Tidak Hadir</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div>
                                                <div class="fw-bold">{{ \Carbon\Carbon::parse($activity->tanggal_upa)->format('d/m/Y') }}</div>
                                                <small class="text-muted">{{ \Carbon\Carbon::parse($activity->waktu_upa)->format('H:i') }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="text-dark">
                                                {{ $activity->total_kehadiran }}/{{ $activity->total_anggota }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($activity->agenda_notes && is_array($activity->agenda_notes) && count($activity->agenda_notes) > 0)
                                                <ul class="list-unstyled mb-0" style="max-width: 200px;">
                                                    @foreach($activity->agenda_notes as $agenda)
                                                        @if(!empty($agenda['nama_agenda']))
                                                            <li class="text-truncate" title="{{ $agenda['nama_agenda'] }}">
                                                                • {{ $agenda['nama_agenda'] }}
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            @elseif($activity->agenda_upa)
                                                <ul class="list-unstyled mb-0" style="max-width: 200px;">
                                                    <li class="text-truncate" title="{{ $activity->agenda_upa }}">
                                                        • {{ $activity->agenda_upa }}
                                                    </li>
                                                </ul>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="text-dark">
                                                {{ $activity->status_terlaksana }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('upa-group-activity.show', $activity) }}" class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('upa-group-activity.edit', $activity) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('upa-group-activity.destroy', $activity) }}" method="POST" class="d-inline" 
                                                      onsubmit="return confirm('Apakah Anda yakin ingin menghapus aktivitas ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                                <p>Tidak ada data aktivitas UPA ditemukan</p>
                                                @if(request('search') || request('status') || request('tanggal_dari') || request('tanggal_sampai'))
                                                    <a href="{{ route('upa-group-activity.index') }}" class="btn btn-outline-primary">
                                                        Lihat Semua Aktivitas
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($activities->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $activities->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByStatus(status) {
    const url = new URL(window.location);
    if (status) {
        url.searchParams.set('status', status);
    } else {
        url.searchParams.delete('status');
    }
    window.location = url;
}
</script>
@endsection

