@extends('layouts.app')

@section('title', 'Master Agenda UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Master Agenda UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Master Agenda UPA</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Daftar Agenda UPA</h5>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('upa-agenda-master.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Tambah Agenda
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter dan Pencarian -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <form method="GET" class="d-flex">
                                <input type="text" class="form-control me-2" name="search" 
                                       value="{{ request('search') }}" placeholder="Cari agenda...">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-search"></i>
                                </button>
                            </form>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" onchange="filterByStatus(this.value)">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="tidak_aktif" {{ request('status') == 'tidak_aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                            </select>
                        </div>
                        <div class="col-md-3 text-end">
                            @if(request('search') || request('status'))
                                <a href="{{ route('upa-agenda-master.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i> Reset Filter
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Tabel Agenda -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama Agenda</th>
                                    <th>Deskripsi</th>
                                    <th>Status</th>
                                    <th>Tanggal Dibuat</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($agendas as $index => $agenda)
                                    <tr>
                                        <td>{{ $agendas->firstItem() + $index }}</td>
                                        <td>
                                            <div class="fw-bold">{{ $agenda->nama_agenda }}</div>
                                        </td>
                                        <td>
                                            @if($agenda->deskripsi)
                                                <div class="text-muted">{{ Str::limit($agenda->deskripsi, 100) }}</div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $agenda->is_active ? 'success' : 'danger' }}">
                                                {{ $agenda->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                            </span>
                                        </td>
                                        <td>{{ $agenda->created_at->format('d/m/Y H:i') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('upa-agenda-master.show', $agenda) }}" class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('upa-agenda-master.edit', $agenda) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('upa-agenda-master.toggle-status', $agenda) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-outline-{{ $agenda->is_active ? 'warning' : 'success' }}" 
                                                            title="{{ $agenda->is_active ? 'Nonaktifkan' : 'Aktifkan' }}"
                                                            onsubmit="return confirm('Apakah Anda yakin ingin {{ $agenda->is_active ? 'menonaktifkan' : 'mengaktifkan' }} agenda ini?')">
                                                        <i class="fas fa-{{ $agenda->is_active ? 'pause' : 'play' }}"></i>
                                                    </button>
                                                </form>
                                                <form action="{{ route('upa-agenda-master.destroy', $agenda) }}" method="POST" class="d-inline" 
                                                      onsubmit="return confirm('Apakah Anda yakin ingin menghapus agenda ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                                <p>Tidak ada data agenda ditemukan</p>
                                                @if(request('search') || request('status'))
                                                    <a href="{{ route('upa-agenda-master.index') }}" class="btn btn-outline-primary">
                                                        Lihat Semua Agenda
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($agendas->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $agendas->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByStatus(status) {
    const url = new URL(window.location);
    if (status) {
        url.searchParams.set('status', status);
    } else {
        url.searchParams.delete('status');
    }
    window.location = url;
}
</script>
@endsection
