@extends('layouts.app')

@section('title', 'Edit Agenda UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Edit Agenda UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa-agenda-master.index') }}">Master Agenda UPA</a></li>
                        <li class="breadcrumb-item active">Edit Agenda</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Edit Agenda UPA</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('upa-agenda-master.update', $upaAgendaMaster) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- Nama Agenda -->
                            <div class="col-12 mb-3">
                                <label for="nama_agenda" class="form-label">Nama Agenda <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_agenda') is-invalid @enderror" 
                                       id="nama_agenda" name="nama_agenda" value="{{ old('nama_agenda', $upaAgendaMaster->nama_agenda) }}" 
                                       placeholder="Masukkan nama agenda" required>
                                @error('nama_agenda')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Deskripsi -->
                            <div class="col-12 mb-3">
                                <label for="deskripsi" class="form-label">Deskripsi</label>
                                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                          id="deskripsi" name="deskripsi" rows="4" 
                                          placeholder="Masukkan deskripsi agenda (opsional)">{{ old('deskripsi', $upaAgendaMaster->deskripsi) }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Status Aktif -->
                            <div class="col-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_active" 
                                           name="is_active" value="1" {{ old('is_active', $upaAgendaMaster->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        <strong>Agenda Aktif</strong>
                                        <small class="text-muted d-block">Centang jika agenda ini dapat digunakan dalam aktivitas UPA</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> Update
                                </button>
                                <a href="{{ route('upa-agenda-master.show', $upaAgendaMaster) }}" class="btn btn-secondary">
                                    <i class="fas fa-times me-1"></i> Batal
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
