@extends('layouts.app')

@section('title', 'Detail Takwim - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Detail Takwim</h1>
        <p class="text-muted">{{ $takwim->nama_takwim }}</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('takwim.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
        <a href="{{ route('takwim.edit', $takwim) }}" class="btn btn-warning">
            <i class="fas fa-edit me-1"></i> Edit
        </a>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<!-- Informasi Takwim -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-info-circle me-2"></i>Informasi Takwim
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <table class="table table-borderless">
                    <tr>
                        <td width="30%"><strong>Nama Takwim:</strong></td>
                        <td>{{ $takwim->nama_takwim }}</td>
                    </tr>
                    <tr>
                        <td><strong>Penyelenggara:</strong></td>
                        <td>{{ $takwim->strukturPenyelenggara->nama_struktur ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td><strong>Koordinator:</strong></td>
                        <td>{{ $takwim->koordinator }}</td>
                    </tr>
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="text-dark">{{ $takwim->status_takwim }}</span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-borderless">
                    <tr>
                        <td width="30%"><strong>Tanggal Mulai:</strong></td>
                        <td>{{ $takwim->tanggal_mulai ? $takwim->tanggal_mulai->format('d F Y') : '-' }}</td>
                    </tr>
                    <tr>
                        <td><strong>Tanggal Selesai:</strong></td>
                        <td>{{ $takwim->tanggal_selesai ? $takwim->tanggal_selesai->format('d F Y') : '-' }}</td>
                    </tr>
                    <tr>
                        <td><strong>Durasi:</strong></td>
                        <td>
                            @if($takwim->tanggal_mulai && $takwim->tanggal_selesai)
                                {{ $takwim->tanggal_mulai->diffInDays($takwim->tanggal_selesai) + 1 }} hari
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Jumlah Peserta:</strong></td>
                        <td>
                            <span class="text-dark">
                                {{ $takwim->pesertaTakwim->where('tanggal_keluar', null)->count() }} peserta aktif
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        @if($takwim->deskripsi)
        <div class="row mt-3">
            <div class="col-12">
                <strong>Deskripsi:</strong>
                <p class="mt-2">{{ $takwim->deskripsi }}</p>
            </div>
        </div>
        @endif

        @if($takwim->evaluasi)
        <div class="row mt-3">
            <div class="col-12">
                <strong>Evaluasi:</strong>
                <p class="mt-2">{{ $takwim->evaluasi }}</p>
            </div>
        </div>
        @endif

        @if($takwim->catatan_berkelanjutan)
        <div class="row mt-3">
            <div class="col-12">
                <strong>Catatan Berkelanjutan:</strong>
                <p class="mt-2">{{ $takwim->catatan_berkelanjutan }}</p>
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Daftar Peserta -->
<div class="card shadow">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-users me-2"></i>Daftar Peserta Takwim
        </h6>
        <button type="button" class="btn btn-primary btn-sm" onclick="openAddPesertaModal()">
            <i class="fas fa-plus me-1"></i> Tambah Peserta
        </button>
    </div>
    <div class="card-body">
        @if($takwim->pesertaTakwim->where('tanggal_keluar', null)->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Nama Anggota</th>
                        <th width="12%">NIA</th>
                        <th width="12%">Jabatan</th>
                        <th width="12%">Tanggal Bergabung</th>
                        <th width="12%">Status</th>
                        <th width="17%">Catatan</th>
                        <th width="10%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($takwim->pesertaTakwim->where('tanggal_keluar', null) as $index => $peserta)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <strong>
                                <a href="{{ route('anggota.show', $peserta->anggota) }}" class="text-decoration-none text-primary">
                                    {{ $peserta->anggota->nama_lengkap }}
                                </a>
                            </strong>
                            <br><small class="text-muted">{{ $peserta->anggota->no_anggota }}</small>
                        </td>
                        <td>
                            <span class="text-dark">{{ $peserta->anggota->nia ?? '-' }}</span>
                        </td>
                        <td>{{ $peserta->anggota->jabatan ?? '-' }}</td>
                        <td>{{ $peserta->tanggal_bergabung->format('d/m/Y') }}</td>
                        <td>
                            <span class="text-dark">Aktif</span>
                        </td>
                        <td>{{ $peserta->catatan ?? '-' }}</td>
                        <td>
                            <form action="{{ route('takwim.remove-peserta', [$takwim, $peserta->anggota]) }}" 
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('Apakah Anda yakin ingin mengeluarkan peserta ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" title="Keluarkan">
                                    <i class="fas fa-user-times"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="text-center py-4">
            <i class="fas fa-users fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">Belum Ada Peserta</h5>
            <p class="text-muted">Tambahkan peserta untuk takwim ini</p>
        </div>
        @endif
    </div>
</div>

<!-- Custom Modal Tambah Peserta -->
<div id="addPesertaModal" class="custom-modal" style="display: none;">
    <div class="custom-modal-backdrop" onclick="closeAddPesertaModal()"></div>
    <div class="custom-modal-dialog">
        <div class="custom-modal-content">
            <div class="custom-modal-header">
                <h5 class="custom-modal-title">Tambah Peserta Takwim</h5>
                <button type="button" class="btn-close" onclick="closeAddPesertaModal()">&times;</button>
            </div>
            <form action="{{ route('takwim.add-peserta', $takwim) }}" method="POST">
                @csrf
                <div class="custom-modal-body">
                    <div class="mb-3">
                        <label for="anggota_id" class="form-label">Anggota <span class="text-danger">*</span></label>
                        <select class="form-select @error('anggota_id') is-invalid @enderror" 
                                id="anggota_id" name="anggota_id" required>
                            <option value="">Pilih Anggota</option>
                            @foreach($anggotaTersedia as $anggota)
                                <option value="{{ $anggota->id }}" {{ old('anggota_id') == $anggota->id ? 'selected' : '' }}>
                                    {{ $anggota->nama_lengkap }} - {{ $anggota->nia ?? 'N/A' }}{{ $anggota->no_anggota ? ' (' . $anggota->no_anggota . ')' : '' }}
                                </option>
                            @endforeach
                        </select>
                        @error('anggota_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="tanggal_bergabung" class="form-label">Tanggal Bergabung <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('tanggal_bergabung') is-invalid @enderror" 
                               id="tanggal_bergabung" name="tanggal_bergabung" 
                               value="{{ old('tanggal_bergabung', now()->format('Y-m-d')) }}" required>
                        @error('tanggal_bergabung')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="catatan" class="form-label">Catatan</label>
                        <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                  id="catatan" name="catatan" rows="3" 
                                  placeholder="Masukkan catatan (opsional)">{{ old('catatan') }}</textarea>
                        @error('catatan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="custom-modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeAddPesertaModal()">Batal</button>
                    <button type="submit" class="btn btn-primary">Tambah Peserta</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<style>
/* Custom Modal Styles */
.custom-modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
}

.custom-modal-backdrop {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 1;
}

.custom-modal-dialog {
    position: relative;
    z-index: 2;
    max-width: 500px;
    width: 90%;
    margin: 0 auto;
}

.custom-modal-content {
    background: white;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    overflow: hidden;
}

.custom-modal-header {
    background: linear-gradient(135deg, #F0833A 0%, #E67E22 100%);
    color: white;
    padding: 1rem 1.5rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.custom-modal-title {
    margin: 0;
    font-size: 1.1rem;
    font-weight: 600;
}

.custom-modal-header .btn-close {
    background: none;
    border: none;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.custom-modal-header .btn-close:hover {
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
}

.custom-modal-body {
    padding: 1.5rem;
}

.custom-modal-footer {
    padding: 1rem 1.5rem;
    background: #f8f9fa;
    border-top: 1px solid #dee2e6;
    display: flex;
    justify-content: flex-end;
    gap: 0.5rem;
}

/* Ensure form elements are clickable */
.custom-modal-content * {
    pointer-events: auto !important;
    position: relative;
    z-index: 1;
}

.custom-modal-content .form-select {
    z-index: 2 !important;
}

.custom-modal-content .form-select:focus {
    z-index: 3 !important;
}
</style>

<script>
// Custom Modal Functions
function openAddPesertaModal() {
    const modal = document.getElementById('addPesertaModal');
    modal.style.display = 'flex';
    document.body.style.overflow = 'hidden';
    
    // Focus on first input
    setTimeout(() => {
        const firstInput = modal.querySelector('input, select, textarea');
        if (firstInput) {
            firstInput.focus();
        }
    }, 100);
}

function closeAddPesertaModal() {
    const modal = document.getElementById('addPesertaModal');
    modal.style.display = 'none';
    document.body.style.overflow = '';
}

// Close modal when clicking outside
document.addEventListener('click', function(e) {
    const modal = document.getElementById('addPesertaModal');
    if (e.target === modal) {
        closeAddPesertaModal();
    }
});

// Close modal with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeAddPesertaModal();
    }
});

// Prevent modal content clicks from closing modal
document.addEventListener('click', function(e) {
    if (e.target.closest('.custom-modal-content')) {
        e.stopPropagation();
    }
});
</script>

