@extends('layouts.app')

@section('title', 'Program Takwim - Sistem Informasi PKS')

@section('content')
<style>
/* Custom pagination styling untuk ukuran lebih kecil */
.pagination {
    font-size: 0.875rem;
    margin-bottom: 0;
}

.pagination .page-link {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 0.375rem;
    margin: 0 0.125rem;
    border: 1px solid #dee2e6;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.15s ease-in-out;
}

.pagination .page-link:hover {
    color: #0056b3;
    background-color: #e9ecef;
    border-color: #dee2e6;
}

.pagination .page-item.active .page-link {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.pagination .page-item.disabled .page-link {
    color: #6c757d;
    background-color: #fff;
    border-color: #dee2e6;
}

.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: 0.375rem;
}

/* Mobile responsive table */
@media (max-width: 768px) {
    .table-responsive {
        border: none;
    }
    
    .table {
        font-size: 0.75rem;
    }
    
    .table th,
    .table td {
        padding: 0.375rem 0.25rem;
        white-space: nowrap;
    }
    
    .table th:first-child,
    .table td:first-child {
        position: sticky;
        left: 0;
        background: white;
        z-index: 10;
    }
    
    .table th:last-child,
    .table td:last-child {
        position: sticky;
        right: 0;
        background: white;
        z-index: 10;
    }
    
    /* Mobile form adjustments */
    .form-control,
    .form-select {
        font-size: 16px; /* Prevents zoom on iOS */
    }
    
    .btn {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }
    
    .badge {
        font-size: 0.7rem;
        padding: 0.2rem 0.4rem;
    }
    
    /* Mobile card adjustments */
    .card-header {
        padding: 0.75rem;
    }
    
    .card-body {
        padding: 0.75rem;
    }
}

/* Scroll indicator for mobile */
.table-responsive::after {
    content: '← Scroll untuk melihat lebih banyak →';
    display: block;
    text-align: center;
    font-size: 0.75rem;
    color: #6c757d;
    padding: 0.5rem;
    background: #f8f9fa;
    border-top: 1px solid #dee2e6;
}

@media (min-width: 769px) {
    .table-responsive::after {
        display: none;
    }
}
</style>

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-calendar-alt text-primary me-2"></i>Program Takwim
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola program takwim Partai Keadilan Sejahtera
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('takwim.create') }}" class="btn btn-primary px-3" style="border-radius: 6px;">
            <i class="fas fa-plus me-1"></i>Tambah Takwim
        </a>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('takwim.index') }}" id="filterForm">
            <!-- Row 1: Pencarian, Penyelenggara, Koordinator, Status -->
            <div class="row g-2 mb-3">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-search me-1 text-primary"></i>Pencarian
                    </label>
                    <input type="text" class="form-control" name="search" 
                           value="{{ request('search') }}" 
                           placeholder="Cari nama takwim..."
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-building me-1 text-primary"></i>Penyelenggara
                    </label>
                    <select class="form-select" name="penyelenggara" style="border-radius: 6px;">
                        <option value="">Semua Penyelenggara</option>
                        @php
                            $penyelenggaraList = $takwim->pluck('penyelenggara')->unique()->sort()->values();
                        @endphp
                        @foreach($penyelenggaraList as $penyelenggara)
                            <option value="{{ $penyelenggara }}" {{ request('penyelenggara') == $penyelenggara ? 'selected' : '' }}>
                                {{ $penyelenggara }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-user-tie me-1 text-primary"></i>Koordinator
                    </label>
                    <select class="form-select" name="koordinator" style="border-radius: 6px;">
                        <option value="">Semua Koordinator</option>
                        @php
                            $koordinatorList = $takwim->pluck('koordinator')->unique()->sort()->values();
                        @endphp
                        @foreach($koordinatorList as $koordinator)
                            <option value="{{ $koordinator }}" {{ request('koordinator') == $koordinator ? 'selected' : '' }}>
                                {{ $koordinator }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-flag me-1 text-primary"></i>Status
                    </label>
                    <select class="form-select" name="status" style="border-radius: 6px;">
                        <option value="">Semua Status</option>
                        <option value="Aktif" {{ request('status') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                        <option value="Tidak Aktif" {{ request('status') == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                    </select>
                </div>
            </div>
            
            <!-- Row 2: Tanggal Mulai, Tanggal Selesai, dan Action Buttons -->
            <div class="row g-2 align-items-end">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar me-1 text-primary"></i>Tanggal Mulai
                    </label>
                    <input type="date" class="form-control" name="tanggal_dari" 
                           value="{{ request('tanggal_dari') }}" 
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar-check me-1 text-primary"></i>Tanggal Selesai
                    </label>
                    <input type="date" class="form-control" name="tanggal_sampai" 
                           value="{{ request('tanggal_sampai') }}" 
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary px-4" style="border-radius: 6px;">
                            <i class="fas fa-search me-1"></i>Cari Data
                        </button>
                        <a href="{{ route('takwim.index') }}" class="btn btn-outline-secondary px-4" style="border-radius: 6px;">
                            <i class="fas fa-undo me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow-sm border-0">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th width="5%" class="text-center">No</th>
                        <th width="20%">Nama Takwim</th>
                        <th width="15%">Penyelenggara</th>
                        <th width="15%">Koordinator</th>
                        <th width="12%">Tanggal Mulai</th>
                        <th width="12%">Tanggal Selesai</th>
                        <th width="8%" class="text-center">Status</th>
                        <th width="8%" class="text-center">Peserta</th>
                        <th width="10%" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($takwim as $index => $item)
                    <tr>
                        <td class="text-center">{{ $takwim->firstItem() + $index }}</td>
                        <td>
                            <strong>
                                <a href="{{ route('takwim.show', $item) }}" class="text-decoration-none text-primary">
                                    {{ $item->nama_takwim }}
                                </a>
                            </strong>
                            @if($item->deskripsi)
                                <br><small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                            @endif
                        </td>
                        <td>{{ $item->penyelenggara ?? '-' }}</td>
                        <td>{{ $item->koordinator }}</td>
                        <td class="text-center">
                            {{ $item->tanggal_mulai ? $item->tanggal_mulai->format('d/m/Y') : '-' }}
                        </td>
                        <td class="text-center">
                            {{ $item->tanggal_selesai ? $item->tanggal_selesai->format('d/m/Y') : '-' }}
                        </td>
                        <td class="text-center">
                            <span class="text-dark">{{ $item->status_takwim }}</span>
                        </td>
                        <td class="text-center">
                            <span class="text-dark">{{ $item->pesertaTakwim->where('tanggal_keluar', null)->count() }}</span>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group" aria-label="Actions">
                                {{-- Detail Button --}}
                                <a href="{{ route('takwim.show', $item) }}" 
                                   class="btn btn-sm btn-outline-primary" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                {{-- Edit Button --}}
                                <a href="{{ route('takwim.edit', $item) }}" 
                                   class="btn btn-sm btn-outline-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                {{-- Delete Button --}}
                                <form action="{{ route('takwim.destroy', $item) }}" 
                                      method="POST" style="display: inline;" 
                                      onsubmit="return confirm('Yakin hapus takwim ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            <i class="fas fa-calendar-times fa-3x mb-3 d-block"></i>
                            <strong>Tidak ada data takwim</strong><br>
                            <small>Klik tombol "Tambah Takwim" untuk menambah takwim baru</small>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        {{-- Pagination --}}
        @if($takwim->hasPages())
            <div class="d-flex justify-content-center p-3">
                {{ $takwim->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>
@endsection