@extends('layouts.app')

@section('title', 'Statistik Yaumiyah - Sistem Informasi PKS')

@section('content')
@if(session('warning'))
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    {{ session('warning') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i>
    {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Yaumiyah</h1>
        <p class="text-muted">Analisis data aktivitas yaumiyah anggota PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.yaumiyah') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="year" class="form-label">Tahun</label>
                        <select class="form-select" id="year" name="year">
                            @for($i = now()->year; $i >= 2020; $i--)
                                <option value="{{ $i }}" {{ request('year', now()->year) == $i ? 'selected' : '' }}>
                                    {{ $i }}
                                </option>
                            @endfor
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="week_number" class="form-label">Pekan</label>
                        <select class="form-select" id="week_number" name="week_number">
                            <option value="">Semua Pekan</option>
                            @for($i = 1; $i <= 53; $i++)
                                <option value="{{ $i }}" {{ request('week_number') == $i ? 'selected' : '' }}>
                                    Pekan {{ $i }}
                                </option>
                            @endfor
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="yaumiyah_activity_id" class="form-label">Aktivitas</label>
                        <select class="form-select" id="yaumiyah_activity_id" name="yaumiyah_activity_id">
                            <option value="">Semua Aktivitas</option>
                            @foreach($activities as $activity)
                                <option value="{{ $activity->id }}" {{ request('yaumiyah_activity_id') == $activity->id ? 'selected' : '' }}>
                                    {{ $activity->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="anggota_id" class="form-label">Anggota</label>
                        <select class="form-select" id="anggota_id" name="anggota_id">
                            <option value="">Semua Anggota</option>
                            @foreach($anggota as $member)
                                <option value="{{ $member->id }}" {{ request('anggota_id') == $member->id ? 'selected' : '' }}>
                                    {{ $member->nama_lengkap }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-1"></i> Filter
                    </button>
                    <a href="{{ route('statistik.yaumiyah') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i> Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Records
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_records']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-info">{{ $statistik['records_this_year'] }} tahun ini</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-list fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Aktivitas
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_activities']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-success">Aktivitas aktif</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-tasks fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Anggota Aktif
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_anggota_with_records']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-warning">Dengan records</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Total Nilai
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_value_all_activities']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-info">Rata-rata: {{ number_format($statistik['average_value_per_activity'], 1) }}</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <!-- Yaumiyah per Activity Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Aktivitas</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="yaumiyahPerActivityChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Yaumiyah per Week Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Pekan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="yaumiyahPerWeekChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <!-- Yaumiyah per Month Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="yaumiyahPerMonthChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Anggota Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Top 10 Anggota</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="yaumiyahPerAnggotaChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Records Yaumiyah
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Anggota</th>
                        <th>Aktivitas</th>
                        <th>Pekan</th>
                        <th>Tahun</th>
                        <th>Nilai</th>
                        <th>Unit</th>
                        <th>Catatan</th>
                        <th>Tanggal Input</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($records as $index => $record)
                    <tr>
                        <td>{{ $records->firstItem() + $index }}</td>
                        <td>{{ $record->anggota->nama_lengkap ?? 'N/A' }}</td>
                        <td>{{ $record->activity->name ?? 'N/A' }}</td>
                        <td>{{ $record->week_number }}</td>
                        <td>{{ $record->year }}</td>
                        <td>{{ number_format($record->value) }}</td>
                        <td>{{ $record->activity->unit ?? 'kali' }}</td>
                        <td>{{ $record->notes ?? '-' }}</td>
                        <td>{{ $record->created_at->format('d/m/Y H:i') }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">Tidak ada data yang ditemukan</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($records->hasPages())
        <div class="d-flex justify-content-center">
            {{ $records->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Yaumiyah per Activity Chart
const yaumiyahPerActivityCtx = document.getElementById('yaumiyahPerActivityChart').getContext('2d');
const yaumiyahPerActivityChart = new Chart(yaumiyahPerActivityCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_activity']->map(function($item) {
            return $item->activity->name ?? 'N/A';
        })) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_activity']->pluck('total_value')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Yaumiyah per Week Chart
const yaumiyahPerWeekCtx = document.getElementById('yaumiyahPerWeekChart').getContext('2d');
const yaumiyahPerWeekChart = new Chart(yaumiyahPerWeekCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_week']->map(function($item) {
            return 'Pekan ' . $item->week_number;
        })) !!},
        datasets: [{
            label: 'Total Nilai',
            data: {!! json_encode($chartData['per_week']->pluck('total_value')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Yaumiyah per Month Chart
const yaumiyahPerMonthCtx = document.getElementById('yaumiyahPerMonthChart').getContext('2d');
const yaumiyahPerMonthChart = new Chart(yaumiyahPerMonthCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['per_month']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Total Nilai',
            data: {!! json_encode($chartData['per_month']->pluck('total_value')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Yaumiyah per Anggota Chart
const yaumiyahPerAnggotaCtx = document.getElementById('yaumiyahPerAnggotaChart').getContext('2d');
const yaumiyahPerAnggotaChart = new Chart(yaumiyahPerAnggotaCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_anggota']->map(function($item) {
            return $item->anggota->nama_lengkap ?? 'N/A';
        })) !!},
        datasets: [{
            label: 'Total Nilai',
            data: {!! json_encode($chartData['per_anggota']->pluck('total_value')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush
