@extends('layouts.app')

@section('title', 'Statistik Aktivitas UPA - Sistem Informasi PKS')

@section('content')
@if(session('warning'))
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    {{ session('warning') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i>
    {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Aktivitas UPA</h1>
        <p class="text-muted">Analisis data aktivitas grup UPA PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.upa-activity') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ request('tanggal_mulai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ request('tanggal_selesai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="status_terlaksana" class="form-label">Status</label>
                        <select class="form-select" id="status_terlaksana" name="status_terlaksana">
                            <option value="">Semua Status</option>
                            <option value="Terlaksana" {{ request('status_terlaksana') == 'Terlaksana' ? 'selected' : '' }}>
                                Terlaksana
                            </option>
                            <option value="Tidak Terlaksana" {{ request('status_terlaksana') == 'Tidak Terlaksana' ? 'selected' : '' }}>
                                Tidak Terlaksana
                            </option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="kode_upa" class="form-label">UPA</label>
                        <select class="form-select" id="kode_upa" name="kode_upa">
                            <option value="">Semua UPA</option>
                            @foreach($upaList as $upa)
                                <option value="{{ $upa->kode_upa }}" {{ request('kode_upa') == $upa->kode_upa ? 'selected' : '' }}>
                                    {{ $upa->nama_upa }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="nama_pembimbing" class="form-label">Nama Pembimbing</label>
                        <input type="text" class="form-control" id="nama_pembimbing" name="nama_pembimbing" 
                               value="{{ request('nama_pembimbing') }}" placeholder="Cari nama pembimbing...">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-1"></i> Filter
                    </button>
                    <a href="{{ route('statistik.upa-activity') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i> Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Aktivitas
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_activities']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-success">{{ $statistik['terlaksana'] }} terlaksana</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar-check fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Terlaksana
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['terlaksana']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-info">{{ $statistik['total_activities'] > 0 ? round(($statistik['terlaksana'] / $statistik['total_activities']) * 100, 1) : 0 }}% dari total</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Total UPA
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_upa']) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-warning">UPA aktif</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Rata-rata Kehadiran
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['rata_rata_kehadiran'], 1) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-info">{{ $statistik['total_pembimbing_hadir'] }} pembimbing hadir</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <!-- UPA Activity per Status Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Status</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="upaActivityPerStatusChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- UPA Activity per Month Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="upaActivityPerMonthChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <!-- UPA Activity per UPA Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Top 10 UPA</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="upaActivityPerUpaChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- UPA Activity per Pembimbing Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Top 10 Pembimbing</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="upaActivityPerPembimbingChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Aktivitas UPA
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>UPA</th>
                        <th>Pembimbing</th>
                        <th>Tanggal UPA</th>
                        <th>Waktu</th>
                        <th>Status</th>
                        <th>Kehadiran Pembimbing</th>
                        <th>Total Kehadiran</th>
                        <th>Agenda</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($activities as $index => $activity)
                    <tr>
                        <td>{{ $activities->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $activity->kode_upa }}</strong><br>
                            <small class="text-muted">{{ $activity->upa->nama_upa ?? 'N/A' }}</small>
                        </td>
                        <td>{{ $activity->nama_pembimbing }}</td>
                        <td>{{ $activity->tanggal_upa->format('d/m/Y') }}</td>
                        <td>{{ $activity->waktu_upa }}</td>
                        <td>
                            @if($activity->status_terlaksana == 'Terlaksana')
                                <span class="badge bg-success">Terlaksana</span>
                            @else
                                <span class="badge bg-warning">Tidak Terlaksana</span>
                            @endif
                        </td>
                        <td>
                            @if($activity->kehadiran_pembimbing)
                                <span class="badge bg-success">Hadir</span>
                            @else
                                <span class="badge bg-danger">Tidak Hadir</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-info">{{ $activity->total_kehadiran }}</span>
                        </td>
                        <td>
                            <div style="max-width: 200px; overflow: hidden; text-overflow: ellipsis;">
                                {{ Str::limit($activity->agenda_upa, 50) }}
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">Tidak ada data yang ditemukan</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($activities->hasPages())
        <div class="d-flex justify-content-center">
            {{ $activities->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// UPA Activity per Status Chart
const upaActivityPerStatusCtx = document.getElementById('upaActivityPerStatusChart').getContext('2d');
const upaActivityPerStatusChart = new Chart(upaActivityPerStatusCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_status']->pluck('status_terlaksana')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_status']->pluck('total')) !!},
            backgroundColor: [
                'rgba(40, 167, 69, 1)',
                'rgba(255, 193, 7, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// UPA Activity per Month Chart
const upaActivityPerMonthCtx = document.getElementById('upaActivityPerMonthChart').getContext('2d');
const upaActivityPerMonthChart = new Chart(upaActivityPerMonthCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Aktivitas UPA',
            data: {!! json_encode($chartData['per_bulan']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// UPA Activity per UPA Chart
const upaActivityPerUpaCtx = document.getElementById('upaActivityPerUpaChart').getContext('2d');
const upaActivityPerUpaChart = new Chart(upaActivityPerUpaCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_upa']->map(function($item) {
            return $item->upa->nama_upa ?? $item->kode_upa;
        })) !!},
        datasets: [{
            label: 'Total Aktivitas',
            data: {!! json_encode($chartData['per_upa']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// UPA Activity per Pembimbing Chart
const upaActivityPerPembimbingCtx = document.getElementById('upaActivityPerPembimbingChart').getContext('2d');
const upaActivityPerPembimbingChart = new Chart(upaActivityPerPembimbingCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_pembimbing']->pluck('nama_pembimbing')) !!},
        datasets: [{
            label: 'Total Aktivitas',
            data: {!! json_encode($chartData['per_pembimbing']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush


