@extends('layouts.app')

@section('title', 'Edit Perpindahan Anggota')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-edit"></i> Edit Perpindahan Anggota
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('perpindahan.show', $perpindahan->id) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>

                <form method="POST" action="{{ route('perpindahan.update', $perpindahan->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <!-- Informasi Anggota (Read Only) -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary">Informasi Anggota</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <tr>
                                            <th width="200">Nama Lengkap</th>
                                            <td>{{ $perpindahan->anggota->nama_lengkap }}</td>
                                        </tr>
                                        <tr>
                                            <th>Nomor Identitas Anggota</th>
                                            <td>{{ $perpindahan->anggota->nomor_identitas_anggota }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Data Sebelum Perpindahan (Read Only) -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-info">Data Sebelum Perpindahan</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <thead class="bg-light">
                                            <tr>
                                                <th>DPD</th>
                                                <th>DPC</th>
                                                <th>UPA</th>
                                                <th>Jenjang</th>
                                                <th>Grup UPA</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>{{ $perpindahan->dpdBefore->nama_dpd ?? '-' }}</td>
                                                <td>{{ $perpindahan->dpcBefore->nama_dpc ?? '-' }}</td>
                                                <td>{{ $perpindahan->upaBefore->nama_upa ?? '-' }}</td>
                                                <td>{{ $perpindahan->jenjangBefore->jenjang ?? '-' }}</td>
                                                <td>{{ $perpindahan->grupUpaBefore->nama_grup_upa ?? '-' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Form Edit -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-success">Edit Data Baru</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tanggal_perpindahan">Tanggal Perpindahan <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="tanggal_perpindahan" name="tanggal_perpindahan" 
                                           value="{{ old('tanggal_perpindahan', $perpindahan->tanggal_perpindahan->format('Y-m-d')) }}" required>
                                    @error('tanggal_perpindahan')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dpd_id_after">DPD Baru</label>
                                    <select class="form-control" id="dpd_id_after" name="dpd_id_after">
                                        <option value="">-- Pilih DPD --</option>
                                        @foreach($dpdList as $dpd)
                                            <option value="{{ $dpd->dpd_id }}" 
                                                    {{ old('dpd_id_after', $perpindahan->dpd_id_after) == $dpd->dpd_id ? 'selected' : '' }}>
                                                {{ $dpd->nama_dpd }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpd_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dpc_id_after">DPC Baru</label>
                                    <select class="form-control" id="dpc_id_after" name="dpc_id_after">
                                        <option value="">-- Pilih DPC --</option>
                                        @foreach($dpcList as $dpc)
                                            <option value="{{ $dpc->dpc_id }}" 
                                                    {{ old('dpc_id_after', $perpindahan->dpc_id_after) == $dpc->dpc_id ? 'selected' : '' }}>
                                                {{ $dpc->nama_dpc }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpc_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="upa_id_after">UPA Baru</label>
                                    <select class="form-control" id="upa_id_after" name="upa_id_after">
                                        <option value="">-- Pilih UPA --</option>
                                        @foreach($upaList as $upa)
                                            <option value="{{ $upa->upa_id }}" 
                                                    {{ old('upa_id_after', $perpindahan->upa_id_after) == $upa->upa_id ? 'selected' : '' }}>
                                                {{ $upa->nama_upa }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('upa_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ref_jenjang_id_after">Jenjang Baru</label>
                                    <select class="form-control" id="ref_jenjang_id_after" name="ref_jenjang_id_after">
                                        <option value="">-- Pilih Jenjang --</option>
                                        @foreach($jenjangList as $jenjang)
                                            <option value="{{ $jenjang->ref_jenjang_id }}" 
                                                    {{ old('ref_jenjang_id_after', $perpindahan->ref_jenjang_id_after) == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                                {{ $jenjang->jenjang }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('ref_jenjang_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ref_grup_upa_id_after">Grup UPA Baru</label>
                                    <select class="form-control" id="ref_grup_upa_id_after" name="ref_grup_upa_id_after">
                                        <option value="">-- Pilih Grup UPA --</option>
                                        @foreach($grupUpaList as $grupUpa)
                                            <option value="{{ $grupUpa->ref_grup_upa_id }}" 
                                                    {{ old('ref_grup_upa_id_after', $perpindahan->ref_grup_upa_id_after) == $grupUpa->ref_grup_upa_id ? 'selected' : '' }}>
                                                {{ $grupUpa->nama_grup_upa }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('ref_grup_upa_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="keterangan">Keterangan</label>
                                    <textarea class="form-control" id="keterangan" name="keterangan" rows="3" 
                                              placeholder="Alasan perpindahan...">{{ old('keterangan', $perpindahan->keterangan) }}</textarea>
                                    @error('keterangan')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Preview Perubahan -->
                        <div id="preview-changes" class="row" style="display: none;">
                            <div class="col-12">
                                <h5 class="text-warning">Preview Perubahan</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <thead class="bg-light">
                                            <tr>
                                                <th>Field</th>
                                                <th>Sebelum</th>
                                                <th>Sesudah</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="preview-changes-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" id="submit-btn">
                            <i class="fas fa-save"></i> Update Perpindahan
                        </button>
                        <a href="{{ route('perpindahan.show', $perpindahan->id) }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Batal
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Data untuk dropdown
    const dpdData = @json($dpdList->keyBy('dpd_id'));
    const dpcData = @json($dpcList->keyBy('dpc_id'));
    const upaData = @json($upaList->keyBy('upa_id'));
    const jenjangData = @json($jenjangList->keyBy('ref_jenjang_id'));
    const grupUpaData = @json($grupUpaList->keyBy('ref_grup_upa_id'));

    // Data sebelum perpindahan
    const beforeData = {
        dpd: {{ $perpindahan->dpd_id_before ?? 'null' }},
        dpc: {{ $perpindahan->dpc_id_before ?? 'null' }},
        upa: {{ $perpindahan->upa_id_before ?? 'null' }},
        jenjang: {{ $perpindahan->ref_jenjang_id_before ?? 'null' }},
        grupUpa: {{ $perpindahan->ref_grup_upa_id_before ?? 'null' }}
    };

    // Handle form field changes
    $('#dpd_id_after, #dpc_id_after, #upa_id_after, #ref_jenjang_id_after, #ref_grup_upa_id_after').on('change', function() {
        checkChanges();
    });

    function checkChanges() {
        const newData = {
            dpd: $('#dpd_id_after').val(),
            dpc: $('#dpc_id_after').val(),
            upa: $('#upa_id_after').val(),
            jenjang: $('#ref_jenjang_id_after').val(),
            grupUpa: $('#ref_grup_upa_id_after').val()
        };

        // Check for changes
        const changes = [];
        const fields = [
            { key: 'dpd', label: 'DPD', data: dpdData },
            { key: 'dpc', label: 'DPC', data: dpcData },
            { key: 'upa', label: 'UPA', data: upaData },
            { key: 'jenjang', label: 'Jenjang', data: jenjangData },
            { key: 'grupUpa', label: 'Grup UPA', data: grupUpaData }
        ];

        fields.forEach(field => {
            if (beforeData[field.key] != newData[field.key]) {
                changes.push({
                    field: field.label,
                    before: beforeData[field.key] ? field.data[beforeData[field.key]]?.nama_dpd || 
                            field.data[beforeData[field.key]]?.nama_dpc || 
                            field.data[beforeData[field.key]]?.nama_upa || 
                            field.data[beforeData[field.key]]?.jenjang || 
                            field.data[beforeData[field.key]]?.nama_grup_upa || '-' : '-',
                    after: newData[field.key] ? field.data[newData[field.key]]?.nama_dpd || 
                           field.data[newData[field.key]]?.nama_dpc || 
                           field.data[newData[field.key]]?.nama_upa || 
                           field.data[newData[field.key]]?.jenjang || 
                           field.data[newData[field.key]]?.nama_grup_upa || '-' : '-'
                });
            }
        });

        if (changes.length > 0) {
            $('#preview-changes').show();
            $('#preview-changes-body').empty();
            
            changes.forEach(change => {
                const row = `
                    <tr>
                        <td>${change.field}</td>
                        <td>${change.before}</td>
                        <td>${change.after}</td>
                        <td><span class="badge badge-warning">Berubah</span></td>
                    </tr>
                `;
                $('#preview-changes-body').append(row);
            });
        } else {
            $('#preview-changes').hide();
        }
    }

    // Initial check
    checkChanges();
});
</script>
@endpush

















