@extends('layouts.app')

@section('title', 'Ajukan Perpindahan Anggota')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-exchange-alt"></i> Ajukan Perpindahan Anggota
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('perpindahan.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>

                <form method="POST" action="{{ route('perpindahan.store') }}">
                    @csrf
                    <div class="card-body">
                        <!-- Pilih Anggota -->
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="anggota_id">Pilih Anggota <span class="text-danger">*</span></label>
                                    <select class="form-control select2" id="anggota_id" name="anggota_id" required>
                                        <option value="">-- Pilih Anggota --</option>
                                        @foreach(\App\Models\Anggota::with(['dpd', 'dpc', 'upa', 'refJenjang', 'refGrupUpa'])->orderBy('nama_lengkap')->get() as $anggota)
                                            <option value="{{ $anggota->id }}" 
                                                    data-dpd="{{ $anggota->dpd_id }}"
                                                    data-dpc="{{ $anggota->dpc_id }}"
                                                    data-upa="{{ $anggota->upa_id }}"
                                                    data-jenjang="{{ $anggota->ref_jenjang_id }}"
                                                    data-grup-upa="{{ $anggota->ref_grup_upa_id }}"
                                                    {{ old('anggota_id') == $anggota->id ? 'selected' : '' }}>
                                                {{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('anggota_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Data Saat Ini -->
                        <div id="current-data" class="row" style="display: none;">
                            <div class="col-12">
                                <h5 class="text-primary">Data Saat Ini</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <thead class="bg-light">
                                            <tr>
                                                <th>DPD</th>
                                                <th>DPC</th>
                                                <th>UPA</th>
                                                <th>Jenjang</th>
                                                <th>Grup UPA</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr id="current-data-row">
                                                <td id="current-dpd">-</td>
                                                <td id="current-dpc">-</td>
                                                <td id="current-upa">-</td>
                                                <td id="current-jenjang">-</td>
                                                <td id="current-grup-upa">-</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Data Baru -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-success">Data Baru</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tanggal_perpindahan">Tanggal Perpindahan <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="tanggal_perpindahan" name="tanggal_perpindahan" 
                                           value="{{ old('tanggal_perpindahan', date('Y-m-d')) }}" required>
                                    @error('tanggal_perpindahan')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dpd_id_after">DPD Baru</label>
                                    <select class="form-control" id="dpd_id_after" name="dpd_id_after">
                                        <option value="">-- Pilih DPD --</option>
                                        @foreach($dpdList as $dpd)
                                            <option value="{{ $dpd->dpd_id }}" {{ old('dpd_id_after') == $dpd->dpd_id ? 'selected' : '' }}>
                                                {{ $dpd->nama_dpd }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpd_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dpc_id_after">DPC Baru</label>
                                    <select class="form-control" id="dpc_id_after" name="dpc_id_after">
                                        <option value="">-- Pilih DPC --</option>
                                        @foreach($dpcList as $dpc)
                                            <option value="{{ $dpc->dpc_id }}" {{ old('dpc_id_after') == $dpc->dpc_id ? 'selected' : '' }}>
                                                {{ $dpc->nama_dpc }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpc_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="upa_id_after">UPA Baru</label>
                                    <select class="form-control" id="upa_id_after" name="upa_id_after">
                                        <option value="">-- Pilih UPA --</option>
                                        @foreach($upaList as $upa)
                                            <option value="{{ $upa->upa_id }}" {{ old('upa_id_after') == $upa->upa_id ? 'selected' : '' }}>
                                                {{ $upa->nama_upa }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('upa_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ref_jenjang_id_after">Jenjang Baru</label>
                                    <select class="form-control" id="ref_jenjang_id_after" name="ref_jenjang_id_after">
                                        <option value="">-- Pilih Jenjang --</option>
                                        @foreach($jenjangList as $jenjang)
                                            <option value="{{ $jenjang->ref_jenjang_id }}" {{ old('ref_jenjang_id_after') == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                                {{ $jenjang->jenjang }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('ref_jenjang_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ref_grup_upa_id_after">Grup UPA Baru</label>
                                    <select class="form-control" id="ref_grup_upa_id_after" name="ref_grup_upa_id_after">
                                        <option value="">-- Pilih Grup UPA --</option>
                                        @foreach($grupUpaList as $grupUpa)
                                            <option value="{{ $grupUpa->ref_grup_upa_id }}" {{ old('ref_grup_upa_id_after') == $grupUpa->ref_grup_upa_id ? 'selected' : '' }}>
                                                {{ $grupUpa->nama_grup_upa }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('ref_grup_upa_id_after')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="keterangan">Keterangan</label>
                                    <textarea class="form-control" id="keterangan" name="keterangan" rows="3" 
                                              placeholder="Alasan perpindahan...">{{ old('keterangan') }}</textarea>
                                    @error('keterangan')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Preview Perubahan -->
                        <div id="preview-changes" class="row" style="display: none;">
                            <div class="col-12">
                                <h5 class="text-warning">Preview Perubahan</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <thead class="bg-light">
                                            <tr>
                                                <th>Field</th>
                                                <th>Sebelum</th>
                                                <th>Sesudah</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="preview-changes-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" id="submit-btn" disabled>
                            <i class="fas fa-save"></i> Ajukan Perpindahan
                        </button>
                        <a href="{{ route('perpindahan.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Batal
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        placeholder: '-- Pilih Anggota --',
        allowClear: true
    });

    // Data untuk dropdown
    const dpdData = @json($dpdList->keyBy('dpd_id'));
    const dpcData = @json($dpcList->keyBy('dpc_id'));
    const upaData = @json($upaList->keyBy('upa_id'));
    const jenjangData = @json($jenjangList->keyBy('ref_jenjang_id'));
    const grupUpaData = @json($grupUpaList->keyBy('ref_grup_upa_id'));

    // Handle anggota selection
    $('#anggota_id').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const anggotaId = $(this).val();
        
        if (anggotaId) {
            // Show current data
            $('#current-data').show();
            
            // Update current data display
            $('#current-dpd').text(dpdData[selectedOption.data('dpd')]?.nama_dpd || '-');
            $('#current-dpc').text(dpcData[selectedOption.data('dpc')]?.nama_dpc || '-');
            $('#current-upa').text(upaData[selectedOption.data('upa')]?.nama_upa || '-');
            $('#current-jenjang').text(jenjangData[selectedOption.data('jenjang')]?.jenjang || '-');
            $('#current-grup-upa').text(grupUpaData[selectedOption.data('grup-upa')]?.nama_grup_upa || '-');
            
            // Pre-fill new data with current data
            $('#dpd_id_after').val(selectedOption.data('dpd'));
            $('#dpc_id_after').val(selectedOption.data('dpc'));
            $('#upa_id_after').val(selectedOption.data('upa'));
            $('#ref_jenjang_id_after').val(selectedOption.data('jenjang'));
            $('#ref_grup_upa_id_after').val(selectedOption.data('grup-upa'));
            
            checkChanges();
        } else {
            $('#current-data').hide();
            $('#preview-changes').hide();
            $('#submit-btn').prop('disabled', true);
        }
    });

    // Handle form field changes
    $('#dpd_id_after, #dpc_id_after, #upa_id_after, #ref_jenjang_id_after, #ref_grup_upa_id_after').on('change', function() {
        checkChanges();
    });

    function checkChanges() {
        const anggotaId = $('#anggota_id').val();
        if (!anggotaId) return;

        const selectedOption = $('#anggota_id').find('option:selected');
        const currentData = {
            dpd: selectedOption.data('dpd'),
            dpc: selectedOption.data('dpc'),
            upa: selectedOption.data('upa'),
            jenjang: selectedOption.data('jenjang'),
            grupUpa: selectedOption.data('grup-upa')
        };

        const newData = {
            dpd: $('#dpd_id_after').val(),
            dpc: $('#dpc_id_after').val(),
            upa: $('#upa_id_after').val(),
            jenjang: $('#ref_jenjang_id_after').val(),
            grupUpa: $('#ref_grup_upa_id_after').val()
        };

        // Check for changes
        const changes = [];
        const fields = [
            { key: 'dpd', label: 'DPD', data: dpdData },
            { key: 'dpc', label: 'DPC', data: dpcData },
            { key: 'upa', label: 'UPA', data: upaData },
            { key: 'jenjang', label: 'Jenjang', data: jenjangData },
            { key: 'grupUpa', label: 'Grup UPA', data: grupUpaData }
        ];

        fields.forEach(field => {
            if (currentData[field.key] != newData[field.key]) {
                changes.push({
                    field: field.label,
                    before: currentData[field.key] ? field.data[currentData[field.key]]?.nama_dpd || 
                            field.data[currentData[field.key]]?.nama_dpc || 
                            field.data[currentData[field.key]]?.nama_upa || 
                            field.data[currentData[field.key]]?.jenjang || 
                            field.data[currentData[field.key]]?.nama_grup_upa || '-' : '-',
                    after: newData[field.key] ? field.data[newData[field.key]]?.nama_dpd || 
                           field.data[newData[field.key]]?.nama_dpc || 
                           field.data[newData[field.key]]?.nama_upa || 
                           field.data[newData[field.key]]?.jenjang || 
                           field.data[newData[field.key]]?.nama_grup_upa || '-' : '-'
                });
            }
        });

        if (changes.length > 0) {
            $('#preview-changes').show();
            $('#preview-changes-body').empty();
            
            changes.forEach(change => {
                const row = `
                    <tr>
                        <td>${change.field}</td>
                        <td>${change.before}</td>
                        <td>${change.after}</td>
                        <td><span class="badge badge-warning">Berubah</span></td>
                    </tr>
                `;
                $('#preview-changes-body').append(row);
            });
            
            $('#submit-btn').prop('disabled', false);
        } else {
            $('#preview-changes').hide();
            $('#submit-btn').prop('disabled', true);
        }
    }

    // Form validation
    $('form').on('submit', function(e) {
        if ($('#submit-btn').prop('disabled')) {
            e.preventDefault();
            alert('Tidak ada perubahan data yang diajukan.');
            return false;
        }
    });
});
</script>
@endpush

















