@extends('layouts.app')

@section('content')
<div class="container-fluid px-4">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="mt-4">
                <i class="fas fa-history me-2"></i>Riwayat Perpindahan Anggota
            </h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">Riwayat Perpindahan</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Alert Messages --}}
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @endif

    {{-- Quick Actions --}}
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <div class="row g-2">
                <div class="col-auto">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'mutasi']) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>Mutasi Anggota
                    </a>
                </div>
                <div class="col-auto">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'penempatan']) }}" class="btn btn-success">
                        <i class="fas fa-plus me-1"></i>Surat Penempatan
                    </a>
                </div>
                <div class="col-auto">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'perpindahan']) }}" class="btn btn-info">
                        <i class="fas fa-plus me-1"></i>Perpindahan
                    </a>
                </div>
                <div class="col-auto">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'rekomposisi']) }}" class="btn btn-warning">
                        <i class="fas fa-plus me-1"></i>Rekomposisi UPA
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- Filter --}}
    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filter</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('perpindahan-anggota.index') }}">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Tipe Transaksi</label>
                        <select name="tipe" class="form-select">
                            <option value="">Semua Tipe</option>
                            <option value="mutasi" {{ request('tipe') == 'mutasi' ? 'selected' : '' }}>Mutasi</option>
                            <option value="penempatan" {{ request('tipe') == 'penempatan' ? 'selected' : '' }}>Penempatan</option>
                            <option value="perpindahan" {{ request('tipe') == 'perpindahan' ? 'selected' : '' }}>Perpindahan</option>
                            <option value="rekomposisi" {{ request('tipe') == 'rekomposisi' ? 'selected' : '' }}>Rekomposisi</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="">Semua Status</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                        <a href="{{ route('perpindahan-anggota.index') }}" class="btn btn-secondary">
                            <i class="fas fa-redo me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{-- Data Table --}}
    <div class="card shadow-sm">
        <div class="card-header bg-light">
            <h5 class="mb-0"><i class="fas fa-list me-2"></i>Data Riwayat Perpindahan</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>No</th>
                            <th>Nomor Surat</th>
                            <th>Tipe</th>
                            <th>Anggota</th>
                            <th>UPA Asal → Tujuan</th>
                            <th>Tanggal</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($riwayat as $item)
                        <tr>
                            <td>{{ $riwayat->firstItem() + $loop->index }}</td>
                            <td><strong>{{ $item->nomor_surat }}</strong></td>
                            <td>
                                <span class="badge bg-secondary">{{ $item->tipe_transaksi_label }}</span>
                            </td>
                            <td>
                                {{ $item->anggota->nama_lengkap ?? '-' }}<br>
                                <small class="text-muted">{{ $item->anggota->nomor_identitas_anggota ?? '-' }}</small>
                            </td>
                            <td>
                                <small>
                                    {{ $item->upaAsal->nama_upa ?? '-' }}<br>
                                    <i class="fas fa-arrow-down text-muted"></i><br>
                                    {{ $item->upaTujuan->nama_upa ?? '-' }}
                                </small>
                            </td>
                            <td>{{ $item->tanggal_efektif->format('d/m/Y') }}</td>
                            <td>
                                <span class="badge bg-{{ $item->status_badge }}">{{ ucfirst($item->status) }}</span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('perpindahan-anggota.show', $item->id) }}" 
                                       class="btn btn-info" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('perpindahan-anggota.download-surat', $item->id) }}" 
                                       class="btn btn-success" title="Download Surat">
                                        <i class="fas fa-download"></i>
                                    </a>
                                    @if(in_array($item->status, ['draft', 'cancelled']))
                                    <form action="{{ route('perpindahan-anggota.destroy', $item->id) }}" 
                                          method="POST" class="d-inline"
                                          onsubmit="return confirm('Yakin ingin menghapus riwayat ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada riwayat perpindahan</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($riwayat->hasPages())
        <div class="card-footer">
            {{ $riwayat->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

