@extends('layouts.app')

@section('content')
<div class="container-fluid px-4">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="mt-4">
                <i class="fas fa-exchange-alt me-2"></i>{{ $tipeLabel }}
            </h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('perpindahan-anggota.index') }}">Riwayat Perpindahan</a></li>
                    <li class="breadcrumb-item active">{{ $tipeLabel }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Pilihan Tipe Transaksi --}}
    <div class="card mb-4 shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fas fa-list me-2"></i>Pilih Tipe Transaksi</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'mutasi']) }}" 
                       class="btn btn-lg w-100 {{ $tipe == 'mutasi' ? 'btn-primary' : 'btn-outline-primary' }}">
                        <i class="fas fa-users me-2"></i><br>
                        Mutasi Anggota
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'penempatan']) }}" 
                       class="btn btn-lg w-100 {{ $tipe == 'penempatan' ? 'btn-success' : 'btn-outline-success' }}">
                        <i class="fas fa-file-alt me-2"></i><br>
                        Surat Penempatan
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'perpindahan']) }}" 
                       class="btn btn-lg w-100 {{ $tipe == 'perpindahan' ? 'btn-info' : 'btn-outline-info' }}">
                        <i class="fas fa-exchange-alt me-2"></i><br>
                        Perpindahan Anggota
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('perpindahan-anggota.create', ['tipe' => 'rekomposisi']) }}" 
                       class="btn btn-lg w-100 {{ $tipe == 'rekomposisi' ? 'btn-warning' : 'btn-outline-warning' }}">
                        <i class="fas fa-project-diagram me-2"></i><br>
                        Rekomposisi UPA
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- Form Perpindahan --}}
    <form action="{{ route('perpindahan-anggota.store') }}" method="POST" id="formPerpindahan">
        @csrf
        <input type="hidden" name="tipe_transaksi" value="{{ $tipe }}">

        <div class="card shadow-sm">
            <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-edit me-2"></i>Form {{ $tipeLabel }}</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    {{-- DPC Asal --}}
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-map-marker-alt me-1 text-danger"></i>DPC Asal <span class="text-danger">*</span>
                        </label>
                        <select name="dpc_asal_id" id="dpc_asal_id" class="form-select" required>
                            <option value="">-- Pilih DPC Asal --</option>
                            @foreach($dpcList as $dpc)
                                <option value="{{ $dpc->dpc_id }}">{{ $dpc->nama_dpc }}</option>
                            @endforeach
                        </select>
                        @error('dpc_asal_id')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- UPA Asal --}}
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-home me-1 text-danger"></i>UPA Asal <span class="text-danger">*</span>
                        </label>
                        <select name="upa_asal_id" id="upa_asal_id" class="form-select" required disabled>
                            <option value="">-- Pilih UPA Asal --</option>
                        </select>
                        <small class="text-muted">Pilih DPC Asal terlebih dahulu</small>
                    </div>

                    {{-- Anggota --}}
                    <div class="col-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-user me-1 text-primary"></i>Pilih Anggota <span class="text-danger">*</span>
                        </label>
                        <select name="anggota_id" id="anggota_id" class="form-select" required disabled>
                            <option value="">-- Pilih Anggota --</option>
                        </select>
                        <small class="text-muted">Pilih UPA Asal terlebih dahulu</small>
                        @error('anggota_id')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Pembimbing Lama --}}
                    @if(in_array('pembimbing_lama', $requiredFields) || in_array('pembimbing_baru', $requiredFields))
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-user-friends me-1 text-success"></i>Pembimbing Lama
                        </label>
                        <select name="pembimbing_lama_id" id="pembimbing_lama_id" class="form-select">
                            <option value="">-- Pilih Pembimbing Lama --</option>
                        </select>
                    </div>
                    @endif

                    {{-- DPC Tujuan --}}
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-map-marker-alt me-1 text-success"></i>DPC Tujuan <span class="text-danger">*</span>
                        </label>
                        <select name="dpc_tujuan_id" id="dpc_tujuan_id" class="form-select" required>
                            <option value="">-- Pilih DPC Tujuan --</option>
                            @foreach($dpcList as $dpc)
                                <option value="{{ $dpc->dpc_id }}">{{ $dpc->nama_dpc }}</option>
                            @endforeach
                        </select>
                        @error('dpc_tujuan_id')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- UPA Tujuan --}}
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-home me-1 text-success"></i>UPA Tujuan <span class="text-danger">*</span>
                        </label>
                        <select name="upa_tujuan_id" id="upa_tujuan_id" class="form-select" required disabled>
                            <option value="">-- Pilih UPA Tujuan --</option>
                        </select>
                        <small class="text-muted">Pilih DPC Tujuan terlebih dahulu</small>
                        @error('upa_tujuan_id')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>


                    {{-- Pembimbing Baru --}}
                    @if(in_array('pembimbing_baru', $requiredFields))
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-user-friends me-1 text-info"></i>Pembimbing Baru
                        </label>
                        <select name="pembimbing_baru_id" id="pembimbing_baru_id" class="form-select">
                            <option value="">-- Pilih Pembimbing Baru --</option>
                        </select>
                    </div>
                    @endif

                    {{-- Tahun Pelantikan (khusus penempatan) --}}
                    @if(in_array('tahun_pelantikan', $requiredFields))
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-calendar me-1 text-warning"></i>Tahun Pelantikan <span class="text-danger">*</span>
                        </label>
                        <input type="number" name="tahun_pelantikan" class="form-control" 
                               placeholder="2025" min="2000" max="2100" required>
                        @error('tahun_pelantikan')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    @endif

                    {{-- Tanggal Efektif --}}
                    <div class="col-lg-6 col-md-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-calendar-check me-1 text-primary"></i>Tanggal Efektif
                        </label>
                        <input type="date" name="tanggal_efektif" class="form-control" value="{{ date('Y-m-d') }}">
                        @error('tanggal_efektif')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Alasan (required untuk mutasi & rekomposisi) --}}
                    @if(in_array('alasan', $requiredFields))
                    <div class="col-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-comment me-1 text-warning"></i>Alasan {{ $tipeLabel }} <span class="text-danger">*</span>
                        </label>
                        <textarea name="alasan" class="form-control" rows="3" required 
                                  placeholder="Jelaskan alasan {{ strtolower($tipeLabel) }}..."></textarea>
                        @error('alasan')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    @endif

                    {{-- Catatan --}}
                    <div class="col-12">
                        <label class="form-label fw-semibold text-dark">
                            <i class="fas fa-sticky-note me-1 text-secondary"></i>Catatan Tambahan
                        </label>
                        <textarea name="catatan" class="form-control" rows="2" 
                                  placeholder="Catatan tambahan (opsional)..."></textarea>
                        @error('catatan')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="card-footer bg-light">
                <div class="d-flex justify-content-between">
                    <a href="{{ route('perpindahan-anggota.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i>Kembali
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Proses {{ $tipeLabel }}
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Filter UPA berdasarkan DPC Asal
    $('#dpc_asal_id').change(function() {
        const dpcId = $(this).val();
        const upaSelect = $('#upa_asal_id');
        
        upaSelect.prop('disabled', true).html('<option value="">Loading...</option>');
        $('#anggota_id').prop('disabled', true).html('<option value="">-- Pilih Anggota --</option>');
        $('#pembimbing_lama_id').html('<option value="">-- Pilih Pembimbing Lama --</option>');
        
        if (dpcId) {
            $.get('{{ route("perpindahan-anggota.ajax.upa-by-dpc") }}', { dpc_id: dpcId }, function(data) {
                let options = '<option value="">-- Pilih UPA Asal --</option>';
                $.each(data, function(index, upa) {
                    options += '<option value="' + upa.upa_id + '">' + upa.nama_upa + ' (' + upa.kode_upa + ')</option>';
                });
                upaSelect.html(options).prop('disabled', false);
            });
        }
    });

    // Filter Anggota dan load Pembimbing Lama berdasarkan UPA Asal
    $('#upa_asal_id').change(function() {
        const upaId = $(this).val();
        const anggotaSelect = $('#anggota_id');
        const pembimbingLamaSelect = $('#pembimbing_lama_id');
        
        anggotaSelect.prop('disabled', true).html('<option value="">Loading...</option>');
        
        if (upaId) {
            // Load anggota
            $.get('{{ route("perpindahan-anggota.ajax.anggota-by-upa") }}', { upa_id: upaId }, function(data) {
                let options = '<option value="">-- Pilih Anggota --</option>';
                $.each(data, function(index, anggota) {
                    options += '<option value="' + anggota.id + '">' + anggota.nama_lengkap + ' (' + anggota.nomor_identitas_anggota + ')</option>';
                });
                anggotaSelect.html(options).prop('disabled', false);
            });
            
            // Load pembimbing lama
            $.get('{{ route("perpindahan-anggota.ajax.pembimbing-by-upa") }}', { upa_id: upaId }, function(data) {
                let options = '<option value="">-- Pilih Pembimbing Lama --</option>';
                $.each(data, function(index, pembimbing) {
                    options += '<option value="' + pembimbing.id + '">' + pembimbing.nama_lengkap + ' - ' + pembimbing.jabatan + '</option>';
                });
                pembimbingLamaSelect.html(options);
                
                // Auto-select pembimbing pertama
                if (data.length > 0) {
                    pembimbingLamaSelect.val(data[0].id);
                }
            });
        }
    });

    // Set default DPC Tujuan sama dengan DPC Asal ketika anggota dipilih
    $('#anggota_id').change(function() {
        const dpcAsalId = $('#dpc_asal_id').val();
        if (dpcAsalId && !$('#dpc_tujuan_id').val()) {
            $('#dpc_tujuan_id').val(dpcAsalId).trigger('change');
        }
    });

    // Filter UPA berdasarkan DPC Tujuan
    $('#dpc_tujuan_id').change(function() {
        const dpcId = $(this).val();
        const upaSelect = $('#upa_tujuan_id');
        
        upaSelect.prop('disabled', true).html('<option value="">Loading...</option>');
        $('#pembimbing_baru_id').html('<option value="">-- Pilih Pembimbing Baru --</option>');
        
        if (dpcId) {
            $.get('{{ route("perpindahan-anggota.ajax.upa-by-dpc") }}', { dpc_id: dpcId }, function(data) {
                let options = '<option value="">-- Pilih UPA Tujuan --</option>';
                $.each(data, function(index, upa) {
                    options += '<option value="' + upa.upa_id + '">' + upa.nama_upa + ' (' + upa.kode_upa + ')</option>';
                });
                upaSelect.html(options).prop('disabled', false);
            });
        }
    });

    // Load Pembimbing Baru berdasarkan UPA Tujuan
    $('#upa_tujuan_id').change(function() {
        const upaId = $(this).val();
        const pembimbingBaruSelect = $('#pembimbing_baru_id');
        
        if (upaId) {
            $.get('{{ route("perpindahan-anggota.ajax.pembimbing-by-upa") }}', { upa_id: upaId }, function(data) {
                let options = '<option value="">-- Pilih Pembimbing Baru --</option>';
                $.each(data, function(index, pembimbing) {
                    options += '<option value="' + pembimbing.id + '">' + pembimbing.nama_lengkap + ' - ' + pembimbing.jabatan + '</option>';
                });
                pembimbingBaruSelect.html(options);
                
                // Auto-select pembimbing pertama
                if (data.length > 0) {
                    pembimbingBaruSelect.val(data[0].id);
                }
            });
        }
    });
});
</script>
@endpush
@endsection

