@extends('layouts.app')

@section('title', 'Penilaian Peserta Takwim - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Penilaian Peserta Takwim</h1>
        <p class="text-muted">Kelola penilaian peserta program takwim</p>
    </div>
</div>

<!-- Filter -->
<div class="card shadow mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('penilaian-peserta.index') }}">
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="form-label">Takwim</label>
                    <select class="form-select" name="takwim_id">
                        <option value="">Semua Takwim</option>
                        @foreach($takwimList as $takwim)
                            <option value="{{ $takwim->id }}" {{ request('takwim_id') == $takwim->id ? 'selected' : '' }}>
                                {{ $takwim->nama_takwim }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Status Penilaian</label>
                    <select class="form-select" name="status_penilaian">
                        <option value="">Semua Status</option>
                        <option value="sudah_dinilai" {{ request('status_penilaian') == 'sudah_dinilai' ? 'selected' : '' }}>Sudah Dinilai</option>
                        <option value="belum_dinilai" {{ request('status_penilaian') == 'belum_dinilai' ? 'selected' : '' }}>Belum Dinilai</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Status Kelulusan</label>
                    <select class="form-select" name="status_kelulusan">
                        <option value="">Semua Status</option>
                        <option value="Lulus" {{ request('status_kelulusan') == 'Lulus' ? 'selected' : '' }}>Lulus</option>
                        <option value="Tidak Lulus" {{ request('status_kelulusan') == 'Tidak Lulus' ? 'selected' : '' }}>Tidak Lulus</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i> Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-users me-2"></i>Daftar Peserta Takwim
        </h6>
        <span class="badge bg-light text-dark">
            Total: {{ $peserta->total() }} peserta
        </span>
    </div>
    <div class="card-body">
        @if($peserta->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Peserta</th>
                            <th>Takwim</th>
                            <th>Jenjang</th>
                            <th>Status Penilaian</th>
                            <th>Status Kelulusan</th>
                            <th>Skor</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($peserta as $index => $item)
                        <tr>
                            <td>{{ $peserta->firstItem() + $index }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="rounded-circle me-2 d-flex align-items-center justify-content-center" 
                                         style="width: 35px; height: 35px; background: linear-gradient(135deg, #F0833A, #E67E22);">
                                        <i class="fas fa-user text-white"></i>
                                    </div>
                                    <div>
                                        <div class="fw-bold">
                                            <a href="{{ route('anggota.show', $item->anggota) }}" class="text-decoration-none text-primary">
                                                {{ $item->anggota->nama_lengkap }}
                                            </a>
                                        </div>
                                        <small class="text-muted">{{ $item->anggota->email }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="text-dark">{{ $item->takwim->nama_takwim }}</span>
                            </td>
                            <td>
                                <span class="text-dark">{{ $item->anggota->refJenjang->jenjang ?? $item->anggota->jenjang_anggota }}</span>
                            </td>
                            <td>
                                @if($item->penilaianTerbaru)
                                    <span class="text-dark">
                                        <i class="fas fa-check me-1"></i>Sudah Dinilai
                                    </span>
                                @else
                                    <span class="text-dark">
                                        <i class="fas fa-clock me-1"></i>Belum Dinilai
                                    </span>
                                @endif
                            </td>
                            <td>
                                @if($item->penilaianTerbaru)
                                    <span class="text-dark">
                                        {{ $item->penilaianTerbaru->status_kelulusan }}
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($item->penilaianTerbaru)
                                    <span class="fw-bold">{{ $item->penilaianTerbaru->total_skor }}/7</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    @if($item->penilaianTerbaru)
                                        <a href="{{ route('penilaian-peserta.show', $item->penilaianTerbaru) }}" 
                                           class="btn btn-outline-info" title="Lihat Penilaian">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('penilaian-peserta.edit', $item->penilaianTerbaru) }}" 
                                           class="btn btn-outline-warning" title="Edit Penilaian">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    @else
                                        <a href="{{ route('penilaian-peserta.create', ['peserta_id' => $item->id]) }}" 
                                           class="btn btn-outline-primary" title="Buat Penilaian">
                                            <i class="fas fa-plus"></i>
                                        </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div class="text-muted">
                    Menampilkan {{ $peserta->firstItem() }} sampai {{ $peserta->lastItem() }} dari {{ $peserta->total() }} data
                </div>
                <div>
                    {{ $peserta->links() }}
                </div>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Belum ada peserta takwim</h5>
                <p class="text-muted">Peserta akan muncul setelah mendaftar di program takwim</p>
            </div>
        @endif
    </div>
</div>
@endsection
