@extends('layouts.app')

@section('title', 'Form Penilaian Peserta - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Form Verifikasi Peserta Takwim</h1>
        <p class="text-muted">Penilaian peserta: <strong>{{ $peserta->anggota->nama_lengkap }}</strong></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('penilaian-peserta.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
        </a>
    </div>
</div>

<!-- Informasi Peserta -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-user me-2"></i>Informasi Peserta
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td class="fw-bold text-muted">Nama Lengkap:</td>
                        <td>{{ $peserta->anggota->nama_lengkap }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">NIA:</td>
                        <td>{{ $peserta->anggota->nomor_identitas_anggota }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Jenjang:</td>
                        <td><span class="badge bg-secondary">{{ $peserta->anggota->refJenjang->jenjang ?? $peserta->anggota->jenjang_anggota }}</span></td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td class="fw-bold text-muted">Program Takwim:</td>
                        <td><span class="badge bg-primary">{{ $peserta->takwim->nama_takwim }}</span></td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Tanggal Bergabung:</td>
                        <td>{{ $peserta->tanggal_bergabung->format('d/m/Y') }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Penilai:</td>
                        <td>{{ Auth::user()->name }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Form Penilaian -->
<form action="{{ route('penilaian-peserta.store') }}" method="POST">
    @csrf
    <input type="hidden" name="peserta_takwim_id" value="{{ $peserta->id }}">
    
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-clipboard-check me-2"></i>Form Verifikasi Peserta Takwim
            </h6>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label required">Tanggal Penilaian</label>
                    <input type="date" class="form-control @error('tanggal_penilaian') is-invalid @enderror" 
                           name="tanggal_penilaian" value="{{ old('tanggal_penilaian', date('Y-m-d')) }}" required>
                    @error('tanggal_penilaian')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th style="width: 5%">No</th>
                            <th style="width: 60%">INDIKATOR</th>
                            <th style="width: 17.5%">LULUS</th>
                            <th style="width: 17.5%">TIDAK</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($indikators as $indikator)
                        <tr>
                            <td class="text-center fw-bold">{{ $indikator->nomor }}</td>
                            <td class="text-justify">{{ $indikator->indikator }}</td>
                            <td class="text-center">
                                <div class="form-check d-flex justify-content-center">
                                    <input class="form-check-input" type="radio" 
                                           name="indikator_{{ $indikator->nomor }}" value="1" id="indikator_{{ $indikator->nomor }}_ya"
                                           {{ old('indikator_' . $indikator->nomor) == '1' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="indikator_{{ $indikator->nomor }}_ya">
                                        Ya
                                    </label>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="form-check d-flex justify-content-center">
                                    <input class="form-check-input" type="radio" 
                                           name="indikator_{{ $indikator->nomor }}" value="0" id="indikator_{{ $indikator->nomor }}_tidak"
                                           {{ old('indikator_' . $indikator->nomor) == '0' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="indikator_{{ $indikator->nomor }}_tidak">
                                        Tidak
                                    </label>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="row mt-4">
                <div class="col-md-6">
                    <label class="form-label">Catatan Penilaian</label>
                    <textarea class="form-control @error('catatan_penilaian') is-invalid @enderror" 
                              name="catatan_penilaian" rows="3" 
                              placeholder="Masukkan catatan tambahan...">{{ old('catatan_penilaian') }}</textarea>
                    @error('catatan_penilaian')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6">
                    <label class="form-label">Rekomendasi</label>
                    <textarea class="form-control @error('rekomendasi') is-invalid @enderror" 
                              name="rekomendasi" rows="3" 
                              placeholder="Masukkan rekomendasi...">{{ old('rekomendasi') }}</textarea>
                    @error('rekomendasi')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-body text-center">
                    <button type="submit" class="btn btn-primary btn-lg me-3">
                        <i class="fas fa-save me-2"></i> Simpan Penilaian
                    </button>
                    <a href="{{ route('penilaian-peserta.index') }}" class="btn btn-outline-secondary btn-lg">
                        <i class="fas fa-times me-2"></i> Batal
                    </a>
                </div>
            </div>
        </div>
    </div>
</form>

<style>
.required::after {
    content: " *";
    color: red;
}

.table th {
    vertical-align: middle;
    text-align: center;
}

.table td {
    vertical-align: middle;
}

.form-check-input:checked {
    background-color: #F0833A;
    border-color: #F0833A;
}

.form-check-input:focus {
    border-color: #F0833A;
    box-shadow: 0 0 0 0.25rem rgba(240, 131, 58, 0.25);
}
</style>
@endsection
