{{-- resources/views/mutasi/show.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4>
                        <i class="fas fa-sign-out-alt"></i>
                        Detail Mutasi Keluar - {{ $mutasi->anggota->nama_lengkap }}
                    </h4>
                </div>
                
                <div class="card-body">
                    {{-- Alert Messages --}}
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    {{-- Info Umum --}}
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Nama Anggota</strong></td>
                                    <td>: {{ $mutasi->anggota->nama_lengkap }}</td>
                                </tr>
                                <tr>
                                    <td><strong>NIA</strong></td>
                                    <td>: {{ $mutasi->anggota->nomor_identitas_anggota }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Mutasi</strong></td>
                                    <td>: {{ $mutasi->tanggal_mutasi->format('d F Y') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>: <span class="text-dark">{{ $mutasi->status_mutasi }}</span></td>
                                </tr>
                                @if($mutasi->nomor_sk)
                                <tr>
                                    <td><strong>Nomor SK</strong></td>
                                    <td>: <strong class="text-success">{{ $mutasi->nomor_sk }}</strong></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Alasan</strong></td>
                                    <td>: {{ $mutasi->alasan_mutasi }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Alamat Tujuan</strong></td>
                                    <td>: {{ $mutasi->alamat_tujuan }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    {{-- Data Asal dan Tujuan --}}
                    <hr>
                    <h6><strong><i class="fas fa-exchange-alt"></i> Data Perpindahan:</strong></h6>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <strong>Asal</strong>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless table-sm mb-0">
                                        <tr>
                                            <td width="30%"><strong>DPD Asal:</strong></td>
                                            <td>
                                                @if($mutasi->dpd_dari)
                                                    @php
                                                        $dpdAsal = \App\Models\Dpd::find($mutasi->dpd_dari);
                                                    @endphp
                                                    {{ $dpdAsal ? $dpdAsal->nama_dpd : $mutasi->dpd_dari }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>DPC Asal:</strong></td>
                                            <td>
                                                @if($mutasi->strukturDari)
                                                    {{ $mutasi->strukturDari->nama_struktur }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white">
                                    <strong>Tujuan</strong>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless table-sm mb-0">
                                        <tr>
                                            <td width="30%"><strong>DPD Tujuan:</strong></td>
                                            <td>
                                                @if($mutasi->dpd_ke)
                                                    @php
                                                        $dpdTujuan = \App\Models\Dpd::find($mutasi->dpd_ke);
                                                    @endphp
                                                    {{ $dpdTujuan ? $dpdTujuan->nama_dpd : $mutasi->dpd_ke }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>DPC Tujuan:</strong></td>
                                            <td>
                                                @if($mutasi->strukturKe)
                                                    {{ $mutasi->strukturKe->nama_struktur }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    {{-- Catatan --}}
                    @if($mutasi->catatan)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h6><strong><i class="fas fa-sticky-note"></i> Catatan:</strong></h6>
                            <div class="bg-light p-3 rounded">
                                {{ $mutasi->catatan }}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    {{-- Info Approval --}}
                    @if($mutasi->disetujuiOleh)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="bg-success bg-opacity-10 p-3 rounded">
                                <small class="text-success">
                                    <i class="fas fa-user-check"></i> <strong>Disetujui oleh:</strong> {{ $mutasi->disetujuiOleh->name }} 
                                    pada {{ $mutasi->tanggal_sk->format('d F Y H:i') }} WIB
                                </small>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        
        {{-- SIDEBAR AKSI --}}
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5><i class="fas fa-cogs"></i> Aksi Mutasi</h5>
                </div>
                
                <div class="card-body">
                    {{-- TOMBOL PRINT SURAT --}}
                    @if($mutasi->status_mutasi == 'Disetujui')
                        <div class="d-grid gap-2 mb-3">
                            <a href="{{ route('mutasi.print-surat', $mutasi->id) }}" class="btn btn-danger" target="_blank">
                                <i class="fas fa-file-pdf"></i> Print Surat Mutasi Keluar
                            </a>
                        </div>
                        <hr>
                    @endif
                    
                    {{-- TOMBOL AKSI LAINNYA --}}
                    <div class="d-grid gap-2">
                        @if($mutasi->status_mutasi == 'Pending')
                            <a href="{{ route('mutasi.edit', $mutasi->id) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> Edit Data
                            </a>
                            
                            <form action="{{ route('mutasi.approve', $mutasi->id) }}" method="POST" style="display: inline;">
                                @csrf
                                <button type="submit" class="btn btn-success w-100" onclick="return confirm('Yakin setujui mutasi ini?')">
                                    <i class="fas fa-check"></i> Setujui Mutasi
                                </button>
                            </form>
                            
                            <button type="button" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                <i class="fas fa-times"></i> Tolak Mutasi
                            </button>
                        @endif
                        
                        <a href="{{ route('mutasi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke List
                        </a>
                    </div>
                </div>
            </div>
            
            {{-- INFO ANGGOTA --}}
            <div class="card mt-3">
                <div class="card-header">
                    <h6><i class="fas fa-user"></i> Info Anggota</h6>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        @if($mutasi->anggota->foto)
                            <img src="{{ asset('storage/fotos/' . $mutasi->anggota->foto) }}" 
                                 class="rounded-circle" width="80" height="80" alt="Foto" style="object-fit: cover;">
                        @else
                            <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 80px; height: 80px;">
                                <i class="fas fa-user fa-2x text-white"></i>
                            </div>
                        @endif
                    </div>
                    
                    <div class="text-center mb-2">
                        <strong>{{ $mutasi->anggota->nama_lengkap }}</strong><br>
                        <small class="text-muted">{{ $mutasi->anggota->nomor_identitas_anggota }}</small>
                    </div>
                    
                    <table class="table table-borderless table-sm">
                        <tr>
                            <td><strong>Jenjang:</strong></td>
                            <td>{{ $mutasi->anggota->refJenjang->jenjang ?? $mutasi->anggota->jenjang_anggota }}</td>
                        </tr>
                        <tr>
                            <td><strong>Bergabung:</strong></td>
                            <td>{{ $mutasi->anggota->tanggal_bergabung->format('d/m/Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Telepon:</strong></td>
                            <td>{{ $mutasi->anggota->no_telepon }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="text-dark">
                                    {{ $mutasi->anggota->status_keanggotaan }}
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal Tolak Mutasi --}}
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="rejectModalLabel">
                    <i class="fas fa-times text-danger"></i> Tolak Mutasi
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('mutasi.reject', $mutasi->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Perhatian!</strong> Mutasi yang sudah ditolak tidak dapat diubah kembali.
                    </div>
                    
                    <div class="form-group mb-3">
                        <label for="alasan_penolakan">Alasan Penolakan <span class="text-danger">*</span></label>
                        <textarea name="alasan_penolakan" id="alasan_penolakan" class="form-control" rows="4" 
                                  placeholder="Jelaskan alasan penolakan mutasi ini..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times"></i> Batal
                    </button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-ban"></i> Tolak Mutasi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection