@extends('layouts.app')

@section('title', 'Keranjang Mutasi - Anggota Tidak Aktif')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-shopping-cart text-warning me-2"></i>
            Keranjang Mutasi
        </h1>
        <div class="d-flex">
            <a href="{{ route('mutasi.index') }}" class="btn btn-outline-primary me-2">
                <i class="fas fa-arrow-left me-1"></i>
                Kembali ke Mutasi
            </a>
            <a href="{{ route('mutasi.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i>
                Buat Mutasi Baru
            </a>
        </div>
    </div>

    <!-- Info Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-warning">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="card-title text-warning mb-1">
                                <i class="fas fa-info-circle me-2"></i>
                                Informasi Keranjang Mutasi
                            </h5>
                            <p class="card-text text-muted mb-0">
                                Halaman ini menampilkan daftar anggota yang telah bermutasi keluar (status Tidak Aktif). 
                                Anda dapat mengembalikan status mereka menjadi Aktif jika diperlukan.
                            </p>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="badge bg-warning text-dark fs-6 px-3 py-2">
                                Total: {{ $anggotas->total() }} Anggota
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow-sm mb-4 border-0">
        <div class="card-header bg-gradient-warning py-3">
            <h6 class="m-0 font-weight-bold text-dark d-flex align-items-center">
                <i class="fas fa-filter me-2"></i>Filter & Pencarian
            </h6>
        </div>
        <div class="card-body p-3">
            <form method="GET" action="{{ route('mutasi.keranjang') }}" id="filterForm">
                <div class="row g-2 mb-3">
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-semibold text-dark small">
                            <i class="fas fa-search me-1 text-warning"></i>Pencarian
                        </label>
                        <input type="text" class="form-control" name="search" 
                               value="{{ request('search') }}" 
                               placeholder="Cari nama anggota..."
                               style="border-radius: 6px;">
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-semibold text-dark small">
                            <i class="fas fa-building me-1 text-warning"></i>DPD
                        </label>
                        <select class="form-select" name="dpd_id" style="border-radius: 6px;">
                            <option value="">Semua DPD</option>
                            @foreach($dpds as $dpd)
                                <option value="{{ $dpd->dpd_id }}" {{ request('dpd_id') == $dpd->dpd_id ? 'selected' : '' }}>
                                    {{ $dpd->nama_dpd }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-semibold text-dark small">
                            <i class="fas fa-sitemap me-1 text-warning"></i>DPC
                        </label>
                        <select class="form-select" name="dpc_id" style="border-radius: 6px;">
                            <option value="">Semua DPC</option>
                            @foreach($dpcs as $dpc)
                                <option value="{{ $dpc->dpc_id }}" {{ request('dpc_id') == $dpc->dpc_id ? 'selected' : '' }}>
                                    {{ $dpc->nama_dpc }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-semibold text-dark small">
                            <i class="fas fa-calendar me-1 text-warning"></i>Tanggal Mutasi
                        </label>
                        <div class="row g-1">
                            <div class="col-6">
                                <input type="date" class="form-control form-control-sm" name="tanggal_dari" 
                                       value="{{ request('tanggal_dari') }}" placeholder="Dari">
                            </div>
                            <div class="col-6">
                                <input type="date" class="form-control form-control-sm" name="tanggal_sampai" 
                                       value="{{ request('tanggal_sampai') }}" placeholder="Sampai">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between align-items-center">
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-search me-1"></i>
                        Filter
                    </button>
                    <a href="{{ route('mutasi.keranjang') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i>
                        Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white py-3">
            <h6 class="m-0 font-weight-bold text-dark d-flex align-items-center">
                <i class="fas fa-list me-2"></i>
                Daftar Anggota Bermutasi
                @if(request()->hasAny(['search', 'dpc_id', 'dpd_id', 'tanggal_dari', 'tanggal_sampai']))
                    <span class="badge bg-warning text-dark ms-2">
                        {{ $anggotas->count() }} hasil
                    </span>
                @endif
            </h6>
        </div>
        <div class="card-body p-0">
            @if($anggotas->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">#</th>
                                <th width="25%">Anggota</th>
                                <th width="15%">DPC Asal</th>
                                <th width="15%">Jenjang</th>
                                <th width="15%">Tanggal Mutasi</th>
                                <th width="10%">Status</th>
                                <th width="15%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($anggotas as $index => $anggota)
                                @php
                                    $mutasiTerakhir = $anggota->mutasi->first();
                                @endphp
                                <tr>
                                    <td class="align-middle">
                                        {{ $anggotas->firstItem() + $index }}
                                    </td>
                                    <td class="align-middle">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm me-3">
                                                @if($anggota->hasPhoto())
                                                    <img src="{{ $anggota->getPhotoUrl() }}" 
                                                         alt="{{ $anggota->nama_lengkap }}" 
                                                         class="rounded-circle" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                @else
                                                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" 
                                                         style="width: 40px; height: 40px;">
                                                        <i class="fas fa-user"></i>
                                                    </div>
                                                @endif
                                            </div>
                                            <div>
                                                <h6 class="mb-1 text-dark">{{ $anggota->nama_lengkap }}</h6>
                                                <small class="text-muted">{{ $anggota->nomor_identitas_anggota }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="align-middle">
                                        <span class="text-dark">{{ $anggota->dpc->nama_dpc ?? '-' }}</span>
                                        <br>
                                        <small class="text-muted">{{ $anggota->dpd->nama_dpd ?? '-' }}</small>
                                    </td>
                                    <td class="align-middle">
                                        <span class="badge bg-info text-white">
                                            {{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? 'N/A' }}
                                        </span>
                                    </td>
                                    <td class="align-middle">
                                        @if($mutasiTerakhir)
                                            <div class="text-dark">
                                                {{ \Carbon\Carbon::parse($mutasiTerakhir->tanggal_sk)->format('d M Y') }}
                                            </div>
                                            <small class="text-muted">
                                                SK: {{ $mutasiTerakhir->nomor_sk }}
                                            </small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="align-middle">
                                        <span class="badge bg-warning text-dark">
                                            <i class="fas fa-exclamation-triangle me-1"></i>
                                            Tidak Aktif
                                        </span>
                                    </td>
                                    <td class="align-middle">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('anggota.show', $anggota->id) }}" 
                                               class="btn btn-sm btn-outline-info" 
                                               title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('mutasi.show', $mutasiTerakhir->id ?? '#') }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="Lihat Mutasi">
                                                <i class="fas fa-exchange-alt"></i>
                                            </a>
                                            <button type="button" 
                                                    class="btn btn-sm btn-outline-success" 
                                                    title="Kembalikan Status"
                                                    onclick="kembalikanStatus({{ $anggota->id }}, '{{ $anggota->nama_lengkap }}')">
                                                <i class="fas fa-undo"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-shopping-cart text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <h5 class="text-muted">Keranjang Mutasi Kosong</h5>
                    <p class="text-muted">Belum ada anggota yang bermutasi keluar.</p>
                    <a href="{{ route('mutasi.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>
                        Buat Mutasi Pertama
                    </a>
                </div>
            @endif
        </div>
        
        @if($anggotas->hasPages())
            <div class="card-footer bg-white">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted">
                        Menampilkan {{ $anggotas->firstItem() }} - {{ $anggotas->lastItem() }} 
                        dari {{ $anggotas->total() }} data
                    </div>
                    <div>
                        {{ $anggotas->links() }}
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<!-- Modal Konfirmasi Kembalikan Status -->
<div class="modal fade" id="modalKembalikanStatus" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-undo me-2"></i>
                    Konfirmasi Kembalikan Status
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin mengembalikan status anggota <strong id="namaAnggota"></strong> menjadi <strong>Aktif</strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Perhatian:</strong> Tindakan ini akan mengembalikan status anggota menjadi Aktif dan membatalkan mutasi terakhir.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i>
                    Batal
                </button>
                <form id="formKembalikanStatus" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check me-1"></i>
                        Ya, Kembalikan Status
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function kembalikanStatus(anggotaId, namaAnggota) {
    document.getElementById('namaAnggota').textContent = namaAnggota;
    document.getElementById('formKembalikanStatus').action = `/mutasi/kembalikan-status/${anggotaId}`;
    
    const modal = new bootstrap.Modal(document.getElementById('modalKembalikanStatus'));
    modal.show();
}

// Auto-submit form filter saat select berubah
document.addEventListener('DOMContentLoaded', function() {
    const selectElements = document.querySelectorAll('select[name="dpc_id"], select[name="dpd_id"]');
    selectElements.forEach(select => {
        select.addEventListener('change', function() {
            document.getElementById('filterForm').submit();
        });
    });
});
</script>
@endpush
