@extends('mobile.layout')

@section('title', 'Detail Mutasi - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-exchange-alt text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Detail Mutasi</h2>
                <p class="text-orange-100 text-sm">{{ ucfirst($mutasi->jenis_mutasi) }}</p>
            </div>
        </div>
    </div>

    <!-- Status Card -->
    <div class="mobile-card">
        <div class="flex items-center justify-between">
            <div>
                <h3 class="font-semibold text-gray-800">Status Pengajuan</h3>
                <p class="text-sm text-gray-600">Terakhir diperbarui: {{ \Carbon\Carbon::parse($mutasi->updated_at)->format('d M Y H:i') }}</p>
            </div>
            <div class="mobile-badge mobile-badge-{{ $mutasi->status_badge }}">
                {{ $mutasi->status_mutasi }}
            </div>
        </div>
    </div>

    <!-- Mutasi Details -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Detail Mutasi</h3>
        
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Jenis Mutasi:</span>
                <span class="font-medium">{{ ucfirst($mutasi->jenis_mutasi) }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Tanggal Pengajuan:</span>
                <span class="font-medium">{{ \Carbon\Carbon::parse($mutasi->created_at)->format('d M Y') }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Tanggal Mutasi:</span>
                <span class="font-medium">{{ \Carbon\Carbon::parse($mutasi->tanggal_mutasi)->format('d M Y') }}</span>
            </div>
            
            @if($mutasi->strukturDari)
            <div class="flex justify-between">
                <span class="text-gray-600">Dari:</span>
                <span class="font-medium">{{ $mutasi->strukturDari->nama_struktur }}</span>
            </div>
            @endif
            
            @if($mutasi->strukturKe)
            <div class="flex justify-between">
                <span class="text-gray-600">Ke:</span>
                <span class="font-medium">{{ $mutasi->strukturKe->nama_struktur }}</span>
            </div>
            @endif
        </div>
    </div>

    <!-- Alasan Mutasi -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Alasan Mutasi</h3>
        <p class="text-gray-700">{{ $mutasi->alasan_mutasi }}</p>
    </div>

    <!-- Alamat Tujuan (if Keluar) -->
    @if($mutasi->jenis_mutasi === 'Keluar' && $mutasi->alamat_tujuan)
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Alamat Tujuan</h3>
        <p class="text-gray-700">{{ $mutasi->alamat_tujuan }}</p>
    </div>
    @endif

    <!-- Catatan -->
    @if($mutasi->catatan)
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Catatan</h3>
        <p class="text-gray-700">{{ $mutasi->catatan }}</p>
    </div>
    @endif

    <!-- Approval Details (if approved) -->
    @if($mutasi->status_mutasi === 'Disetujui')
    <div class="mobile-card bg-green-50 border border-green-200">
        <h3 class="font-semibold text-green-800 mb-3">Detail Persetujuan</h3>
        
        <div class="space-y-2">
            @if($mutasi->disetujuiOleh)
            <div class="flex justify-between">
                <span class="text-green-700">Disetujui oleh:</span>
                <span class="font-medium text-green-800">{{ $mutasi->disetujuiOleh->name }}</span>
            </div>
            @endif
            
            @if($mutasi->tanggal_sk)
            <div class="flex justify-between">
                <span class="text-green-700">Tanggal SK:</span>
                <span class="font-medium text-green-800">{{ \Carbon\Carbon::parse($mutasi->tanggal_sk)->format('d M Y') }}</span>
            </div>
            @endif
            
            @if($mutasi->nomor_sk)
            <div class="flex justify-between">
                <span class="text-green-700">Nomor SK:</span>
                <span class="font-medium text-green-800">{{ $mutasi->nomor_sk }}</span>
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Rejection Details (if rejected) -->
    @if($mutasi->status_mutasi === 'Ditolak')
    <div class="mobile-card bg-red-50 border border-red-200">
        <h3 class="font-semibold text-red-800 mb-3">Alasan Penolakan</h3>
        <p class="text-red-700">Pengajuan mutasi Anda ditolak. Silakan hubungi administrator untuk informasi lebih lanjut.</p>
    </div>
    @endif

    <!-- Action Buttons -->
    <div class="mobile-card">
        <div class="space-y-3">
            @if($mutasi->status_mutasi === 'Pending')
            <div class="text-center py-4">
                <i class="fas fa-clock text-orange-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Menunggu Persetujuan</div>
                <div class="text-sm text-gray-600">Pengajuan Anda sedang dalam proses review</div>
            </div>
            @elseif($mutasi->status_mutasi === 'Disetujui')
            <div class="text-center py-4">
                <i class="fas fa-check-circle text-green-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Mutasi Disetujui</div>
                <div class="text-sm text-gray-600">Pengajuan mutasi Anda telah disetujui</div>
            </div>
            @elseif($mutasi->status_mutasi === 'Ditolak')
            <div class="text-center py-4">
                <i class="fas fa-times-circle text-red-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Mutasi Ditolak</div>
                <div class="text-sm text-gray-600">Pengajuan mutasi Anda ditolak</div>
            </div>
            @endif
            
            <div class="flex space-x-3">
                <a href="{{ route('mobile.mutasi') }}" class="mobile-button mobile-button-secondary flex-1">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali
                </a>
                
                @if($mutasi->status_mutasi === 'Ditolak')
                <a href="{{ route('mobile.mutasi.create') }}" class="mobile-button mobile-button-primary flex-1">
                    <i class="fas fa-plus mr-2"></i>
                    Ajukan Lagi
                </a>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
