@extends('mobile.layout')

@section('title', 'Dashboard - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Welcome Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-user text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Halo, {{ $anggota->nama_lengkap }}!</h2>
                <p class="text-orange-100 text-sm">{{ $anggota->refJenjang->nama_jenjang ?? 'Anggota' }}</p>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-2 gap-4">
        <div class="mobile-card text-center">
            <div class="text-2xl font-bold text-orange-500">{{ $upcomingKegiatan->count() }}</div>
            <div class="text-sm text-gray-600">Kegiatan Mendatang</div>
        </div>
        
        <div class="mobile-card text-center">
            <div class="text-2xl font-bold text-green-500">{{ $recentAttendance->count() }}</div>
            <div class="text-sm text-gray-600">Kehadiran Terbaru</div>
        </div>
    </div>

    <!-- Upcoming Activities -->
    @if($upcomingKegiatan->count() > 0)
    <div class="mobile-card">
        <div class="flex items-center justify-between mb-3">
            <h3 class="font-semibold text-gray-800">Kegiatan Mendatang</h3>
            <a href="{{ route('mobile.attendance') }}" class="text-orange-500 text-sm">Lihat Semua</a>
        </div>
        
        <div class="space-y-3">
            @foreach($upcomingKegiatan as $kegiatan)
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <div class="flex-1">
                    <h4 class="font-medium text-gray-800">{{ $kegiatan->nama_kegiatan }}</h4>
                    <div class="flex items-center text-sm text-gray-600 mt-1">
                        <i class="fas fa-calendar mr-2"></i>
                        <span>{{ \Carbon\Carbon::parse($kegiatan->tanggal_kegiatan)->format('d M Y') }}</span>
                        <i class="fas fa-clock ml-3 mr-1"></i>
                        <span>{{ \Carbon\Carbon::parse($kegiatan->waktu_mulai)->format('H:i') }}</span>
                    </div>
                </div>
                <a href="{{ route('mobile.attendance.detail', $kegiatan) }}" class="text-orange-500">
                    <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Recent Attendance -->
    @if($recentAttendance->count() > 0)
    <div class="mobile-card">
        <div class="flex items-center justify-between mb-3">
            <h3 class="font-semibold text-gray-800">Kehadiran Terbaru</h3>
            <a href="{{ route('mobile.attendance') }}" class="text-orange-500 text-sm">Lihat Semua</a>
        </div>
        
        <div class="space-y-3">
            @foreach($recentAttendance as $attendance)
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <div class="flex-1">
                    <h4 class="font-medium text-gray-800">{{ $attendance->kegiatan->nama_kegiatan }}</h4>
                    <div class="flex items-center text-sm text-gray-600 mt-1">
                        <i class="fas fa-calendar mr-2"></i>
                        <span>{{ $attendance->waktu_checkin_formatted }}</span>
                    </div>
                </div>
                <div class="mobile-badge mobile-badge-{{ $attendance->status_badge_class }}">
                    {{ $attendance->status_label }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Pending Mutasi -->
    @if($pendingMutasi->count() > 0)
    <div class="mobile-card">
        <div class="flex items-center justify-between mb-3">
            <h3 class="font-semibold text-gray-800">Pengajuan Mutasi</h3>
            <a href="{{ route('mobile.mutasi') }}" class="text-orange-500 text-sm">Lihat Semua</a>
        </div>
        
        <div class="space-y-3">
            @foreach($pendingMutasi as $mutasi)
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <div class="flex-1">
                    <h4 class="font-medium text-gray-800">{{ ucfirst($mutasi->jenis_mutasi) }}</h4>
                    <div class="flex items-center text-sm text-gray-600 mt-1">
                        <i class="fas fa-calendar mr-2"></i>
                        <span>{{ \Carbon\Carbon::parse($mutasi->created_at)->format('d M Y') }}</span>
                    </div>
                </div>
                <div class="mobile-badge mobile-badge-warning">
                    {{ $mutasi->status_mutasi }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Quick Actions -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Aksi Cepat</h3>
        
        <div class="grid grid-cols-2 gap-3">
            <a href="{{ route('mobile.attendance') }}" class="mobile-button mobile-button-primary">
                <i class="fas fa-calendar-check mr-2"></i>
                Lihat Absensi
            </a>
            
            <a href="{{ route('mobile.mutasi.create') }}" class="mobile-button mobile-button-secondary">
                <i class="fas fa-plus mr-2"></i>
                Ajukan Mutasi
            </a>
        </div>
    </div>
</div>
@endsection
