@extends('mobile.layout')

@section('title', 'Detail Absensi - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Activity Header -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-calendar-check text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">{{ $kegiatan->nama_kegiatan }}</h2>
                <p class="text-orange-100 text-sm">{{ $kegiatan->jenisKegiatan->nama_jenis_kegiatan ?? 'Kegiatan' }}</p>
            </div>
        </div>
    </div>

    <!-- Activity Details -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Detail Kegiatan</h3>
        
        <div class="space-y-3">
            <div class="flex items-center">
                <i class="fas fa-calendar w-5 text-orange-500 mr-3"></i>
                <div>
                    <div class="text-sm text-gray-600">Tanggal</div>
                    <div class="font-medium">{{ \Carbon\Carbon::parse($kegiatan->tanggal_kegiatan)->format('d M Y') }}</div>
                </div>
            </div>
            
            <div class="flex items-center">
                <i class="fas fa-clock w-5 text-orange-500 mr-3"></i>
                <div>
                    <div class="text-sm text-gray-600">Waktu</div>
                    <div class="font-medium">
                        {{ \Carbon\Carbon::parse($kegiatan->waktu_mulai)->format('H:i') }} - 
                        {{ \Carbon\Carbon::parse($kegiatan->waktu_selesai)->format('H:i') }}
                    </div>
                </div>
            </div>
            
            <div class="flex items-center">
                <i class="fas fa-map-marker-alt w-5 text-orange-500 mr-3"></i>
                <div>
                    <div class="text-sm text-gray-600">Tempat</div>
                    <div class="font-medium">{{ $kegiatan->tempat }}</div>
                </div>
            </div>
            
            @if($kegiatan->deskripsi)
            <div class="flex items-start">
                <i class="fas fa-info-circle w-5 text-orange-500 mr-3 mt-1"></i>
                <div>
                    <div class="text-sm text-gray-600">Deskripsi</div>
                    <div class="font-medium">{{ $kegiatan->deskripsi }}</div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Attendance Status -->
    @if($attendance)
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Status Kehadiran</h3>
        
        <div class="bg-green-50 border border-green-200 rounded-lg p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <i class="fas fa-check-circle text-green-500 text-xl mr-3"></i>
                    <div>
                        <div class="font-medium text-green-800">Sudah Check-in</div>
                        <div class="text-sm text-green-600">{{ $attendance->waktu_checkin_formatted }}</div>
                    </div>
                </div>
                <div class="mobile-badge mobile-badge-success">
                    {{ $attendance->status_label }}
                </div>
            </div>
            
            @if($attendance->waktu_checkout)
            <div class="mt-3 pt-3 border-t border-green-200">
                <div class="flex items-center">
                    <i class="fas fa-sign-out-alt text-green-500 mr-3"></i>
                    <div>
                        <div class="font-medium text-green-800">Check-out</div>
                        <div class="text-sm text-green-600">{{ $attendance->waktu_checkout->format('d/m/Y H:i:s') }}</div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Attendance Actions -->
    @if($isParticipant)
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Aksi Absensi</h3>
        
        @php
            $now = \Carbon\Carbon::now();
            $activityStart = \Carbon\Carbon::parse($kegiatan->tanggal_mulai . ' ' . $kegiatan->waktu_mulai);
            $activityEnd = \Carbon\Carbon::parse($kegiatan->tanggal_selesai . ' ' . $kegiatan->waktu_selesai);
            $canCheckin = $now->gte($activityStart->subMinutes(30)) && $now->lte($activityEnd) && !$attendance;
            $canCheckout = $attendance && !$attendance->waktu_checkout && $now->gte($activityStart);
        @endphp
        
        <div class="space-y-3">
            @if($canCheckin)
            <button id="checkin-btn" class="mobile-button mobile-button-success w-full">
                <i class="fas fa-sign-in-alt mr-2"></i>
                Check-in Sekarang
            </button>
            @elseif($canCheckout)
            <button id="checkout-btn" class="mobile-button mobile-button-primary w-full">
                <i class="fas fa-sign-out-alt mr-2"></i>
                Check-out
            </button>
            @elseif($attendance && $attendance->waktu_checkout)
            <div class="text-center py-4">
                <i class="fas fa-check-circle text-green-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Absensi Selesai</div>
                <div class="text-sm text-gray-600">Terima kasih telah berpartisipasi</div>
            </div>
            @elseif(!$attendance && $now->lt($activityStart->subMinutes(30)))
            <div class="text-center py-4">
                <i class="fas fa-clock text-orange-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Check-in Belum Dibuka</div>
                <div class="text-sm text-gray-600">Buka 30 menit sebelum kegiatan dimulai</div>
            </div>
            @elseif(!$attendance && $now->gt($activityEnd))
            <div class="text-center py-4">
                <i class="fas fa-times-circle text-red-500 text-3xl mb-2"></i>
                <div class="font-medium text-gray-800">Kegiatan Sudah Selesai</div>
                <div class="text-sm text-gray-600">Tidak dapat melakukan absensi</div>
            </div>
            @endif
        </div>
    </div>
    @else
    <div class="mobile-card">
        <div class="text-center py-4">
            <i class="fas fa-user-times text-orange-500 text-3xl mb-2"></i>
            <div class="font-medium text-gray-800">Bukan Peserta</div>
            <div class="text-sm text-gray-600">Anda tidak terdaftar sebagai peserta kegiatan ini</div>
        </div>
    </div>
    @endif

    <!-- QR Code Scanner (if available) -->
    @if($isParticipant && !$attendance)
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Scan QR Code</h3>
        
        <div class="mobile-qr-scanner" id="qr-scanner">
            <div class="text-center text-white">
                <i class="fas fa-qrcode text-4xl mb-2"></i>
                <div class="text-sm">Arahkan kamera ke QR Code</div>
            </div>
        </div>
        
        <div class="mt-3 text-center">
            <button onclick="toggleQRScanner()" class="mobile-button mobile-button-secondary">
                <i class="fas fa-camera mr-2"></i>
                Buka Scanner
            </button>
        </div>
    </div>
    @endif
</div>

<!-- Hidden inputs for JavaScript -->
<input type="hidden" id="kegiatan-id" value="{{ $kegiatan->id }}">
<input type="hidden" id="anggota-id" value="{{ $anggota->id }}">
@endsection

@push('scripts')
<script>
function toggleQRScanner() {
    // Toggle QR scanner visibility
    const scanner = document.getElementById('qr-scanner');
    if (scanner.style.display === 'none') {
        scanner.style.display = 'block';
        // Initialize camera here
    } else {
        scanner.style.display = 'none';
    }
}

// Check-in handler
document.getElementById('checkin-btn')?.addEventListener('click', async function() {
    const kegiatanId = document.getElementById('kegiatan-id').value;
    const anggotaId = document.getElementById('anggota-id').value;
    
    try {
        const response = await fetch('/mobile/attendance/checkin', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                kegiatan_id: kegiatanId,
                anggota_id: anggotaId
            })
        });
        
        const data = await response.json();
        
        if (data.success) {
            // Show success message
            showAlert(data.message, 'success');
            // Reload page after 2 seconds
            setTimeout(() => location.reload(), 2000);
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        showAlert('Terjadi kesalahan', 'danger');
    }
});

// Check-out handler
document.getElementById('checkout-btn')?.addEventListener('click', async function() {
    const kegiatanId = document.getElementById('kegiatan-id').value;
    const anggotaId = document.getElementById('anggota-id').value;
    
    try {
        const response = await fetch('/mobile/attendance/checkout', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                kegiatan_id: kegiatanId,
                anggota_id: anggotaId
            })
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            setTimeout(() => location.reload(), 2000);
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        showAlert('Terjadi kesalahan', 'danger');
    }
});

function showAlert(message, type) {
    const alertContainer = document.getElementById('alert-container');
    const alert = document.createElement('div');
    alert.className = `mobile-alert mobile-alert-${type} mobile-slide-up`;
    alert.innerHTML = `
        <div class="flex items-center justify-between">
            <span>${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-lg">&times;</button>
        </div>
    `;
    alertContainer.appendChild(alert);
    
    setTimeout(() => {
        if (alert.parentElement) {
            alert.remove();
        }
    }, 5000);
}
</script>
@endpush
