@extends('mobile.layout')

@section('title', 'Pilih Anggota - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-users text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Pilih Anggota</h2>
                <p class="text-orange-100 text-sm">Pilih anggota untuk mengakses mobile interface</p>
            </div>
        </div>
    </div>

    <!-- Search Box -->
    <div class="mobile-card">
        <div class="relative">
            <input type="text" id="search-anggota" class="mobile-input pl-10" placeholder="Cari nama anggota...">
            <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
        </div>
    </div>

    <!-- Anggota List -->
    @if($anggotas->count() > 0)
    <div class="space-y-3" id="anggota-list">
        @foreach($anggotas as $anggota)
        <div class="mobile-card mobile-touchable anggota-item" 
             data-nama="{{ strtolower($anggota->nama_lengkap) }}"
             data-nik="{{ strtolower($anggota->nomor_identitas_anggota) }}"
             onclick="selectAnggota({{ $anggota->id }}, '{{ $anggota->nama_lengkap }}')">
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-orange-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-user text-orange-500 text-xl"></i>
                </div>
                <div class="flex-1">
                    <h3 class="font-semibold text-gray-800">{{ $anggota->nama_lengkap }}</h3>
                    <p class="text-sm text-gray-600">NIK: {{ $anggota->nomor_identitas_anggota }}</p>
                </div>
                <div class="text-orange-500">
                    <i class="fas fa-arrow-right"></i>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <!-- No Results (Hidden by default) -->
    <div id="no-results" class="mobile-card text-center py-8" style="display: none;">
        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-search text-3xl text-gray-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-800 mb-2">Tidak Ditemukan</h3>
        <p class="text-gray-600">Tidak ada anggota yang sesuai dengan pencarian</p>
    </div>

    @else
    <!-- Empty State -->
    <div class="mobile-card text-center py-8">
        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-users text-3xl text-gray-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-800 mb-2">Tidak Ada Anggota</h3>
        <p class="text-gray-600">Belum ada data anggota yang tersedia</p>
    </div>
    @endif

    <!-- Info Card -->
    <div class="mobile-card bg-blue-50 border border-blue-200">
        <div class="flex items-start space-x-3">
            <i class="fas fa-info-circle text-blue-500 text-lg mt-1"></i>
            <div>
                <h4 class="font-medium text-blue-800 mb-1">Informasi</h4>
                <p class="text-sm text-blue-700">
                    Pilih anggota untuk mengakses fitur mobile seperti absensi dan mutasi. 
                    Data yang ditampilkan akan sesuai dengan anggota yang dipilih.
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Search functionality
document.getElementById('search-anggota').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const anggotaItems = document.querySelectorAll('.anggota-item');
    const noResults = document.getElementById('no-results');
    let visibleCount = 0;
    
    anggotaItems.forEach(item => {
        const nama = item.dataset.nama;
        const nik = item.dataset.nik;
        
        if (nama.includes(searchTerm) || nik.includes(searchTerm)) {
            item.style.display = 'block';
            visibleCount++;
        } else {
            item.style.display = 'none';
        }
    });
    
    // Show/hide no results message
    if (visibleCount === 0 && searchTerm.length > 0) {
        noResults.style.display = 'block';
    } else {
        noResults.style.display = 'none';
    }
});

// Select anggota function
function selectAnggota(anggotaId, namaAnggota) {
    // Show loading
    const loading = document.createElement('div');
    loading.className = 'mobile-loading fixed inset-0 bg-black bg-opacity-50 z-50';
    loading.innerHTML = '<div class="mobile-spinner"></div>';
    document.body.appendChild(loading);
    
    // Redirect to dashboard with selected anggota
    setTimeout(() => {
        window.location.href = `/mobile?anggota_id=${anggotaId}`;
    }, 500);
}

// Add touch feedback
document.querySelectorAll('.anggota-item').forEach(item => {
    item.addEventListener('touchstart', function() {
        this.classList.add('active:scale-95');
    });
    
    item.addEventListener('touchend', function() {
        setTimeout(() => {
            this.classList.remove('active:scale-95');
        }, 150);
    });
});
</script>
@endpush
